/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.Net;
import com.badlogic.gdx.backends.gwt.GwtApplicationConfiguration;
import com.badlogic.gdx.net.HttpStatus;
import com.badlogic.gdx.net.ServerSocket;
import com.badlogic.gdx.net.ServerSocketHints;
import com.badlogic.gdx.net.Socket;
import com.badlogic.gdx.net.SocketHints;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.google.gwt.http.client.Header;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GwtNet
implements Net {
    ObjectMap<Net.HttpRequest, Request> requests;
    ObjectMap<Net.HttpRequest, Net.HttpResponseListener> listeners;
    GwtApplicationConfiguration config;

    public GwtNet(GwtApplicationConfiguration config) {
        this.config = config;
        this.requests = new ObjectMap();
        this.listeners = new ObjectMap();
    }

    public void sendHttpRequest(final Net.HttpRequest httpRequest, final Net.HttpResponseListener httpResultListener) {
        RequestBuilder builder;
        if (httpRequest.getUrl() == null) {
            httpResultListener.failed((Throwable)new GdxRuntimeException("can't process a HTTP request without URL set"));
            return;
        }
        String method = httpRequest.getMethod();
        String value = httpRequest.getContent();
        boolean valueInBody = method.equalsIgnoreCase("POST") || method.equals("PUT");
        String url = httpRequest.getUrl();
        if (method.equalsIgnoreCase("HEAD")) {
            if (value != null) {
                url = url + "?" + value;
            }
            builder = new RequestBuilder(RequestBuilder.HEAD, url);
        } else if (method.equalsIgnoreCase("GET")) {
            if (value != null) {
                url = url + "?" + value;
            }
            builder = new RequestBuilder(RequestBuilder.GET, url);
        } else if (method.equalsIgnoreCase("POST")) {
            builder = new RequestBuilder(RequestBuilder.POST, url);
        } else if (method.equalsIgnoreCase("DELETE")) {
            if (value != null) {
                url = url + "?" + value;
            }
            builder = new RequestBuilder(RequestBuilder.DELETE, url);
        } else if (method.equalsIgnoreCase("PUT")) {
            builder = new RequestBuilder(RequestBuilder.PUT, url);
        } else {
            throw new GdxRuntimeException("Unsupported HTTP Method");
        }
        Map content = httpRequest.getHeaders();
        Set keySet = content.keySet();
        for (String name : keySet) {
            builder.setHeader(name, (String)content.get(name));
        }
        builder.setTimeoutMillis(httpRequest.getTimeOut());
        builder.setIncludeCredentials(httpRequest.getIncludeCredentials());
        try {
            Request request = builder.sendRequest(valueInBody ? value : null, new RequestCallback(){

                public void onResponseReceived(Request request, Response response) {
                    if (response.getStatusCode() > 0) {
                        httpResultListener.handleHttpResponse((Net.HttpResponse)new HttpClientResponse(response));
                        GwtNet.this.requests.remove((Object)httpRequest);
                        GwtNet.this.listeners.remove((Object)httpRequest);
                    } else {
                        this.onError(request, new IOException("HTTP request failed"));
                    }
                }

                public void onError(Request request, Throwable exception) {
                    httpResultListener.failed(exception);
                    GwtNet.this.requests.remove((Object)httpRequest);
                    GwtNet.this.listeners.remove((Object)httpRequest);
                }
            });
            this.requests.put((Object)httpRequest, (Object)request);
            this.listeners.put((Object)httpRequest, (Object)httpResultListener);
        }
        catch (Throwable e) {
            httpResultListener.failed(e);
        }
    }

    public void cancelHttpRequest(Net.HttpRequest httpRequest) {
        Net.HttpResponseListener httpResponseListener = (Net.HttpResponseListener)this.listeners.get((Object)httpRequest);
        Request request = (Request)this.requests.get((Object)httpRequest);
        if (httpResponseListener != null && request != null) {
            request.cancel();
            httpResponseListener.cancelled();
            this.requests.remove((Object)httpRequest);
            this.listeners.remove((Object)httpRequest);
        }
    }

    public boolean isHttpRequestPending(Net.HttpRequest httpRequest) {
        return this.listeners.get((Object)httpRequest) != null && this.requests.get((Object)httpRequest) != null;
    }

    public ServerSocket newServerSocket(Net.Protocol protocol, String hostname, int port, ServerSocketHints hints) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ServerSocket newServerSocket(Net.Protocol protocol, int port, ServerSocketHints hints) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Socket newClientSocket(Net.Protocol protocol, String host, int port, SocketHints hints) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean openURI(String URI2) {
        if (this.config.openURLInNewWindow) {
            Window.open((String)URI2, (String)"_blank", null);
        } else {
            Window.Location.assign((String)URI2);
        }
        return true;
    }

    private final class HttpClientResponse
    implements Net.HttpResponse {
        private Response response;
        private HttpStatus status;

        public HttpClientResponse(Response response) {
            this.response = response;
            this.status = new HttpStatus(response.getStatusCode());
        }

        public byte[] getResult() {
            throw new GdxRuntimeException("HttpResponse.getResult() is not available on GWT. Use getResultAsString() if possible, or make use of AssetDownloader class.");
        }

        public String getResultAsString() {
            return this.response.getText();
        }

        public InputStream getResultAsStream() {
            throw new GdxRuntimeException("HttpResponse.getResultAsStream() is not available on GWT. Use getResultAsString() if possible, or make use of AssetDownloader class.");
        }

        public HttpStatus getStatus() {
            return this.status;
        }

        public Map<String, List<String>> getHeaders() {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            Header[] responseHeaders = this.response.getHeaders();
            for (int i = 0; i < responseHeaders.length; ++i) {
                Header header = responseHeaders[i];
                if (header == null) continue;
                String headerName = responseHeaders[i].getName();
                ArrayList<String> headerValues = (ArrayList<String>)headers.get(headerName);
                if (headerValues == null) {
                    headerValues = new ArrayList<String>();
                    headers.put(headerName, headerValues);
                }
                headerValues.add(responseHeaders[i].getValue());
            }
            return headers;
        }

        public String getHeader(String name) {
            return this.response.getHeader(name);
        }
    }
}

