/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.preloader;

import com.badlogic.gdx.backends.gwt.preloader.AssetFilter;
import com.badlogic.gdx.backends.gwt.preloader.DefaultAssetFilter;
import com.badlogic.gdx.backends.gwt.preloader.FileWrapper;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.net.URLConnection;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PreloaderBundleGenerator
extends Generator {
    public String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        System.out.println(new File(".").getAbsolutePath());
        String assetPath = this.getAssetPath(context);
        String assetOutputPath = this.getAssetOutputPath(context);
        if (assetOutputPath == null) {
            assetOutputPath = "war/";
        }
        AssetFilter assetFilter = this.getAssetFilter(context);
        FileWrapper source = new FileWrapper(assetPath);
        if (!source.exists() && !(source = new FileWrapper("../" + assetPath)).exists()) {
            throw new RuntimeException("assets path '" + assetPath + "' does not exist. Check your gdx.assetpath property in your GWT project's module gwt.xml file");
        }
        if (!source.isDirectory()) {
            throw new RuntimeException("assets path '" + assetPath + "' is not a directory. Check your gdx.assetpath property in your GWT project's module gwt.xml file");
        }
        System.out.println("Copying resources from " + assetPath + " to " + assetOutputPath);
        System.out.println(source.file.getAbsolutePath());
        FileWrapper target = new FileWrapper("assets/");
        System.out.println(target.file.getAbsolutePath());
        if (!target.file.getAbsolutePath().replace("\\", "/").endsWith(assetOutputPath + "assets")) {
            target = new FileWrapper(assetOutputPath + "assets/");
        }
        if (target.exists() && !target.deleteDirectory()) {
            throw new RuntimeException("Couldn't clean target path '" + target + "'");
        }
        ArrayList<Asset> assets = new ArrayList<Asset>();
        this.copyDirectory(source, target, assetFilter, assets);
        List<String> classpathFiles = this.getClasspathFiles(context);
        for (String classpathFile : classpathFiles) {
            if (!assetFilter.accept(classpathFile, false)) continue;
            FileWrapper fileWrapper = target.child(classpathFile);
            FileWrapper dest = target.child(fileWrapper.name());
            try {
                InputStream resourceStream = context.getClass().getClassLoader().getResourceAsStream(classpathFile);
                this.copy(resourceStream, fileWrapper.path(), dest, assetFilter, assets);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HashMap<String, ArrayList<Asset>> bundles = new HashMap<String, ArrayList<Asset>>();
        for (Asset asset : assets) {
            ArrayList<Asset> bundleAssets;
            String bundleName = assetFilter.getBundleName(asset.file.path());
            if (bundleName == null) {
                bundleName = "assets";
            }
            if ((bundleAssets = (ArrayList<Asset>)bundles.get(bundleName)) == null) {
                bundleAssets = new ArrayList<Asset>();
                bundles.put(bundleName, bundleAssets);
            }
            bundleAssets.add(asset);
        }
        for (Map.Entry entry : bundles.entrySet()) {
            StringBuilder sb = new StringBuilder();
            for (Asset asset : (ArrayList)entry.getValue()) {
                String pathMd5;
                String pathOrig = asset.filePathOrig.replace('\\', '/').replace(assetOutputPath, "").replaceFirst("assets/", "");
                if (pathOrig.startsWith("/")) {
                    pathOrig = pathOrig.substring(1);
                }
                if ((pathMd5 = asset.file.path().replace('\\', '/').replace(assetOutputPath, "").replaceFirst("assets/", "")).startsWith("/")) {
                    pathMd5 = pathMd5.substring(1);
                }
                sb.append(asset.type.code);
                sb.append(":");
                sb.append(pathOrig);
                sb.append(":");
                sb.append(pathMd5);
                sb.append(":");
                sb.append(asset.file.isDirectory() ? 0L : asset.file.length());
                sb.append(":");
                String mimetype = URLConnection.guessContentTypeFromName(asset.file.name());
                sb.append(mimetype == null ? "application/unknown" : mimetype);
                sb.append(":");
                sb.append((char)(asset.file.isDirectory() || assetFilter.preload(pathOrig) ? 49 : 48));
                sb.append("\n");
            }
            target.child((String)entry.getKey() + ".txt").writeString(sb.toString(), false);
        }
        return this.createDummyClass(logger, context);
    }

    private void copyFile(FileWrapper source, String filePathOrig, FileWrapper dest, AssetFilter filter, ArrayList<Asset> assets) {
        if (!filter.accept(filePathOrig, false)) {
            return;
        }
        try {
            this.copy(source.read(), filePathOrig, dest, filter, assets);
        }
        catch (IOException e) {
            throw new GdxRuntimeException("Error copying source file: " + source + "\nTo destination: " + dest, (Throwable)e);
        }
    }

    private void copyDirectory(FileWrapper sourceDir, FileWrapper destDir, AssetFilter filter, ArrayList<Asset> assets) {
        FileWrapper[] files;
        if (!filter.accept(destDir.path(), true)) {
            return;
        }
        assets.add(new Asset(destDir.path(), destDir, AssetFilter.AssetType.Directory));
        destDir.mkdirs();
        for (FileWrapper srcFile : files = sourceDir.list()) {
            FileWrapper destFile;
            if (srcFile.isDirectory()) {
                destFile = destDir.child(srcFile.name());
                this.copyDirectory(srcFile, destFile, filter, assets);
                continue;
            }
            destFile = destDir.child(srcFile.name());
            this.copyFile(srcFile, destDir.child(srcFile.name()).path(), destFile, filter, assets);
        }
    }

    private void copy(InputStream source, String filePathOrig, FileWrapper dest, AssetFilter filter, ArrayList<Asset> assets) throws IOException {
        try (InputStream in = source;){
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                DigestInputStream digestInputStream = new DigestInputStream(in, digest);
                dest.write(digestInputStream, false);
                FileWrapper newDest = dest.parent().child(PreloaderBundleGenerator.fileNameWithHash(dest, digest));
                Files.move(PreloaderBundleGenerator.toPath(dest.file()), PreloaderBundleGenerator.toPath(newDest.file()), StandardCopyOption.REPLACE_EXISTING);
                assets.add(new Asset(filePathOrig, newDest, filter.getType(dest.path())));
            }
            catch (NoSuchAlgorithmException e) {
                FileWrapper newDest = dest.parent().child(PreloaderBundleGenerator.fileNameWithTimestamp(dest));
                newDest.write(in, false);
                assets.add(new Asset(filePathOrig, newDest, filter.getType(dest.path())));
            }
        }
    }

    private AssetFilter getAssetFilter(GeneratorContext context) {
        ConfigurationProperty assetFilterClassProperty;
        try {
            assetFilterClassProperty = context.getPropertyOracle().getConfigurationProperty("gdx.assetfilterclass");
        }
        catch (BadPropertyValueException e) {
            return new DefaultAssetFilter();
        }
        if (assetFilterClassProperty.getValues().size() == 0) {
            return new DefaultAssetFilter();
        }
        String assetFilterClass = (String)assetFilterClassProperty.getValues().get(0);
        if (assetFilterClass == null) {
            return new DefaultAssetFilter();
        }
        try {
            return (AssetFilter)Class.forName(assetFilterClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't instantiate custom AssetFilter '" + assetFilterClass + "', make sure the class is public and has a public default constructor", e);
        }
    }

    private String getAssetPath(GeneratorContext context) {
        String[] tokens;
        ConfigurationProperty assetPathProperty;
        try {
            assetPathProperty = context.getPropertyOracle().getConfigurationProperty("gdx.assetpath");
        }
        catch (BadPropertyValueException e) {
            throw new RuntimeException("No gdx.assetpath defined. Add <set-configuration-property name=\"gdx.assetpath\" value=\"relative/path/to/assets/\"/> to your GWT projects gwt.xml file");
        }
        if (assetPathProperty.getValues().size() == 0) {
            throw new RuntimeException("No gdx.assetpath defined. Add <set-configuration-property name=\"gdx.assetpath\" value=\"relative/path/to/assets/\"/> to your GWT projects gwt.xml file");
        }
        String paths = (String)assetPathProperty.getValues().get(0);
        if (paths == null) {
            throw new RuntimeException("No gdx.assetpath defined. Add <set-configuration-property name=\"gdx.assetpath\" value=\"relative/path/to/assets/\"/> to your GWT projects gwt.xml file");
        }
        for (String token : tokens = paths.split(",")) {
            System.out.println(token);
            if (!new FileWrapper(token).exists() && !new FileWrapper("../" + token).exists()) continue;
            return token;
        }
        throw new RuntimeException("No valid gdx.assetpath defined. Fix <set-configuration-property name=\"gdx.assetpath\" value=\"relative/path/to/assets/\"/> in your GWT projects gwt.xml file");
    }

    private String getAssetOutputPath(GeneratorContext context) {
        ConfigurationProperty assetPathProperty;
        try {
            assetPathProperty = context.getPropertyOracle().getConfigurationProperty("gdx.assetoutputpath");
        }
        catch (BadPropertyValueException e) {
            return null;
        }
        if (assetPathProperty.getValues().size() == 0) {
            return null;
        }
        String paths = (String)assetPathProperty.getValues().get(0);
        if (paths == null) {
            return null;
        }
        String[] tokens = paths.split(",");
        String path = null;
        for (String token : tokens) {
            if (!new FileWrapper(token).exists() && !new FileWrapper(token).mkdirs()) continue;
            path = token;
        }
        if (path != null && !path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    private List<String> getClasspathFiles(GeneratorContext context) {
        ArrayList<String> classpathFiles = new ArrayList<String>();
        try {
            ConfigurationProperty prop = context.getPropertyOracle().getConfigurationProperty("gdx.files.classpath");
            classpathFiles.addAll(prop.getValues());
        }
        catch (BadPropertyValueException badPropertyValueException) {
            // empty catch block
        }
        return classpathFiles;
    }

    private String createDummyClass(TreeLogger logger, GeneratorContext context) {
        String packageName = "com.badlogic.gdx.backends.gwt.preloader";
        String className = "PreloaderBundleImpl";
        ClassSourceFileComposerFactory composer = new ClassSourceFileComposerFactory(packageName, className);
        composer.addImplementedInterface(packageName + ".PreloaderBundle");
        PrintWriter printWriter = context.tryCreate(logger, packageName, className);
        if (printWriter == null) {
            return packageName + "." + className;
        }
        SourceWriter sourceWriter = composer.createSourceWriter(context, printWriter);
        sourceWriter.commit(logger);
        return packageName + "." + className;
    }

    private static String fileNameWithHash(FileWrapper fw, MessageDigest digest) {
        String hash = String.format("%032x", new BigInteger(1, digest.digest()));
        String nameWithHash = fw.nameWithoutExtension() + "-" + hash;
        String extension = fw.extension();
        if (!extension.isEmpty() || fw.name().endsWith(".")) {
            nameWithHash = nameWithHash + "." + extension;
        }
        return nameWithHash;
    }

    private static String fileNameWithTimestamp(FileWrapper fw) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String nameWithTimestamp = fw.nameWithoutExtension() + "-" + timestamp;
        String extension = fw.extension();
        if (!extension.isEmpty() || fw.name().endsWith(".")) {
            nameWithTimestamp = nameWithTimestamp + "." + extension;
        }
        return nameWithTimestamp;
    }

    private static Path toPath(File file) {
        return FileSystems.getDefault().getPath(file.getPath(), new String[0]);
    }

    private class Asset {
        String filePathOrig;
        FileWrapper file;
        AssetFilter.AssetType type;

        public Asset(String filePathOrig, FileWrapper file, AssetFilter.AssetType type) {
            this.filePathOrig = filePathOrig;
            this.file = file;
            this.type = type;
        }
    }
}

