/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.widgets;

import com.badlogic.gdx.backends.gwt.widgets.PlaceholderTextBox;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class TextInputDialogBox
extends DialogBox {
    private PlaceholderTextBox textBox;
    TextInputDialogListener listener;

    public TextInputDialogBox(String title, String text, String placeholder) {
        this.setText(title);
        VerticalPanel vPanel = new VerticalPanel();
        HorizontalPanel hPanel = new HorizontalPanel();
        this.setAnimationEnabled(true);
        this.setGlassEnabled(true);
        this.center();
        vPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        Button ok = new Button("OK");
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TextInputDialogBox.this.onPositive();
            }
        });
        Button cancel = new Button("Cancel");
        cancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                TextInputDialogBox.this.onNegative();
            }
        });
        hPanel.add((Widget)ok);
        hPanel.add((Widget)cancel);
        this.textBox = new PlaceholderTextBox();
        this.textBox.setPlaceholder(placeholder);
        this.textBox.setWidth("97%");
        this.textBox.setText(text);
        vPanel.add((Widget)this.textBox);
        vPanel.add((Widget)hPanel);
        this.setWidget((Widget)vPanel);
    }

    public void setInputType(String type) {
        this.textBox.setType(type);
    }

    protected void onPositive() {
        if (this.listener != null) {
            this.listener.onPositive(this.textBox.getText());
        }
        this.hide();
    }

    protected void onNegative() {
        if (this.listener != null) {
            this.listener.onNegative();
        }
        this.hide();
    }

    public void setListener(TextInputDialogListener listener) {
        this.listener = listener;
    }

    public static interface TextInputDialogListener {
        public void onPositive(String var1);

        public void onNegative();
    }
}

