/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gwtref.client;

import com.badlogic.gwtref.client.CachedTypeLookup;
import com.badlogic.gwtref.client.ReflectionCache;
import com.badlogic.gwtref.client.Type;
import java.lang.annotation.Annotation;
import java.util.Arrays;

public class Field {
    final String name;
    final CachedTypeLookup enclosingType;
    final CachedTypeLookup type;
    final boolean isFinal;
    final boolean isDefaultAccess;
    final boolean isPrivate;
    final boolean isProtected;
    final boolean isPublic;
    final boolean isStatic;
    final boolean isTransient;
    final boolean isVolatile;
    final int getter;
    final int setter;
    final CachedTypeLookup[] elementTypes;
    final Annotation[] annotations;

    Field(String name, Class enclosingType, Class type, boolean isFinal, boolean isDefaultAccess, boolean isPrivate, boolean isProtected, boolean isPublic, boolean isStatic, boolean isTransient, boolean isVolatile, int getter, int setter, Class[] elementTypes, Annotation[] annotations) {
        this.name = name;
        this.enclosingType = new CachedTypeLookup(enclosingType);
        this.type = new CachedTypeLookup(type);
        this.isFinal = isFinal;
        this.isDefaultAccess = isDefaultAccess;
        this.isPrivate = isPrivate;
        this.isProtected = isProtected;
        this.isPublic = isPublic;
        this.isStatic = isStatic;
        this.isTransient = isTransient;
        this.isVolatile = isVolatile;
        this.getter = getter;
        this.setter = setter;
        CachedTypeLookup[] tmp = null;
        if (elementTypes != null) {
            tmp = new CachedTypeLookup[elementTypes.length];
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = new CachedTypeLookup(elementTypes[i]);
            }
        }
        this.elementTypes = tmp;
        this.annotations = annotations != null ? annotations : new Annotation[]{};
    }

    public Object get(Object obj) throws IllegalAccessException {
        return ReflectionCache.getFieldValue(this, obj);
    }

    public void set(Object obj, Object value) throws IllegalAccessException {
        ReflectionCache.setFieldValue(this, obj, value);
    }

    public Type getElementType(int index) {
        if (this.elementTypes != null && index >= 0 && index < this.elementTypes.length) {
            return this.elementTypes[index].getType();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public Type getEnclosingType() {
        return this.enclosingType.getType();
    }

    public Type getType() {
        return this.type.getType();
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isDefaultAccess() {
        return this.isDefaultAccess;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return "Field [name=" + this.name + ", enclosingType=" + this.enclosingType + ", type=" + this.type + ", isFinal=" + this.isFinal + ", isDefaultAccess=" + this.isDefaultAccess + ", isPrivate=" + this.isPrivate + ", isProtected=" + this.isProtected + ", isPublic=" + this.isPublic + ", isStatic=" + this.isStatic + ", isTransient=" + this.isTransient + ", isVolatile=" + this.isVolatile + ", getter=" + this.getter + ", setter=" + this.setter + ", elementTypes=" + Arrays.toString(this.elementTypes) + ", annotations=" + Arrays.toString(this.annotations) + "]";
    }
}

