/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gwtref.client;

import com.badlogic.gwtref.client.CachedTypeLookup;
import com.badlogic.gwtref.client.Parameter;
import com.badlogic.gwtref.client.ReflectionCache;
import com.badlogic.gwtref.client.Type;
import java.lang.annotation.Annotation;
import java.util.Arrays;

public class Method {
    private static final Parameter[] EMPTY_PARAMS = new Parameter[0];
    final String name;
    final CachedTypeLookup enclosingType;
    final CachedTypeLookup returnType;
    final boolean isAbstract;
    final boolean isFinal;
    final boolean isStatic;
    final boolean isNative;
    final boolean isDefaultAccess;
    final boolean isPrivate;
    final boolean isProtected;
    final boolean isPublic;
    final boolean isVarArgs;
    final boolean isMethod;
    final boolean isConstructor;
    final Parameter[] parameters;
    final int methodId;
    final Annotation[] annotations;

    public Method(String name, Class enclosingType, Class returnType, Parameter[] parameters, boolean isAbstract, boolean isFinal, boolean isStatic, boolean isDefaultAccess, boolean isPrivate, boolean isProtected, boolean isPublic, boolean isNative, boolean isVarArgs, boolean isMethod, boolean isConstructor, int methodId, Annotation[] annotations) {
        this.name = name;
        this.enclosingType = new CachedTypeLookup(enclosingType);
        this.parameters = parameters != null ? parameters : EMPTY_PARAMS;
        this.returnType = new CachedTypeLookup(returnType);
        this.isAbstract = isAbstract;
        this.isFinal = isFinal;
        this.isStatic = isStatic;
        this.isNative = isNative;
        this.isDefaultAccess = isDefaultAccess;
        this.isPrivate = isPrivate;
        this.isProtected = isProtected;
        this.isPublic = isPublic;
        this.isVarArgs = isVarArgs;
        this.isMethod = isMethod;
        this.isConstructor = isConstructor;
        this.methodId = methodId;
        this.annotations = annotations;
    }

    public Class getEnclosingType() {
        return this.enclosingType.clazz;
    }

    public Class getReturnType() {
        return this.returnType.clazz;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isDefaultAccess() {
        return this.isDefaultAccess;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isMethod() {
        return this.isMethod;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.annotations;
    }

    public Object invoke(Object obj, Object ... params) {
        if (this.parameters.length != (params != null ? params.length : 0)) {
            throw new IllegalArgumentException("Parameter mismatch");
        }
        return ReflectionCache.invoke(this, obj, params);
    }

    boolean match(String name, Class ... types) {
        return this.name.equals(name) && this.match(types);
    }

    boolean match(Class ... types) {
        if (types == null) {
            return this.parameters.length == 0;
        }
        if (types.length != this.parameters.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            Type t2;
            Type t1 = this.parameters[i].getType();
            if (t1 == (t2 = ReflectionCache.getType(types[i])) || t1.isAssignableFrom(t2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Method [name=" + this.name + ", enclosingType=" + this.enclosingType + ", returnType=" + this.returnType + ", isAbstract=" + this.isAbstract + ", isFinal=" + this.isFinal + ", isStatic=" + this.isStatic + ", isNative=" + this.isNative + ", isDefaultAccess=" + this.isDefaultAccess + ", isPrivate=" + this.isPrivate + ", isProtected=" + this.isProtected + ", isPublic=" + this.isPublic + ", isVarArgs=" + this.isVarArgs + ", isMethod=" + this.isMethod + ", isConstructor=" + this.isConstructor + ", parameters=" + Arrays.toString(this.parameters) + "]";
    }
}

