/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gwtref.gen;

import com.badlogic.gwtref.gen.ReflectionCacheSourceCreator;
import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPackage;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ReflectionCacheGenerator
extends Generator {
    private GeneratorContext context;
    private TreeLogger logger;
    int nesting = 0;

    public String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        this.context = context;
        this.logger = logger;
        TypeOracle oracle = context.getTypeOracle();
        assert (oracle != null);
        JClassType jType = oracle.findType(typeName);
        if (jType == null) {
            logger.log(TreeLogger.ERROR, "Couldn't find type '" + typeName + "'");
            throw new UnableToCompleteException();
        }
        if (jType.isInterface() == null) {
            logger.log(TreeLogger.ERROR, "Type '" + typeName + "' must be an interface");
            throw new UnableToCompleteException();
        }
        TypeOracle typeOracle = context.getTypeOracle();
        JPackage[] packages = typeOracle.getPackages();
        ArrayList<JType> types = new ArrayList<JType>();
        for (JPackage p : packages) {
            for (JClassType t : p.getTypes()) {
                this.gatherTypes((JType)t.getErasedType(), types);
            }
        }
        try {
            ConfigurationProperty prop = context.getPropertyOracle().getConfigurationProperty("gdx.reflect.include");
            for (String s : prop.getValues()) {
                JClassType type = typeOracle.findType(s);
                if (type == null) continue;
                this.gatherTypes((JType)type.getErasedType(), types);
            }
        }
        catch (BadPropertyValueException prop) {
            // empty catch block
        }
        this.gatherTypes((JType)typeOracle.findType("java.util.List").getErasedType(), types);
        this.gatherTypes((JType)typeOracle.findType("java.util.ArrayList").getErasedType(), types);
        this.gatherTypes((JType)typeOracle.findType("java.util.HashMap").getErasedType(), types);
        this.gatherTypes((JType)typeOracle.findType("java.util.Map").getErasedType(), types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.String").getErasedType(), types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Boolean").getErasedType(), types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Byte").getErasedType(), types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Long").getErasedType(), types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Character").getErasedType(), types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Short").getErasedType(), types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Integer").getErasedType(), types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Float").getErasedType(), types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.CharSequence").getErasedType(), types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Double").getErasedType(), types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Object").getErasedType(), types);
        Collections.sort(types, new Comparator<JType>(){

            @Override
            public int compare(JType o1, JType o2) {
                return o1.getQualifiedSourceName().compareTo(o2.getQualifiedSourceName());
            }
        });
        List<Object> split = typeName.contains("IReflectionCache2") ? types.subList(types.size() / 2, types.size()) : types.subList(0, types.size() / 2);
        ReflectionCacheSourceCreator source = new ReflectionCacheSourceCreator(logger, context, jType, split);
        return source.create();
    }

    private void out(String message, int nesting) {
        String nestedMsg = "";
        for (int i = 0; i < nesting; ++i) {
            nestedMsg = nestedMsg + "  ";
        }
        nestedMsg = nestedMsg + message;
        this.logger.log(TreeLogger.Type.INFO, nestedMsg);
    }

    private void gatherTypes(JType type, List<JType> types) {
        JClassType[] inner;
        JMethod[] methods;
        ++this.nesting;
        if (type == null) {
            --this.nesting;
            return;
        }
        if (type.getQualifiedSourceName().contains("-")) {
            --this.nesting;
            return;
        }
        if (!ReflectionCacheSourceCreator.isVisible(type)) {
            --this.nesting;
            return;
        }
        boolean keep = false;
        String name = type.getQualifiedSourceName();
        try {
            keep |= !name.contains(".");
            ConfigurationProperty prop = this.context.getPropertyOracle().getConfigurationProperty("gdx.reflect.include");
            for (String string : prop.getValues()) {
                keep |= name.contains(string);
            }
            prop = this.context.getPropertyOracle().getConfigurationProperty("gdx.reflect.exclude");
            for (String string : prop.getValues()) {
                keep &= !name.equals(string);
            }
        }
        catch (BadPropertyValueException e) {
            e.printStackTrace();
        }
        if (!keep) {
            --this.nesting;
            return;
        }
        if (types.contains(type.getErasedType())) {
            --this.nesting;
            return;
        }
        types.add(type.getErasedType());
        this.out(type.getErasedType().getQualifiedSourceName(), this.nesting);
        if (type instanceof JPrimitiveType) {
            --this.nesting;
            return;
        }
        JClassType c = (JClassType)type;
        JField[] fields = c.getFields();
        if (fields != null) {
            for (JField field : fields) {
                this.gatherTypes(field.getType().getErasedType(), types);
            }
        }
        this.gatherTypes((JType)c.getSuperclass(), types);
        JClassType[] jClassTypeArray = c.getImplementedInterfaces();
        if (jClassTypeArray != null) {
            for (JClassType i : jClassTypeArray) {
                this.gatherTypes((JType)i.getErasedType(), types);
            }
        }
        if ((methods = c.getMethods()) != null) {
            for (JMethod m : methods) {
                this.gatherTypes(m.getReturnType().getErasedType(), types);
                if (m.getParameterTypes() == null) continue;
                for (JType p : m.getParameterTypes()) {
                    this.gatherTypes(p.getErasedType(), types);
                }
            }
        }
        if ((inner = c.getNestedTypes()) != null) {
            for (JClassType i : inner) {
                this.gatherTypes((JType)i.getErasedType(), types);
            }
        }
        --this.nesting;
    }
}

