/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

public class BufferedWriter
extends Writer {
    private final Writer out;
    private final char[] buffer;
    private int position;

    public BufferedWriter(Writer out, int size) {
        this.out = out;
        this.buffer = new char[size];
    }

    public BufferedWriter(Writer out) {
        this(out, 4096);
    }

    private void drain() throws IOException {
        if (this.position > 0) {
            this.out.write(this.buffer, 0, this.position);
            this.position = 0;
        }
    }

    @Override
    public void write(char[] b, int offset, int length) throws IOException {
        if (length > this.buffer.length - this.position) {
            this.drain();
            this.out.write(b, offset, length);
        } else {
            System.arraycopy(b, offset, this.buffer, this.position, length);
            this.position += length;
        }
    }

    @Override
    public void flush() throws IOException {
        this.drain();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

