/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.google.gwt.corp.compatibility.Numbers;
import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class DataInputStream
extends FilterInputStream
implements DataInput {
    private final InputStream is;

    public DataInputStream(InputStream is) {
        super(is);
        this.is = is;
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        int i = this.read();
        if (i == -1) {
            throw new EOFException();
        }
        return (byte)i;
    }

    @Override
    public char readChar() throws IOException {
        int a = this.is.read();
        int b = this.readUnsignedByte();
        return (char)(a << 8 | b);
    }

    @Override
    public double readDouble() throws IOException {
        return Numbers.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Numbers.intBitsToFloat(this.readInt());
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int count = this.is.read(b, off, len);
            if (count <= 0) {
                throw new EOFException();
            }
            off += count;
            len -= count;
        }
    }

    @Override
    public int readInt() throws IOException {
        int a = this.is.read();
        int b = this.is.read();
        int c = this.is.read();
        int d = this.readUnsignedByte();
        return a << 24 | b << 16 | c << 8 | d;
    }

    @Override
    public String readLine() throws IOException {
        throw new RuntimeException("readline NYI");
    }

    @Override
    public long readLong() throws IOException {
        long a = this.readInt();
        long b = this.readInt();
        return a << 32 | b & 0xFFFFFFFFL;
    }

    @Override
    public short readShort() throws IOException {
        int a = this.is.read();
        int b = this.readUnsignedByte();
        return (short)(a << 8 | b);
    }

    @Override
    public String readUTF() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int bytes = this.readUnsignedShort(); bytes > 0; bytes -= this.readUtfChar(sb)) {
        }
        return sb.toString();
    }

    private int readUtfChar(StringBuilder sb) throws IOException {
        int a = this.readUnsignedByte();
        if ((a & 0x80) == 0) {
            sb.append((char)a);
            return 1;
        }
        if ((a & 0xE0) == 192) {
            int b = this.readUnsignedByte();
            sb.append((char)((a & 0x1F) << 6 | b & 0x3F));
            return 2;
        }
        if ((a & 0xF0) == 224) {
            int b = this.readUnsignedByte();
            int c = this.readUnsignedByte();
            sb.append((char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F));
            return 3;
        }
        throw new UTFDataFormatException();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int i = this.read();
        if (i == -1) {
            throw new EOFException();
        }
        return i;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int a = this.is.read();
        int b = this.readUnsignedByte();
        return a << 8 | b;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }
}

