/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferFactory;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;

public abstract class FloatBuffer
extends Buffer
implements Comparable<FloatBuffer> {
    public static FloatBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return BufferFactory.newFloatBuffer(capacity);
    }

    public static FloatBuffer wrap(float[] array) {
        return FloatBuffer.wrap(array, 0, array.length);
    }

    public static FloatBuffer wrap(float[] array, int start, int len) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (start < 0 || len < 0 || (long)start + (long)len > (long)array.length) {
            throw new IndexOutOfBoundsException();
        }
        FloatBuffer buf = BufferFactory.newFloatBuffer(array);
        buf.position = start;
        buf.limit = start + len;
        return buf;
    }

    FloatBuffer(int capacity) {
        super(capacity);
    }

    public final float[] array() {
        return this.protectedArray();
    }

    public final int arrayOffset() {
        return this.protectedArrayOffset();
    }

    public abstract FloatBuffer asReadOnlyBuffer();

    public abstract FloatBuffer compact();

    @Override
    public int compareTo(FloatBuffer otherBuffer) {
        int thisPos = this.position;
        int otherPos = otherBuffer.position;
        for (int compareRemaining = this.remaining() < otherBuffer.remaining() ? this.remaining() : otherBuffer.remaining(); compareRemaining > 0; --compareRemaining) {
            float otherFloat;
            float thisFloat = this.get(thisPos);
            if (thisFloat != (otherFloat = otherBuffer.get(otherPos)) && (thisFloat == thisFloat || otherFloat == otherFloat)) {
                return thisFloat < otherFloat ? -1 : 1;
            }
            ++thisPos;
            ++otherPos;
        }
        return this.remaining() - otherBuffer.remaining();
    }

    public abstract FloatBuffer duplicate();

    public boolean equals(Object other) {
        if (!(other instanceof FloatBuffer)) {
            return false;
        }
        FloatBuffer otherBuffer = (FloatBuffer)other;
        if (this.remaining() != otherBuffer.remaining()) {
            return false;
        }
        int myPosition = this.position;
        int otherPosition = otherBuffer.position;
        boolean equalSoFar = true;
        while (equalSoFar && myPosition < this.limit) {
            equalSoFar = this.get(myPosition++) == otherBuffer.get(otherPosition++);
        }
        return equalSoFar;
    }

    public abstract float get();

    public FloatBuffer get(float[] dest) {
        return this.get(dest, 0, dest.length);
    }

    public FloatBuffer get(float[] dest, int off, int len) {
        int length = dest.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferUnderflowException();
        }
        for (int i = off; i < off + len; ++i) {
            dest[i] = this.get();
        }
        return this;
    }

    public abstract float get(int var1);

    public final boolean hasArray() {
        return this.protectedHasArray();
    }

    public abstract boolean isDirect();

    public abstract ByteOrder order();

    abstract float[] protectedArray();

    abstract int protectedArrayOffset();

    abstract boolean protectedHasArray();

    public abstract FloatBuffer put(float var1);

    public final FloatBuffer put(float[] src) {
        return this.put(src, 0, src.length);
    }

    public FloatBuffer put(float[] src, int off, int len) {
        int length = src.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = off; i < off + len; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public FloatBuffer put(FloatBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        float[] contents = new float[src.remaining()];
        src.get(contents);
        this.put(contents);
        return this;
    }

    public abstract FloatBuffer put(int var1, float var2);

    public abstract FloatBuffer slice();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(", status: capacity=");
        sb.append(this.capacity());
        sb.append(" position=");
        sb.append(this.position());
        sb.append(" limit=");
        sb.append(this.limit());
        return sb.toString();
    }
}

