/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;

final class LongToByteBufferAdapter
extends LongBuffer {
    private final ByteBuffer byteBuffer;

    static LongBuffer wrap(ByteBuffer byteBuffer) {
        return new LongToByteBufferAdapter(byteBuffer.slice());
    }

    LongToByteBufferAdapter(ByteBuffer byteBuffer) {
        super(byteBuffer.capacity() >> 3);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        LongToByteBufferAdapter buf = new LongToByteBufferAdapter(this.byteBuffer.asReadOnlyBuffer());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public LongBuffer compact() {
        if (this.byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.byteBuffer.limit(this.limit << 3);
        this.byteBuffer.position(this.position << 3);
        this.byteBuffer.compact();
        this.byteBuffer.clear();
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public LongBuffer duplicate() {
        LongToByteBufferAdapter buf = new LongToByteBufferAdapter(this.byteBuffer.duplicate());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public long get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.byteBuffer.getLong(this.position++ << 3);
    }

    @Override
    public long get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.byteBuffer.getLong(index << 3);
    }

    @Override
    public boolean isDirect() {
        return this.byteBuffer.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.byteBuffer.isReadOnly();
    }

    @Override
    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    @Override
    protected long[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean protectedHasArray() {
        return false;
    }

    @Override
    public LongBuffer put(long c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.byteBuffer.putLong(this.position++ << 3, c);
        return this;
    }

    @Override
    public LongBuffer put(int index, long c) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.byteBuffer.putLong(index << 3, c);
        return this;
    }

    @Override
    public LongBuffer slice() {
        this.byteBuffer.limit(this.limit << 3);
        this.byteBuffer.position(this.position << 3);
        LongToByteBufferAdapter result = new LongToByteBufferAdapter(this.byteBuffer.slice());
        this.byteBuffer.clear();
        return result;
    }
}

