/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferFactory;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;

public abstract class ShortBuffer
extends Buffer
implements Comparable<ShortBuffer> {
    public static ShortBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return BufferFactory.newShortBuffer(capacity);
    }

    public static ShortBuffer wrap(short[] array) {
        return ShortBuffer.wrap(array, 0, array.length);
    }

    public static ShortBuffer wrap(short[] array, int start, int len) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (start < 0 || len < 0 || (long)start + (long)len > (long)array.length) {
            throw new IndexOutOfBoundsException();
        }
        ShortBuffer buf = BufferFactory.newShortBuffer(array);
        buf.position = start;
        buf.limit = start + len;
        return buf;
    }

    ShortBuffer(int capacity) {
        super(capacity);
    }

    public final short[] array() {
        return this.protectedArray();
    }

    public final int arrayOffset() {
        return this.protectedArrayOffset();
    }

    public abstract ShortBuffer asReadOnlyBuffer();

    public abstract ShortBuffer compact();

    @Override
    public int compareTo(ShortBuffer otherBuffer) {
        int thisPos = this.position;
        int otherPos = otherBuffer.position;
        for (int compareRemaining = this.remaining() < otherBuffer.remaining() ? this.remaining() : otherBuffer.remaining(); compareRemaining > 0; --compareRemaining) {
            short otherByte;
            short thisByte = this.get(thisPos);
            if (thisByte != (otherByte = otherBuffer.get(otherPos))) {
                return thisByte < otherByte ? -1 : 1;
            }
            ++thisPos;
            ++otherPos;
        }
        return this.remaining() - otherBuffer.remaining();
    }

    public abstract ShortBuffer duplicate();

    public boolean equals(Object other) {
        if (!(other instanceof ShortBuffer)) {
            return false;
        }
        ShortBuffer otherBuffer = (ShortBuffer)other;
        if (this.remaining() != otherBuffer.remaining()) {
            return false;
        }
        int myPosition = this.position;
        int otherPosition = otherBuffer.position;
        boolean equalSoFar = true;
        while (equalSoFar && myPosition < this.limit) {
            equalSoFar = this.get(myPosition++) == otherBuffer.get(otherPosition++);
        }
        return equalSoFar;
    }

    public abstract short get();

    public ShortBuffer get(short[] dest) {
        return this.get(dest, 0, dest.length);
    }

    public ShortBuffer get(short[] dest, int off, int len) {
        int length = dest.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferUnderflowException();
        }
        for (int i = off; i < off + len; ++i) {
            dest[i] = this.get();
        }
        return this;
    }

    public abstract short get(int var1);

    public final boolean hasArray() {
        return this.protectedHasArray();
    }

    public int hashCode() {
        int myPosition = this.position;
        int hash = 0;
        while (myPosition < this.limit) {
            hash += this.get(myPosition++);
        }
        return hash;
    }

    public abstract boolean isDirect();

    public abstract ByteOrder order();

    abstract short[] protectedArray();

    abstract int protectedArrayOffset();

    abstract boolean protectedHasArray();

    public abstract ShortBuffer put(short var1);

    public final ShortBuffer put(short[] src) {
        return this.put(src, 0, src.length);
    }

    public ShortBuffer put(short[] src, int off, int len) {
        int length = src.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = off; i < off + len; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public ShortBuffer put(ShortBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        short[] contents = new short[src.remaining()];
        src.get(contents);
        this.put(contents);
        return this;
    }

    public abstract ShortBuffer put(int var1, short var2);

    public abstract ShortBuffer slice();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(", status: capacity=");
        sb.append(this.capacity());
        sb.append(" position=");
        sb.append(this.position());
        sb.append(" limit=");
        sb.append(this.limit());
        return sb.toString();
    }
}

