/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.assets.loaders.resolvers;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.backends.gwt.GwtFileHandle;
import com.badlogic.gdx.files.FileHandle;

public class ResolutionFileResolver
implements FileHandleResolver {
    protected final FileHandleResolver baseResolver;
    protected final Resolution[] descriptors;

    public ResolutionFileResolver(FileHandleResolver baseResolver, Resolution ... descriptors) {
        this.baseResolver = baseResolver;
        this.descriptors = descriptors;
    }

    public FileHandle resolve(String fileName) {
        Resolution bestDesc = ResolutionFileResolver.choose(this.descriptors);
        GwtFileHandle originalHandle = new GwtFileHandle(fileName);
        FileHandle handle = this.baseResolver.resolve(this.resolve(originalHandle, bestDesc.folder));
        if (!handle.exists()) {
            handle = this.baseResolver.resolve(fileName);
        }
        return handle;
    }

    protected String resolve(FileHandle originalHandle, String suffix) {
        return originalHandle.parent() + "/" + suffix + "/" + originalHandle.name();
    }

    public static Resolution choose(Resolution ... descriptors) {
        int i;
        int width = 0;
        width = Gdx.graphics.getWidth() > Gdx.graphics.getHeight() ? Gdx.graphics.getHeight() : Gdx.graphics.getWidth();
        Resolution bestDesc = null;
        int best = Integer.MAX_VALUE;
        int n = descriptors.length;
        for (i = 0; i < n; ++i) {
            if (descriptors[i].portraitWidth >= best) continue;
            best = descriptors[i].portraitWidth;
            bestDesc = descriptors[i];
        }
        best = Integer.MAX_VALUE;
        n = descriptors.length;
        for (i = 0; i < n; ++i) {
            if (descriptors[i].portraitWidth > width) continue;
            best = descriptors[i].portraitWidth;
            bestDesc = descriptors[i];
        }
        return bestDesc;
    }

    public static class Resolution {
        public final int portraitWidth;
        public final int portraitHeight;
        public final String folder;

        public Resolution(int portraitWidth, int portraitHeight, String folder) {
            this.portraitWidth = portraitWidth;
            this.portraitHeight = portraitHeight;
            this.folder = folder;
        }
    }
}

