/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.ApplicationLogger;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.gwt.GwtApplicationConfiguration;
import com.badlogic.gdx.backends.gwt.GwtApplicationLogger;
import com.badlogic.gdx.backends.gwt.GwtAudio;
import com.badlogic.gdx.backends.gwt.GwtClipboard;
import com.badlogic.gdx.backends.gwt.GwtFiles;
import com.badlogic.gdx.backends.gwt.GwtGraphics;
import com.badlogic.gdx.backends.gwt.GwtInput;
import com.badlogic.gdx.backends.gwt.GwtNet;
import com.badlogic.gdx.backends.gwt.GwtPreferences;
import com.badlogic.gdx.backends.gwt.preloader.Preloader;
import com.badlogic.gdx.backends.gwt.soundmanager2.SoundManager;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.TimeUtils;
import com.google.gwt.animation.client.AnimationScheduler;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class GwtApplication
implements EntryPoint,
Application {
    private ApplicationListener listener;
    GwtApplicationConfiguration config;
    GwtGraphics graphics;
    private GwtInput input;
    private GwtNet net;
    private Panel root = null;
    protected TextArea log = null;
    private int logLevel = 1;
    private ApplicationLogger applicationLogger;
    private Array<Runnable> runnables = new Array();
    private Array<Runnable> runnablesHelper = new Array();
    private Array<LifecycleListener> lifecycleListeners = new Array();
    private int lastWidth;
    private int lastHeight;
    Preloader preloader;
    private static AgentInfo agentInfo;
    private ObjectMap<String, Preferences> prefs = new ObjectMap();
    private Clipboard clipboard;
    LoadingListener loadingListener;
    long loadStart = TimeUtils.nanoTime();

    public abstract GwtApplicationConfiguration getConfig();

    public String getPreloaderBaseURL() {
        return GWT.getHostPageBaseURL() + "assets/";
    }

    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    public abstract ApplicationListener createApplicationListener();

    public void onModuleLoad() {
        agentInfo = GwtApplication.computeAgentInfo();
        this.listener = this.createApplicationListener();
        this.config = this.getConfig();
        this.setApplicationLogger(new GwtApplicationLogger(this.config.log));
        if (this.config.rootPanel != null) {
            this.root = this.config.rootPanel;
        } else {
            Element element = Document.get().getElementById("embed-" + GWT.getModuleName());
            if (element == null) {
                VerticalPanel panel = new VerticalPanel();
                panel.setWidth("" + this.config.width + "px");
                panel.setHeight("" + this.config.height + "px");
                panel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
                panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
                RootPanel.get().add((Widget)panel);
                RootPanel.get().setWidth("" + this.config.width + "px");
                RootPanel.get().setHeight("" + this.config.height + "px");
                this.root = panel;
            } else {
                VerticalPanel panel = new VerticalPanel();
                panel.setWidth("" + this.config.width + "px");
                panel.setHeight("" + this.config.height + "px");
                panel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
                panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
                element.appendChild((Node)panel.getElement());
                this.root = panel;
            }
        }
        if (this.config.disableAudio) {
            this.preloadAssets();
        } else {
            SoundManager.init(GWT.getModuleBaseURL(), 9, this.config.preferFlash, new SoundManager.SoundManagerCallback(){

                @Override
                public void onready() {
                    GwtApplication.this.preloadAssets();
                }

                @Override
                public void ontimeout(String status, String errorType) {
                    GwtApplication.this.error("SoundManager", status + " " + errorType);
                }
            });
        }
    }

    void preloadAssets() {
        final Preloader.PreloaderCallback callback = this.getPreloaderCallback();
        this.preloader = this.createPreloader();
        this.preloader.preload("assets.txt", new Preloader.PreloaderCallback(){

            @Override
            public void error(String file) {
                callback.error(file);
            }

            @Override
            public void update(Preloader.PreloaderState state) {
                callback.update(state);
                if (state.hasEnded()) {
                    GwtApplication.this.getRootPanel().clear();
                    if (GwtApplication.this.loadingListener != null) {
                        GwtApplication.this.loadingListener.beforeSetup();
                    }
                    GwtApplication.this.setupLoop();
                    GwtApplication.this.addEventListeners();
                    if (GwtApplication.this.loadingListener != null) {
                        GwtApplication.this.loadingListener.afterSetup();
                    }
                }
            }
        });
    }

    public Widget getNoWebGLSupportWidget() {
        return new Label("Sorry, your browser doesn't seem to support WebGL");
    }

    void setupLoop() {
        try {
            this.graphics = new GwtGraphics(this.root, this.config);
        }
        catch (Throwable e) {
            this.root.clear();
            this.root.add(this.getNoWebGLSupportWidget());
            return;
        }
        this.lastWidth = this.graphics.getWidth();
        this.lastHeight = this.graphics.getHeight();
        Gdx.app = this;
        Gdx.audio = this.config.disableAudio ? null : new GwtAudio();
        Gdx.graphics = this.graphics;
        Gdx.gl = Gdx.gl20 = this.graphics.getGL20();
        Gdx.files = new GwtFiles(this.preloader);
        this.input = new GwtInput(this.graphics.canvas, this.config);
        Gdx.input = this.input;
        this.net = new GwtNet(this.config);
        Gdx.net = this.net;
        this.clipboard = new GwtClipboard();
        this.updateLogLabelSize();
        try {
            this.listener.create();
            this.listener.resize(this.graphics.getWidth(), this.graphics.getHeight());
        }
        catch (Throwable t) {
            this.error("GwtApplication", "exception: " + t.getMessage(), t);
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        AnimationScheduler.get().requestAnimationFrame(new AnimationScheduler.AnimationCallback(){

            public void execute(double timestamp) {
                try {
                    GwtApplication.this.mainLoop();
                }
                catch (Throwable t) {
                    GwtApplication.this.error("GwtApplication", "exception: " + t.getMessage(), t);
                    throw new RuntimeException(t);
                }
                AnimationScheduler.get().requestAnimationFrame((AnimationScheduler.AnimationCallback)this, (Element)GwtApplication.this.graphics.canvas);
            }
        }, (Element)this.graphics.canvas);
    }

    void mainLoop() {
        this.graphics.update();
        if (Gdx.graphics.getWidth() != this.lastWidth || Gdx.graphics.getHeight() != this.lastHeight) {
            this.lastWidth = this.graphics.getWidth();
            this.lastHeight = this.graphics.getHeight();
            Gdx.gl.glViewport(0, 0, this.lastWidth, this.lastHeight);
            this.listener.resize(this.lastWidth, this.lastHeight);
        }
        this.runnablesHelper.addAll(this.runnables);
        this.runnables.clear();
        for (int i = 0; i < this.runnablesHelper.size; ++i) {
            ((Runnable)this.runnablesHelper.get(i)).run();
        }
        this.runnablesHelper.clear();
        ++this.graphics.frameId;
        this.listener.render();
        this.input.reset();
    }

    public Panel getRootPanel() {
        return this.root;
    }

    public Preloader createPreloader() {
        return new Preloader(this.getPreloaderBaseURL());
    }

    public Preloader.PreloaderCallback getPreloaderCallback() {
        return this.createPreloaderPanel(GWT.getModuleBaseURL() + "logo.png");
    }

    protected Preloader.PreloaderCallback createPreloaderPanel(String logoUrl) {
        VerticalPanel preloaderPanel = new VerticalPanel();
        preloaderPanel.setStyleName("gdx-preloader");
        Image logo = new Image(logoUrl);
        logo.setStyleName("logo");
        preloaderPanel.add((Widget)logo);
        SimplePanel meterPanel = new SimplePanel();
        InlineHTML meter = new InlineHTML();
        final Style meterStyle = meter.getElement().getStyle();
        meterStyle.setWidth(0.0, Style.Unit.PCT);
        this.adjustMeterPanel((Panel)meterPanel, meterStyle);
        meterPanel.add((Widget)meter);
        preloaderPanel.add((Widget)meterPanel);
        this.getRootPanel().add((Widget)preloaderPanel);
        return new Preloader.PreloaderCallback(){

            @Override
            public void error(String file) {
                System.out.println("error: " + file);
            }

            @Override
            public void update(Preloader.PreloaderState state) {
                meterStyle.setWidth((double)(100.0f * state.getProgress()), Style.Unit.PCT);
            }
        };
    }

    protected void adjustMeterPanel(Panel meterPanel, Style meterStyle) {
        meterPanel.setStyleName("gdx-meter");
        meterPanel.addStyleName("red");
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public Audio getAudio() {
        return Gdx.audio;
    }

    public Input getInput() {
        return Gdx.input;
    }

    public Files getFiles() {
        return Gdx.files;
    }

    public Net getNet() {
        return Gdx.net;
    }

    private void updateLogLabelSize() {
        if (this.log != null) {
            if (this.graphics != null) {
                this.log.setSize(this.graphics.getWidth() + "px", "200px");
            } else {
                this.log.setSize("400px", "200px");
            }
        }
    }

    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(tag, message);
        }
    }

    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(tag, message, exception);
        }
    }

    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(tag, message);
        }
    }

    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(tag, message, exception);
        }
    }

    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(tag, message);
        }
    }

    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(tag, message, exception);
        }
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setApplicationLogger(ApplicationLogger applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    public ApplicationLogger getApplicationLogger() {
        return this.applicationLogger;
    }

    public Application.ApplicationType getType() {
        return Application.ApplicationType.WebGL;
    }

    public int getVersion() {
        return 0;
    }

    public long getJavaHeap() {
        return 0L;
    }

    public long getNativeHeap() {
        return 0L;
    }

    public Preferences getPreferences(String name) {
        Preferences pref = (Preferences)this.prefs.get((Object)name);
        if (pref == null) {
            pref = new GwtPreferences(name);
            this.prefs.put((Object)name, (Object)pref);
        }
        return pref;
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public void postRunnable(Runnable runnable) {
        this.runnables.add((Object)runnable);
    }

    public void exit() {
    }

    public static boolean isMobileDevice() {
        String pattern = "(android|bb\\d+|meego).+mobile|avantgo|bada\\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\\.(browser|link)|vodafone|wap|windows ce|xda|xiino|android|ipad|playbook|silk";
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(Window.Navigator.getUserAgent().toLowerCase());
        return m.matches();
    }

    public static AgentInfo agentInfo() {
        return agentInfo;
    }

    private static native AgentInfo computeAgentInfo();

    public String getBaseUrl() {
        return this.preloader.baseUrl;
    }

    public Preloader getPreloader() {
        return this.preloader;
    }

    public CanvasElement getCanvasElement() {
        return this.graphics.canvas;
    }

    public LoadingListener getLoadingListener() {
        return this.loadingListener;
    }

    public void setLoadingListener(LoadingListener loadingListener) {
        this.loadingListener = loadingListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue((Object)listener, true);
        }
    }

    public static native void consoleLog(String var0);

    private native void addEventListeners();

    private void onVisibilityChange(boolean visible) {
        if (visible) {
            for (LifecycleListener listener : this.lifecycleListeners) {
                listener.resume();
            }
            this.listener.resume();
        } else {
            for (LifecycleListener listener : this.lifecycleListeners) {
                listener.pause();
            }
            this.listener.pause();
        }
    }

    public static interface LoadingListener {
        public void beforeSetup();

        public void afterSetup();
    }

    public static class AgentInfo
    extends JavaScriptObject {
        public final native boolean isFirefox();

        public final native boolean isChrome();

        public final native boolean isSafari();

        public final native boolean isOpera();

        public final native boolean isIE();

        public final native boolean isMacOS();

        public final native boolean isLinux();

        public final native boolean isWindows();

        protected AgentInfo() {
        }
    }
}

