/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.ApplicationLogger;
import com.google.gwt.user.client.ui.TextArea;

public class GwtApplicationLogger
implements ApplicationLogger {
    private TextArea log;

    public GwtApplicationLogger(TextArea log) {
        this.log = log;
    }

    public void log(String tag, String message) {
        this.logText(tag + ": " + message, false);
    }

    private void logText(String message, boolean error) {
        if (this.log != null) {
            this.log.setText(this.log.getText() + "\n" + message + "\n");
            this.log.setCursorPos(this.log.getText().length() - 1);
        } else if (error) {
            GwtApplicationLogger.consoleError(message);
        } else {
            GwtApplicationLogger.consoleLog(message);
        }
    }

    public static native void consoleLog(String var0);

    public static native void consoleError(String var0);

    public void log(String tag, String message, Throwable exception) {
        this.logText(tag + ": " + message + "\n" + this.getMessages(exception), false);
        this.logText(this.getStackTrace(exception), false);
    }

    public void error(String tag, String message) {
        this.logText(tag + ": " + message, true);
    }

    public void error(String tag, String message, Throwable exception) {
        this.logText(tag + ": " + message + "\n" + this.getMessages(exception), true);
        this.logText(this.getStackTrace(exception), false);
    }

    public void debug(String tag, String message) {
        this.logText(tag + ": " + message, false);
    }

    public void debug(String tag, String message, Throwable exception) {
        this.logText(tag + ": " + message + "\n" + this.getMessages(exception), false);
        this.logText(this.getStackTrace(exception), false);
    }

    private String getMessages(Throwable e) {
        StringBuilder sb = new StringBuilder();
        while (e != null) {
            sb.append(e.getMessage() + "\n");
            e = e.getCause();
        }
        return sb.toString();
    }

    private String getStackTrace(Throwable e) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement trace : e.getStackTrace()) {
            sb.append(trace.toString() + "\n");
        }
        return sb.toString();
    }
}

