/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.backends.gwt.GwtApplication;
import com.badlogic.gdx.backends.gwt.GwtPermissions;
import com.badlogic.gdx.utils.Clipboard;

public class GwtClipboard
implements Clipboard {
    private boolean requestedWritePermissions = false;
    private boolean hasWritePermissions = true;
    private ClipboardWriteHandler writeHandler = new ClipboardWriteHandler();
    private String content = "";

    public String getContents() {
        return this.content;
    }

    public void setContents(String content) {
        this.content = content;
        if (this.requestedWritePermissions || GwtApplication.agentInfo().isFirefox()) {
            if (this.hasWritePermissions) {
                this.setContentJSNI(content);
            }
        } else {
            GwtPermissions.queryPermission("clipboard-write", this.writeHandler);
            this.requestedWritePermissions = true;
        }
    }

    private native void setContentJSNI(String var1);

    private class ClipboardWriteHandler
    implements GwtPermissions.GwtPermissionResult {
        private ClipboardWriteHandler() {
        }

        @Override
        public void granted() {
            GwtClipboard.this.hasWritePermissions = true;
            GwtClipboard.this.setContentJSNI(GwtClipboard.this.content);
        }

        @Override
        public void denied() {
            GwtClipboard.this.hasWritePermissions = false;
        }

        @Override
        public void prompt() {
            GwtClipboard.this.hasWritePermissions = true;
            GwtClipboard.this.setContentJSNI(GwtClipboard.this.content);
        }
    }
}

