/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.gwt.GwtApplication;
import com.badlogic.gdx.backends.gwt.soundmanager2.SMSound;
import com.badlogic.gdx.backends.gwt.soundmanager2.SMSoundOptions;
import com.badlogic.gdx.backends.gwt.soundmanager2.SoundManager;
import com.badlogic.gdx.files.FileHandle;

public class GwtMusic
implements Music,
SMSound.SMSoundCallback {
    private boolean isPlaying = false;
    private boolean isLooping = false;
    private SMSound sound;
    private float volume = 1.0f;
    private float pan = 0.0f;
    private SMSoundOptions soundOptions;
    private Music.OnCompletionListener onCompletionListener;

    public GwtMusic(FileHandle file) {
        String url = ((GwtApplication)Gdx.app).getBaseUrl() + file.path();
        this.sound = SoundManager.createSound(url);
        this.soundOptions = new SMSoundOptions();
        this.soundOptions.callback = this;
    }

    public void play() {
        if (this.isPlaying()) {
            return;
        }
        if (this.sound.getPaused()) {
            this.resume();
            return;
        }
        this.soundOptions.volume = (int)(this.volume * 100.0f);
        this.soundOptions.pan = (int)(this.pan * 100.0f);
        this.soundOptions.loops = 1;
        this.soundOptions.from = 0;
        this.sound.play(this.soundOptions);
        this.isPlaying = true;
    }

    public void resume() {
        this.sound.resume();
    }

    public void pause() {
        this.sound.pause();
        this.isPlaying = false;
    }

    public void stop() {
        this.sound.stop();
        this.isPlaying = false;
    }

    public boolean isPlaying() {
        this.isPlaying = !this.sound.getPaused() && this.sound.getPlayState() == 1;
        return this.isPlaying;
    }

    public void setLooping(boolean isLooping) {
        this.isLooping = isLooping;
    }

    public boolean isLooping() {
        return this.isLooping;
    }

    public void setVolume(float volume) {
        this.sound.setVolume((int)(volume * 100.0f));
        this.volume = volume;
    }

    public float getVolume() {
        return this.volume;
    }

    public void setPan(float pan, float volume) {
        this.sound.setPan((int)(pan * 100.0f));
        this.sound.setVolume((int)(volume * 100.0f));
        this.pan = pan;
        this.volume = volume;
    }

    public void setPosition(float position) {
        this.sound.setPosition((int)(position * 1000.0f));
    }

    public float getPosition() {
        return (float)this.sound.getPosition() / 1000.0f;
    }

    public void dispose() {
        this.sound.destruct();
    }

    public void setOnCompletionListener(Music.OnCompletionListener listener) {
        this.onCompletionListener = listener;
    }

    @Override
    public void onfinish() {
        if (this.isLooping) {
            this.play();
        } else if (this.onCompletionListener != null) {
            this.onCompletionListener.onCompletion((Music)this);
        }
    }
}

