/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.gwt.GwtMusic;
import com.badlogic.gdx.files.FileHandle;

public class GwtSound
implements Sound {
    private static final int MAX_SOUNDS = 8;
    private GwtMusic[] sounds;
    private int soundIndex;
    private FileHandle soundFile;

    public GwtSound(FileHandle file) {
        this.soundFile = file;
        this.sounds = new GwtMusic[8];
        this.sounds[0] = new GwtMusic(file);
        this.soundIndex = 0;
    }

    private int findAvailableSound() {
        for (int i = 0; i < this.sounds.length; ++i) {
            int index = (this.soundIndex + i) % this.sounds.length;
            if (this.sounds[index] != null && this.sounds[index].isPlaying()) continue;
            this.soundIndex = (index + 1) % this.sounds.length;
            return index;
        }
        int index = this.soundIndex % this.sounds.length;
        this.soundIndex = (index + 1) % this.sounds.length;
        return index;
    }

    public long play() {
        return this.play(1.0f, 1.0f, 0.0f, false);
    }

    public long play(float volume) {
        return this.play(volume, 1.0f, 0.0f, false);
    }

    public long play(float volume, float pitch, float pan) {
        return this.play(volume, pitch, pan, false);
    }

    private long play(float volume, float pitch, float pan, boolean loop) {
        int soundId = this.findAvailableSound();
        if (soundId >= 0) {
            if (this.sounds[soundId] == null) {
                this.sounds[soundId] = new GwtMusic(this.soundFile);
            }
            GwtMusic sound = this.sounds[soundId];
            sound.stop();
            sound.setPan(pan, volume);
            sound.setLooping(loop);
            sound.play();
        }
        return soundId;
    }

    public long loop() {
        return this.play(1.0f, 1.0f, 0.0f, true);
    }

    public long loop(float volume) {
        return this.play(volume, 1.0f, 0.0f, true);
    }

    public long loop(float volume, float pitch, float pan) {
        return this.play(volume, pitch, pan, true);
    }

    public void stop() {
        for (int i = 0; i < this.sounds.length; ++i) {
            if (this.sounds[i] == null) continue;
            this.sounds[i].stop();
        }
    }

    public void dispose() {
        this.stop();
        for (int i = 0; i < this.sounds.length; ++i) {
            if (this.sounds[i] == null) continue;
            this.sounds[i].dispose();
        }
        this.sounds = null;
    }

    public void stop(long soundId) {
        if (soundId >= 0L && this.sounds[(int)soundId] != null) {
            this.sounds[(int)soundId].stop();
        }
    }

    public void pause() {
        for (int i = 0; i < this.sounds.length; ++i) {
            if (this.sounds[i] == null) continue;
            this.sounds[i].pause();
        }
    }

    public void pause(long soundId) {
        if (soundId >= 0L && this.sounds[(int)soundId] != null) {
            this.sounds[(int)soundId].pause();
        }
    }

    public void resume() {
        for (int i = 0; i < this.sounds.length; ++i) {
            if (this.sounds[i] == null) continue;
            this.sounds[i].resume();
        }
    }

    public void resume(long soundId) {
        if (soundId >= 0L && this.sounds[(int)soundId] != null) {
            this.sounds[(int)soundId].resume();
        }
    }

    public void setLooping(long soundId, boolean looping) {
        if (soundId >= 0L && this.sounds[(int)soundId] != null) {
            this.sounds[(int)soundId].setLooping(looping);
        }
    }

    public void setPitch(long soundId, float pitch) {
    }

    public void setVolume(long soundId, float volume) {
        if (soundId >= 0L && this.sounds[(int)soundId] != null) {
            this.sounds[(int)soundId].setVolume(volume);
        }
    }

    public void setPan(long soundId, float pan, float volume) {
        if (soundId >= 0L && this.sounds[(int)soundId] != null) {
            this.sounds[(int)soundId].setPan(pan, volume);
        }
    }
}

