/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.preloader;

import com.google.gwt.typedarrays.shared.Int8Array;
import java.io.IOException;
import java.io.InputStream;

public final class Blob {
    protected final Int8Array data;

    public Blob(Int8Array data) {
        this.data = data;
    }

    public int length() {
        return this.data.length();
    }

    public byte get(int i) {
        return this.data.get(i);
    }

    public InputStream read() {
        return new InputStream(){
            int pos;

            @Override
            public int read() throws IOException {
                if (this.pos == Blob.this.length()) {
                    return -1;
                }
                return Blob.this.get(this.pos++) & 0xFF;
            }

            @Override
            public int available() {
                return Blob.this.length() - this.pos;
            }
        };
    }

    public String toBase64() {
        int length = this.data.length();
        String base64code = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        StringBuilder encoded = new StringBuilder(length * 4 / 3 + 2);
        for (int i = 0; i < length; i += 3) {
            int j;
            if (length - i >= 3) {
                j = ((this.data.get(i) & 0xFF) << 16) + ((this.data.get(i + 1) & 0xFF) << 8) + (this.data.get(i + 2) & 0xFF);
                encoded.append(base64code.charAt(j >> 18 & 0x3F));
                encoded.append(base64code.charAt(j >> 12 & 0x3F));
                encoded.append(base64code.charAt(j >> 6 & 0x3F));
                encoded.append(base64code.charAt(j & 0x3F));
                continue;
            }
            if (length - i >= 2) {
                j = ((this.data.get(i) & 0xFF) << 16) + ((this.data.get(i + 1) & 0xFF) << 8);
                encoded.append(base64code.charAt(j >> 18 & 0x3F));
                encoded.append(base64code.charAt(j >> 12 & 0x3F));
                encoded.append(base64code.charAt(j >> 6 & 0x3F));
                encoded.append("=");
                continue;
            }
            j = (this.data.get(i) & 0xFF) << 16;
            encoded.append(base64code.charAt(j >> 18 & 0x3F));
            encoded.append(base64code.charAt(j >> 12 & 0x3F));
            encoded.append("==");
        }
        return encoded.toString();
    }
}

