/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.preloader;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.backends.gwt.GwtFileHandle;
import com.badlogic.gdx.backends.gwt.preloader.AssetDownloader;
import com.badlogic.gdx.backends.gwt.preloader.AssetFilter;
import com.badlogic.gdx.backends.gwt.preloader.Blob;
import com.badlogic.gdx.backends.gwt.preloader.PreloaderBundle;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.ImageElement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class Preloader {
    public ObjectMap<String, Void> directories = new ObjectMap();
    public ObjectMap<String, ImageElement> images = new ObjectMap();
    public ObjectMap<String, Blob> audio = new ObjectMap();
    public ObjectMap<String, String> texts = new ObjectMap();
    public ObjectMap<String, Blob> binaries = new ObjectMap();
    public final String baseUrl;

    public Preloader(String newBaseURL) {
        this.baseUrl = newBaseURL;
        GWT.create(PreloaderBundle.class);
    }

    public void preload(final String assetFileUrl, final PreloaderCallback callback) {
        final AssetDownloader loader = new AssetDownloader();
        loader.loadText(this.baseUrl + assetFileUrl, new AssetDownloader.AssetLoaderListener<String>(){

            @Override
            public void onProgress(double amount) {
            }

            @Override
            public void onFailure() {
                callback.error(assetFileUrl);
            }

            @Override
            public void onSuccess(String result) {
                String[] lines = result.split("\n");
                Array assets = new Array(lines.length);
                for (String line : lines) {
                    String[] tokens = line.split(":");
                    if (tokens.length != 4) {
                        throw new GdxRuntimeException("Invalid assets description file.");
                    }
                    AssetFilter.AssetType type = AssetFilter.AssetType.Text;
                    if (tokens[0].equals("i")) {
                        type = AssetFilter.AssetType.Image;
                    }
                    if (tokens[0].equals("b")) {
                        type = AssetFilter.AssetType.Binary;
                    }
                    if (tokens[0].equals("a")) {
                        type = AssetFilter.AssetType.Audio;
                    }
                    if (tokens[0].equals("d")) {
                        type = AssetFilter.AssetType.Directory;
                    }
                    long size = Long.parseLong(tokens[2]);
                    if (type == AssetFilter.AssetType.Audio && !loader.isUseBrowserCache()) {
                        size = 0L;
                    }
                    assets.add((Object)new Asset(tokens[1].trim(), type, size, tokens[3]));
                }
                final PreloaderState state = new PreloaderState((Array<Asset>)assets);
                for (int i = 0; i < assets.size; ++i) {
                    final Asset asset = (Asset)assets.get(i);
                    if (Preloader.this.contains(asset.url)) {
                        asset.loaded = asset.size;
                        asset.succeed = true;
                        continue;
                    }
                    loader.load(Preloader.this.baseUrl + asset.url, asset.type, asset.mimeType, new AssetDownloader.AssetLoaderListener<Object>(){

                        @Override
                        public void onProgress(double amount) {
                            asset.loaded = (long)amount;
                            callback.update(state);
                        }

                        @Override
                        public void onFailure() {
                            asset.failed = true;
                            callback.error(asset.url);
                            callback.update(state);
                        }

                        @Override
                        public void onSuccess(Object result) {
                            switch (asset.type) {
                                case Text: {
                                    Preloader.this.texts.put((Object)asset.url, (Object)((String)result));
                                    break;
                                }
                                case Image: {
                                    Preloader.this.images.put((Object)asset.url, (Object)((ImageElement)result));
                                    break;
                                }
                                case Binary: {
                                    Preloader.this.binaries.put((Object)asset.url, (Object)((Blob)result));
                                    break;
                                }
                                case Audio: {
                                    Preloader.this.audio.put((Object)asset.url, (Object)((Blob)result));
                                    break;
                                }
                                case Directory: {
                                    Preloader.this.directories.put((Object)asset.url, null);
                                }
                            }
                            asset.succeed = true;
                            callback.update(state);
                        }
                    });
                }
                callback.update(state);
            }
        });
    }

    public InputStream read(String url) {
        if (this.texts.containsKey((Object)url)) {
            try {
                return new ByteArrayInputStream(((String)this.texts.get((Object)url)).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        if (this.images.containsKey((Object)url)) {
            return new ByteArrayInputStream(new byte[1]);
        }
        if (this.binaries.containsKey((Object)url)) {
            return ((Blob)this.binaries.get((Object)url)).read();
        }
        if (this.audio.containsKey((Object)url)) {
            return ((Blob)this.audio.get((Object)url)).read();
        }
        return null;
    }

    public boolean contains(String url) {
        return this.texts.containsKey((Object)url) || this.images.containsKey((Object)url) || this.binaries.containsKey((Object)url) || this.audio.containsKey((Object)url) || this.directories.containsKey((Object)url);
    }

    public boolean isText(String url) {
        return this.texts.containsKey((Object)url);
    }

    public boolean isImage(String url) {
        return this.images.containsKey((Object)url);
    }

    public boolean isBinary(String url) {
        return this.binaries.containsKey((Object)url);
    }

    public boolean isAudio(String url) {
        return this.audio.containsKey((Object)url);
    }

    public boolean isDirectory(String url) {
        return this.directories.containsKey((Object)url);
    }

    private boolean isChild(String path, String url) {
        return path.startsWith(url) && path.indexOf(47, url.length() + 1) < 0;
    }

    public FileHandle[] list(String url) {
        Array files = new Array();
        for (String path : this.texts.keys()) {
            if (!this.isChild(path, url)) continue;
            files.add((Object)new GwtFileHandle(this, path, Files.FileType.Internal));
        }
        FileHandle[] list = new FileHandle[files.size];
        System.arraycopy(files.items, 0, list, 0, list.length);
        return list;
    }

    public FileHandle[] list(String url, FileFilter filter) {
        Array files = new Array();
        for (String path : this.texts.keys()) {
            if (!this.isChild(path, url) || !filter.accept(new File(path))) continue;
            files.add((Object)new GwtFileHandle(this, path, Files.FileType.Internal));
        }
        FileHandle[] list = new FileHandle[files.size];
        System.arraycopy(files.items, 0, list, 0, list.length);
        return list;
    }

    public FileHandle[] list(String url, FilenameFilter filter) {
        Array files = new Array();
        for (String path : this.texts.keys()) {
            if (!this.isChild(path, url) || !filter.accept(new File(url), path.substring(url.length() + 1))) continue;
            files.add((Object)new GwtFileHandle(this, path, Files.FileType.Internal));
        }
        FileHandle[] list = new FileHandle[files.size];
        System.arraycopy(files.items, 0, list, 0, list.length);
        return list;
    }

    public FileHandle[] list(String url, String suffix) {
        Array files = new Array();
        for (String path : this.texts.keys()) {
            if (!this.isChild(path, url) || !path.endsWith(suffix)) continue;
            files.add((Object)new GwtFileHandle(this, path, Files.FileType.Internal));
        }
        FileHandle[] list = new FileHandle[files.size];
        System.arraycopy(files.items, 0, list, 0, list.length);
        return list;
    }

    public long length(String url) {
        if (this.texts.containsKey((Object)url)) {
            try {
                return ((String)this.texts.get((Object)url)).getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException e) {
                return ((String)this.texts.get((Object)url)).getBytes().length;
            }
        }
        if (this.images.containsKey((Object)url)) {
            return 1L;
        }
        if (this.binaries.containsKey((Object)url)) {
            return ((Blob)this.binaries.get((Object)url)).length();
        }
        if (this.audio.containsKey((Object)url)) {
            return ((Blob)this.audio.get((Object)url)).length();
        }
        return 0L;
    }

    public static class PreloaderState {
        public final Array<Asset> assets;

        public PreloaderState(Array<Asset> assets) {
            this.assets = assets;
        }

        public long getDownloadedSize() {
            long size = 0L;
            for (int i = 0; i < this.assets.size; ++i) {
                Asset asset = (Asset)this.assets.get(i);
                size += asset.succeed || asset.failed ? asset.size : Math.min(asset.size, asset.loaded);
            }
            return size;
        }

        public long getTotalSize() {
            long size = 0L;
            for (int i = 0; i < this.assets.size; ++i) {
                Asset asset = (Asset)this.assets.get(i);
                size += asset.size;
            }
            return size;
        }

        public float getProgress() {
            long total = this.getTotalSize();
            return total == 0L ? 1.0f : (float)this.getDownloadedSize() / (float)total;
        }

        public boolean hasEnded() {
            return this.getDownloadedSize() == this.getTotalSize();
        }
    }

    public static class Asset {
        public boolean succeed;
        public boolean failed;
        public long loaded;
        public final String url;
        public final AssetFilter.AssetType type;
        public final long size;
        public final String mimeType;

        public Asset(String url, AssetFilter.AssetType type, long size, String mimeType) {
            this.url = url;
            this.type = type;
            this.size = size;
            this.mimeType = mimeType;
        }
    }

    public static interface PreloaderCallback {
        public void update(PreloaderState var1);

        public void error(String var1);
    }
}

