/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.preloader;

import com.badlogic.gdx.backends.gwt.preloader.AssetFilter;
import com.badlogic.gdx.backends.gwt.preloader.DefaultAssetFilter;
import com.badlogic.gdx.backends.gwt.preloader.FileWrapper;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PreloaderBundleGenerator
extends Generator {
    public String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        System.out.println(new File(".").getAbsolutePath());
        String assetPath = this.getAssetPath(context);
        String assetOutputPath = this.getAssetOutputPath(context);
        if (assetOutputPath == null) {
            assetOutputPath = "war/";
        }
        AssetFilter assetFilter = this.getAssetFilter(context);
        FileWrapper source = new FileWrapper(assetPath);
        if (!source.exists() && !(source = new FileWrapper("../" + assetPath)).exists()) {
            throw new RuntimeException("assets path '" + assetPath + "' does not exist. Check your gdx.assetpath property in your GWT project's module gwt.xml file");
        }
        if (!source.isDirectory()) {
            throw new RuntimeException("assets path '" + assetPath + "' is not a directory. Check your gdx.assetpath property in your GWT project's module gwt.xml file");
        }
        System.out.println("Copying resources from " + assetPath + " to " + assetOutputPath);
        System.out.println(source.file.getAbsolutePath());
        FileWrapper target = new FileWrapper("assets/");
        System.out.println(target.file.getAbsolutePath());
        if (!target.file.getAbsolutePath().replace("\\", "/").endsWith(assetOutputPath + "assets")) {
            target = new FileWrapper(assetOutputPath + "assets/");
        }
        if (target.exists() && !target.deleteDirectory()) {
            throw new RuntimeException("Couldn't clean target path '" + target + "'");
        }
        ArrayList<Asset> assets = new ArrayList<Asset>();
        this.copyDirectory(source, target, assetFilter, assets);
        List<String> classpathFiles = this.getClasspathFiles(context);
        for (String classpathFile : classpathFiles) {
            if (!assetFilter.accept(classpathFile, false)) continue;
            try {
                InputStream inputStream = context.getClass().getClassLoader().getResourceAsStream(classpathFile);
                FileWrapper dest = target.child(classpathFile);
                dest.write(inputStream, false);
                assets.add(new Asset(dest, assetFilter.getType(dest.path())));
                inputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        HashMap<String, ArrayList<Asset>> bundles = new HashMap<String, ArrayList<Asset>>();
        for (Asset asset : assets) {
            ArrayList<Asset> bundleAssets;
            String bundleName = assetFilter.getBundleName(asset.file.path());
            if (bundleName == null) {
                bundleName = "assets";
            }
            if ((bundleAssets = (ArrayList<Asset>)bundles.get(bundleName)) == null) {
                bundleAssets = new ArrayList<Asset>();
                bundles.put(bundleName, bundleAssets);
            }
            bundleAssets.add(asset);
        }
        for (Map.Entry entry : bundles.entrySet()) {
            StringBuilder sb = new StringBuilder();
            for (Asset asset : (ArrayList)entry.getValue()) {
                String path = asset.file.path().replace('\\', '/').replace(assetOutputPath, "").replaceFirst("assets/", "");
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                sb.append(asset.type.code);
                sb.append(":");
                sb.append(path);
                sb.append(":");
                sb.append(asset.file.isDirectory() ? 0L : asset.file.length());
                sb.append(":");
                String mimetype = URLConnection.guessContentTypeFromName(asset.file.name());
                sb.append(mimetype == null ? "application/unknown" : mimetype);
                sb.append("\n");
            }
            target.child((String)entry.getKey() + ".txt").writeString(sb.toString(), false);
        }
        return this.createDummyClass(logger, context);
    }

    private void copyFile(FileWrapper source, FileWrapper dest, AssetFilter filter, ArrayList<Asset> assets) {
        if (!filter.accept(dest.path(), false)) {
            return;
        }
        try {
            assets.add(new Asset(dest, filter.getType(dest.path())));
            dest.write(source.read(), false);
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error copying source file: " + source + "\nTo destination: " + dest, (Throwable)ex);
        }
    }

    private void copyDirectory(FileWrapper sourceDir, FileWrapper destDir, AssetFilter filter, ArrayList<Asset> assets) {
        if (!filter.accept(destDir.path(), true)) {
            return;
        }
        assets.add(new Asset(destDir, AssetFilter.AssetType.Directory));
        destDir.mkdirs();
        for (FileWrapper srcFile : sourceDir.list()) {
            FileWrapper destFile = destDir.child(srcFile.name());
            if (srcFile.isDirectory()) {
                this.copyDirectory(srcFile, destFile, filter, assets);
                continue;
            }
            this.copyFile(srcFile, destFile, filter, assets);
        }
    }

    private AssetFilter getAssetFilter(GeneratorContext context) {
        ConfigurationProperty assetFilterClassProperty = null;
        try {
            assetFilterClassProperty = context.getPropertyOracle().getConfigurationProperty("gdx.assetfilterclass");
        }
        catch (BadPropertyValueException e) {
            return new DefaultAssetFilter();
        }
        if (assetFilterClassProperty.getValues().size() == 0) {
            return new DefaultAssetFilter();
        }
        String assetFilterClass = (String)assetFilterClassProperty.getValues().get(0);
        if (assetFilterClass == null) {
            return new DefaultAssetFilter();
        }
        try {
            return (AssetFilter)Class.forName(assetFilterClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't instantiate custom AssetFilter '" + assetFilterClass + "', make sure the class is public and has a public default constructor", e);
        }
    }

    private String getAssetPath(GeneratorContext context) {
        String[] tokens;
        ConfigurationProperty assetPathProperty = null;
        try {
            assetPathProperty = context.getPropertyOracle().getConfigurationProperty("gdx.assetpath");
        }
        catch (BadPropertyValueException e) {
            throw new RuntimeException("No gdx.assetpath defined. Add <set-configuration-property name=\"gdx.assetpath\" value=\"relative/path/to/assets/\"/> to your GWT projects gwt.xml file");
        }
        if (assetPathProperty.getValues().size() == 0) {
            throw new RuntimeException("No gdx.assetpath defined. Add <set-configuration-property name=\"gdx.assetpath\" value=\"relative/path/to/assets/\"/> to your GWT projects gwt.xml file");
        }
        String paths = (String)assetPathProperty.getValues().get(0);
        if (paths == null) {
            throw new RuntimeException("No gdx.assetpath defined. Add <set-configuration-property name=\"gdx.assetpath\" value=\"relative/path/to/assets/\"/> to your GWT projects gwt.xml file");
        }
        ArrayList existingPaths = new ArrayList();
        for (String token : tokens = paths.split(",")) {
            System.out.println(token);
            if (!new FileWrapper(token).exists() && !new FileWrapper("../" + token).exists()) continue;
            return token;
        }
        throw new RuntimeException("No valid gdx.assetpath defined. Fix <set-configuration-property name=\"gdx.assetpath\" value=\"relative/path/to/assets/\"/> in your GWT projects gwt.xml file");
    }

    private String getAssetOutputPath(GeneratorContext context) {
        ConfigurationProperty assetPathProperty = null;
        try {
            assetPathProperty = context.getPropertyOracle().getConfigurationProperty("gdx.assetoutputpath");
        }
        catch (BadPropertyValueException e) {
            return null;
        }
        if (assetPathProperty.getValues().size() == 0) {
            return null;
        }
        String paths = (String)assetPathProperty.getValues().get(0);
        if (paths == null) {
            return null;
        }
        ArrayList existingPaths = new ArrayList();
        String[] tokens = paths.split(",");
        String path = null;
        for (String token : tokens) {
            if (!new FileWrapper(token).exists() && !new FileWrapper(token).mkdirs()) continue;
            path = token;
        }
        if (path != null && !path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    private List<String> getClasspathFiles(GeneratorContext context) {
        ArrayList<String> classpathFiles = new ArrayList<String>();
        try {
            ConfigurationProperty prop = context.getPropertyOracle().getConfigurationProperty("gdx.files.classpath");
            for (String value : prop.getValues()) {
                classpathFiles.add(value);
            }
        }
        catch (BadPropertyValueException badPropertyValueException) {
            // empty catch block
        }
        return classpathFiles;
    }

    private String createDummyClass(TreeLogger logger, GeneratorContext context) {
        String packageName = "com.badlogic.gdx.backends.gwt.preloader";
        String className = "PreloaderBundleImpl";
        ClassSourceFileComposerFactory composer = new ClassSourceFileComposerFactory(packageName, className);
        composer.addImplementedInterface(packageName + ".PreloaderBundle");
        PrintWriter printWriter = context.tryCreate(logger, packageName, className);
        if (printWriter == null) {
            return packageName + "." + className;
        }
        SourceWriter sourceWriter = composer.createSourceWriter(context, printWriter);
        sourceWriter.commit(logger);
        return packageName + "." + className;
    }

    private class Asset {
        FileWrapper file;
        AssetFilter.AssetType type;

        public Asset(FileWrapper file, AssetFilter.AssetType type) {
            this.file = file;
            this.type = type;
        }
    }
}

