/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.gwt.widgets;

import com.badlogic.gdx.backends.gwt.widgets.ResizableWidget;
import com.badlogic.gdx.backends.gwt.widgets.ResizableWidgetCollection;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;

public class ProgressBar
extends Widget
implements ResizableWidget {
    private static final String DEFAULT_TEXT_CLASS_NAME = "gwt-ProgressBar-text";
    private String textClassName = "gwt-ProgressBar-text";
    private String textFirstHalfClassName = "gwt-ProgressBar-text-firstHalf";
    private String textSecondHalfClassName = "gwt-ProgressBar-text-secondHalf";
    private Element barElement;
    private double curProgress;
    private double maxProgress;
    private double minProgress;
    private boolean textVisible = true;
    private Element textElement;
    private TextFormatter textFormatter;

    public ProgressBar() {
        this(0.0, 100.0, 0.0);
    }

    public ProgressBar(double curProgress) {
        this(0.0, 100.0, curProgress);
    }

    public ProgressBar(double minProgress, double maxProgress) {
        this(minProgress, maxProgress, 0.0);
    }

    public ProgressBar(double minProgress, double maxProgress, double curProgress) {
        this(minProgress, maxProgress, curProgress, null);
    }

    public ProgressBar(double minProgress, double maxProgress, double curProgress, TextFormatter textFormatter) {
        this.minProgress = minProgress;
        this.maxProgress = maxProgress;
        this.curProgress = curProgress;
        this.setTextFormatter(textFormatter);
        this.setElement(DOM.createDiv());
        DOM.setStyleAttribute((com.google.gwt.dom.client.Element)this.getElement(), (String)"position", (String)"relative");
        this.setStyleName("gwt-ProgressBar-shell");
        this.barElement = DOM.createDiv();
        DOM.appendChild((com.google.gwt.dom.client.Element)this.getElement(), (com.google.gwt.dom.client.Element)this.barElement);
        DOM.setStyleAttribute((com.google.gwt.dom.client.Element)this.barElement, (String)"height", (String)"100%");
        this.setBarStyleName("gwt-ProgressBar-bar");
        this.textElement = DOM.createDiv();
        DOM.appendChild((com.google.gwt.dom.client.Element)this.getElement(), (com.google.gwt.dom.client.Element)this.textElement);
        DOM.setStyleAttribute((com.google.gwt.dom.client.Element)this.textElement, (String)"position", (String)"absolute");
        DOM.setStyleAttribute((com.google.gwt.dom.client.Element)this.textElement, (String)"top", (String)"0px");
        this.setProgress(curProgress);
    }

    public double getMaxProgress() {
        return this.maxProgress;
    }

    public double getMinProgress() {
        return this.minProgress;
    }

    public double getPercent() {
        if (this.maxProgress <= this.minProgress) {
            return 0.0;
        }
        double percent = (this.curProgress - this.minProgress) / (this.maxProgress - this.minProgress);
        return Math.max(0.0, Math.min(1.0, percent));
    }

    public double getProgress() {
        return this.curProgress;
    }

    public TextFormatter getTextFormatter() {
        return this.textFormatter;
    }

    public boolean isTextVisible() {
        return this.textVisible;
    }

    @Override
    public void onResize(int width, int height) {
        if (this.textVisible) {
            int textWidth = DOM.getElementPropertyInt((com.google.gwt.dom.client.Element)this.textElement, (String)"offsetWidth");
            int left = width / 2 - textWidth / 2;
            DOM.setStyleAttribute((com.google.gwt.dom.client.Element)this.textElement, (String)"left", (String)(left + "px"));
        }
    }

    public void redraw() {
        if (this.isAttached()) {
            int width = DOM.getElementPropertyInt((com.google.gwt.dom.client.Element)this.getElement(), (String)"clientWidth");
            int height = DOM.getElementPropertyInt((com.google.gwt.dom.client.Element)this.getElement(), (String)"clientHeight");
            this.onResize(width, height);
        }
    }

    public void setBarStyleName(String barClassName) {
        DOM.setElementProperty((com.google.gwt.dom.client.Element)this.barElement, (String)"className", (String)barClassName);
    }

    public void setMaxProgress(double maxProgress) {
        this.maxProgress = maxProgress;
        this.curProgress = Math.min(this.curProgress, maxProgress);
        this.resetProgress();
    }

    public void setMinProgress(double minProgress) {
        this.minProgress = minProgress;
        this.curProgress = Math.max(this.curProgress, minProgress);
        this.resetProgress();
    }

    public void setProgress(double curProgress) {
        this.curProgress = Math.max(this.minProgress, Math.min(this.maxProgress, curProgress));
        int percent = (int)(100.0 * this.getPercent());
        DOM.setStyleAttribute((com.google.gwt.dom.client.Element)this.barElement, (String)"width", (String)(percent + "%"));
        DOM.setElementProperty((com.google.gwt.dom.client.Element)this.textElement, (String)"innerHTML", (String)this.generateText(curProgress));
        this.updateTextStyle(percent);
        this.redraw();
    }

    public void setTextFirstHalfStyleName(String textFirstHalfClassName) {
        this.textFirstHalfClassName = textFirstHalfClassName;
        this.onTextStyleChange();
    }

    public void setTextFormatter(TextFormatter textFormatter) {
        this.textFormatter = textFormatter;
    }

    public void setTextSecondHalfStyleName(String textSecondHalfClassName) {
        this.textSecondHalfClassName = textSecondHalfClassName;
        this.onTextStyleChange();
    }

    public void setTextStyleName(String textClassName) {
        this.textClassName = textClassName;
        this.onTextStyleChange();
    }

    public void setTextVisible(boolean textVisible) {
        this.textVisible = textVisible;
        if (this.textVisible) {
            DOM.setStyleAttribute((com.google.gwt.dom.client.Element)this.textElement, (String)"display", (String)"");
            this.redraw();
        } else {
            DOM.setStyleAttribute((com.google.gwt.dom.client.Element)this.textElement, (String)"display", (String)"none");
        }
    }

    protected String generateText(double curProgress) {
        if (this.textFormatter != null) {
            return this.textFormatter.getText(this, curProgress);
        }
        return (int)(100.0 * this.getPercent()) + "%";
    }

    protected Element getBarElement() {
        return this.barElement;
    }

    protected Element getTextElement() {
        return this.textElement;
    }

    protected void onLoad() {
        DOM.setStyleAttribute((com.google.gwt.dom.client.Element)this.getElement(), (String)"position", (String)"relative");
        ResizableWidgetCollection.get().add(this);
        this.redraw();
    }

    protected void onUnload() {
        ResizableWidgetCollection.get().remove(this);
    }

    protected void resetProgress() {
        this.setProgress(this.getProgress());
    }

    private void onTextStyleChange() {
        int percent = (int)(100.0 * this.getPercent());
        this.updateTextStyle(percent);
    }

    private void updateTextStyle(int percent) {
        if (percent < 50) {
            DOM.setElementProperty((com.google.gwt.dom.client.Element)this.textElement, (String)"className", (String)(this.textClassName + " " + this.textFirstHalfClassName));
        } else {
            DOM.setElementProperty((com.google.gwt.dom.client.Element)this.textElement, (String)"className", (String)(this.textClassName + " " + this.textSecondHalfClassName));
        }
    }

    public static abstract class TextFormatter {
        protected abstract String getText(ProgressBar var1, double var2);
    }
}

