/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.VertexData;
import com.badlogic.gdx.utils.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class VertexBufferObject
implements VertexData {
    final VertexAttributes attributes;
    final FloatBuffer buffer;
    int bufferHandle;
    final boolean isStatic;
    final int usage;
    boolean isDirty = false;
    boolean isBound = false;

    public VertexBufferObject(boolean isStatic, int numVertices, VertexAttribute ... attributes) {
        this(isStatic, numVertices, new VertexAttributes(attributes));
    }

    public VertexBufferObject(boolean isStatic, int numVertices, VertexAttributes attributes) {
        this.isStatic = isStatic;
        this.attributes = attributes;
        this.buffer = BufferUtils.newFloatBuffer(this.attributes.vertexSize / 4 * numVertices);
        this.buffer.flip();
        this.bufferHandle = Gdx.gl20.glGenBuffer();
        this.usage = isStatic ? 35044 : 35048;
    }

    public VertexAttributes getAttributes() {
        return this.attributes;
    }

    public int getNumVertices() {
        return this.buffer.limit() / (this.attributes.vertexSize / 4);
    }

    public int getNumMaxVertices() {
        return this.buffer.capacity() / (this.attributes.vertexSize / 4);
    }

    public FloatBuffer getBuffer() {
        this.isDirty = true;
        return this.buffer;
    }

    private void bufferChanged() {
        if (this.isBound) {
            Gdx.gl20.glBufferData(34962, this.buffer.limit(), (Buffer)this.buffer, this.usage);
            this.isDirty = false;
        }
    }

    public void setVertices(float[] vertices, int offset, int count) {
        this.isDirty = true;
        BufferUtils.copy(vertices, this.buffer, count, offset);
        this.buffer.position(0);
        this.buffer.limit(count);
        this.bufferChanged();
    }

    public void updateVertices(int targetOffset, float[] vertices, int sourceOffset, int count) {
        this.isDirty = true;
        int pos = this.buffer.position();
        this.buffer.position(targetOffset);
        BufferUtils.copy(vertices, sourceOffset, count, (Buffer)this.buffer);
        this.buffer.position(pos);
        this.bufferChanged();
    }

    public void bind(ShaderProgram shader) {
        this.bind(shader, null);
    }

    public void bind(ShaderProgram shader, int[] locations) {
        GL20 gl = Gdx.gl20;
        gl.glBindBuffer(34962, this.bufferHandle);
        if (this.isDirty) {
            gl.glBufferData(34962, this.buffer.limit(), (Buffer)this.buffer, this.usage);
            this.isDirty = false;
        }
        int numAttributes = this.attributes.size();
        if (locations == null) {
            for (int i = 0; i < numAttributes; ++i) {
                VertexAttribute attribute = this.attributes.get(i);
                int location = shader.getAttributeLocation(attribute.alias);
                if (location < 0) continue;
                shader.enableVertexAttribute(location);
                if (attribute.usage == 4) {
                    shader.setVertexAttribute(location, attribute.numComponents, 5121, true, this.attributes.vertexSize, attribute.offset);
                    continue;
                }
                shader.setVertexAttribute(location, attribute.numComponents, 5126, false, this.attributes.vertexSize, attribute.offset);
            }
        } else {
            for (int i = 0; i < numAttributes; ++i) {
                VertexAttribute attribute = this.attributes.get(i);
                int location = locations[i];
                if (location < 0) continue;
                shader.enableVertexAttribute(location);
                if (attribute.usage == 4) {
                    shader.setVertexAttribute(location, attribute.numComponents, 5121, true, this.attributes.vertexSize, attribute.offset);
                    continue;
                }
                shader.setVertexAttribute(location, attribute.numComponents, 5126, false, this.attributes.vertexSize, attribute.offset);
            }
        }
        this.isBound = true;
    }

    public void unbind(ShaderProgram shader) {
        this.unbind(shader, null);
    }

    public void unbind(ShaderProgram shader, int[] locations) {
        GL20 gl = Gdx.gl20;
        int numAttributes = this.attributes.size();
        if (locations == null) {
            for (int i = 0; i < numAttributes; ++i) {
                shader.disableVertexAttribute(this.attributes.get((int)i).alias);
            }
        } else {
            for (int i = 0; i < numAttributes; ++i) {
                int location = locations[i];
                if (location < 0) continue;
                shader.disableVertexAttribute(location);
            }
        }
        gl.glBindBuffer(34962, 0);
        this.isBound = false;
    }

    public void invalidate() {
        this.bufferHandle = Gdx.gl20.glGenBuffer();
        this.isDirty = true;
    }

    public void dispose() {
        GL20 gl = Gdx.gl20;
        gl.glBindBuffer(34962, 0);
        gl.glDeleteBuffer(this.bufferHandle);
        this.bufferHandle = 0;
    }
}

