/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.profiling;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.profiling.GLInterceptor;
import com.badlogic.gdx.utils.GdxRuntimeException;

public interface GLErrorListener {
    public static final GLErrorListener LOGGING_LISTENER = new GLErrorListener(){

        @Override
        public void onError(int error) {
            Exception exc = new Exception();
            String place = null;
            try {
                StackTraceElement[] stack = exc.getStackTrace();
                for (int i = 0; i < stack.length; ++i) {
                    if (!stack[i].getMethodName().contains("check")) continue;
                    if (i + 1 < stack.length) {
                        StackTraceElement glMethod = stack[i + 1];
                        place = glMethod.getMethodName();
                    }
                    break;
                }
            }
            catch (Exception stack) {
                // empty catch block
            }
            if (place != null) {
                Gdx.app.error("GLProfiler", "Error " + GLInterceptor.resolveErrorNumber((int)error) + " from " + place);
            } else {
                StringBuilder sb = new StringBuilder("Error ");
                sb.append(GLInterceptor.resolveErrorNumber((int)error));
                sb.append(" at:\n");
                try {
                    StackTraceElement[] stack = exc.getStackTrace();
                    for (int i = 0; i < stack.length; ++i) {
                        sb.append(stack[i].toString()).append('\n');
                    }
                }
                catch (Exception ignored) {
                    sb.append(" (Failed to print stack trace: ").append(ignored).append(")");
                }
                Gdx.app.error("GLProfiler", sb.toString());
            }
        }
    };
    public static final GLErrorListener THROWING_LISTENER = new GLErrorListener(){

        @Override
        public void onError(int error) {
            throw new GdxRuntimeException("GLProfiler: Got GL error " + GLInterceptor.resolveErrorNumber((int)error));
        }
    };

    public void onError(int var1);
}

