/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.google.gwt.core.client.GWT;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class BufferUtils {
    public static void copy(float[] src, Buffer dst, int numFloats, int offset) {
        FloatBuffer floatBuffer = BufferUtils.asFloatBuffer(dst);
        floatBuffer.clear();
        dst.position(0);
        floatBuffer.put(src, offset, numFloats);
        dst.position(0);
        if (dst instanceof ByteBuffer) {
            dst.limit(numFloats << 2);
        } else {
            dst.limit(numFloats);
        }
    }

    public static void copy(byte[] src, int srcOffset, Buffer dst, int numElements) {
        if (!(dst instanceof ByteBuffer)) {
            throw new GdxRuntimeException("dst must be a ByteBuffer");
        }
        ByteBuffer byteBuffer = (ByteBuffer)dst;
        int oldPosition = byteBuffer.position();
        byteBuffer.limit(oldPosition + numElements);
        byteBuffer.put(src, srcOffset, numElements);
        byteBuffer.position(oldPosition);
    }

    public static void copy(short[] src, int srcOffset, Buffer dst, int numElements) {
        ShortBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asShortBuffer();
        } else if (dst instanceof ShortBuffer) {
            buffer = (ShortBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or ShortBuffer");
        }
        int oldPosition = buffer.position();
        buffer.limit(oldPosition + numElements);
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
    }

    public static void copy(char[] src, int srcOffset, Buffer dst, int numElements) {
        CharBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asCharBuffer();
        } else if (dst instanceof CharBuffer) {
            buffer = (CharBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or CharBuffer");
        }
        int oldPosition = buffer.position();
        buffer.limit(oldPosition + numElements);
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
    }

    public static void copy(int[] src, int srcOffset, Buffer dst, int numElements) {
        IntBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asIntBuffer();
        } else if (dst instanceof IntBuffer) {
            buffer = (IntBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or IntBuffer");
        }
        int oldPosition = buffer.position();
        buffer.limit(oldPosition + numElements);
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
    }

    public static void copy(long[] src, int srcOffset, Buffer dst, int numElements) {
        LongBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asLongBuffer();
        } else if (dst instanceof LongBuffer) {
            buffer = (LongBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or LongBuffer");
        }
        int oldPosition = buffer.position();
        buffer.limit(oldPosition + numElements);
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
    }

    public static void copy(float[] src, int srcOffset, Buffer dst, int numElements) {
        FloatBuffer buffer = BufferUtils.asFloatBuffer(dst);
        int oldPosition = buffer.position();
        buffer.limit(oldPosition + numElements);
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
    }

    public static void copy(double[] src, int srcOffset, Buffer dst, int numElements) {
        DoubleBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asDoubleBuffer();
        } else if (dst instanceof DoubleBuffer) {
            buffer = (DoubleBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or DoubleBuffer");
        }
        int oldPosition = buffer.position();
        buffer.limit(oldPosition + numElements);
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
    }

    public static void copy(char[] src, int srcOffset, int numElements, Buffer dst) {
        CharBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asCharBuffer();
        } else if (dst instanceof CharBuffer) {
            buffer = (CharBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or CharBuffer");
        }
        int oldPosition = buffer.position();
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
    }

    public static void copy(int[] src, int srcOffset, int numElements, Buffer dst) {
        IntBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asIntBuffer();
        } else if (dst instanceof IntBuffer) {
            buffer = (IntBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or IntBuffer");
        }
        int oldPosition = buffer.position();
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
    }

    public static void copy(long[] src, int srcOffset, int numElements, Buffer dst) {
        LongBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asLongBuffer();
        } else if (dst instanceof LongBuffer) {
            buffer = (LongBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or LongBuffer");
        }
        int oldPosition = buffer.position();
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
    }

    public static void copy(float[] src, int srcOffset, int numElements, Buffer dst) {
        FloatBuffer buffer = BufferUtils.asFloatBuffer(dst);
        int oldPosition = buffer.position();
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
    }

    public static void copy(double[] src, int srcOffset, int numElements, Buffer dst) {
        DoubleBuffer buffer = null;
        if (dst instanceof ByteBuffer) {
            buffer = ((ByteBuffer)dst).asDoubleBuffer();
        } else if (dst instanceof DoubleBuffer) {
            buffer = (DoubleBuffer)dst;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("dst must be a ByteBuffer or DoubleBuffer");
        }
        int oldPosition = buffer.position();
        buffer.put(src, srcOffset, numElements);
        buffer.position(oldPosition);
    }

    public static void copy(Buffer src, Buffer dst, int numElements) {
        int srcPos = src.position();
        int dstPos = dst.position();
        src.limit(srcPos + numElements);
        boolean srcIsByte = src instanceof ByteBuffer;
        boolean dstIsByte = dst instanceof ByteBuffer;
        dst.limit(dst.capacity());
        if (srcIsByte && dstIsByte) {
            ((ByteBuffer)dst).put((ByteBuffer)src);
        } else if ((srcIsByte || src instanceof CharBuffer) && (dstIsByte || dst instanceof CharBuffer)) {
            (dstIsByte ? ((ByteBuffer)dst).asCharBuffer() : (CharBuffer)dst).put(srcIsByte ? ((ByteBuffer)src).asCharBuffer() : (CharBuffer)src);
        } else if ((srcIsByte || src instanceof ShortBuffer) && (dstIsByte || dst instanceof ShortBuffer)) {
            (dstIsByte ? ((ByteBuffer)dst).asShortBuffer() : (ShortBuffer)dst).put(srcIsByte ? ((ByteBuffer)src).asShortBuffer() : (ShortBuffer)src);
        } else if ((srcIsByte || src instanceof IntBuffer) && (dstIsByte || dst instanceof IntBuffer)) {
            (dstIsByte ? ((ByteBuffer)dst).asIntBuffer() : (IntBuffer)dst).put(srcIsByte ? ((ByteBuffer)src).asIntBuffer() : (IntBuffer)src);
        } else if ((srcIsByte || src instanceof LongBuffer) && (dstIsByte || dst instanceof LongBuffer)) {
            (dstIsByte ? ((ByteBuffer)dst).asLongBuffer() : (LongBuffer)dst).put(srcIsByte ? ((ByteBuffer)src).asLongBuffer() : (LongBuffer)src);
        } else if ((srcIsByte || src instanceof FloatBuffer) && (dstIsByte || dst instanceof FloatBuffer)) {
            (dstIsByte ? ((ByteBuffer)dst).asFloatBuffer() : (FloatBuffer)dst).put(srcIsByte ? ((ByteBuffer)src).asFloatBuffer() : (FloatBuffer)src);
        } else if ((srcIsByte || src instanceof DoubleBuffer) && (dstIsByte || dst instanceof DoubleBuffer)) {
            (dstIsByte ? ((ByteBuffer)dst).asDoubleBuffer() : (DoubleBuffer)dst).put(srcIsByte ? ((ByteBuffer)src).asDoubleBuffer() : (DoubleBuffer)src);
        } else {
            throw new GdxRuntimeException("Buffers must be of same type or ByteBuffer");
        }
        src.position(srcPos);
        dst.flip();
        dst.position(dstPos);
    }

    private static final FloatBuffer asFloatBuffer(Buffer data) {
        FloatBuffer buffer = null;
        if (data instanceof ByteBuffer) {
            buffer = ((ByteBuffer)data).asFloatBuffer();
        } else if (data instanceof FloatBuffer) {
            buffer = (FloatBuffer)data;
        }
        if (buffer == null) {
            throw new GdxRuntimeException("data must be a ByteBuffer or FloatBuffer");
        }
        return buffer;
    }

    private static final float[] asFloatArray(FloatBuffer buffer) {
        int pos = buffer.position();
        float[] result = new float[buffer.remaining()];
        buffer.get(result);
        buffer.position(pos);
        return result;
    }

    public static void transform(Buffer data, int dimensions, int strideInBytes, int count, Matrix4 matrix) {
        int pos;
        FloatBuffer buffer = BufferUtils.asFloatBuffer(data);
        int idx = pos = buffer.position();
        float[] arr = BufferUtils.asFloatArray(buffer);
        int stride = strideInBytes / 4;
        float[] m = matrix.val;
        for (int i = 0; i < count; ++i) {
            float x = arr[idx];
            float y = arr[idx + 1];
            float z = dimensions >= 3 ? arr[idx + 2] : 0.0f;
            float w = dimensions >= 4 ? arr[idx + 3] : 1.0f;
            arr[idx] = x * m[0] + y * m[4] + z * m[8] + w * m[12];
            arr[idx + 1] = x * m[1] + y * m[5] + z * m[9] + w * m[13];
            if (dimensions >= 3) {
                arr[idx + 2] = x * m[2] + y * m[6] + z * m[10] + w * m[14];
                if (dimensions >= 4) {
                    arr[idx + 3] = x * m[3] + y * m[7] + z * m[11] + w * m[15];
                }
            }
            idx += stride;
        }
        buffer.put(arr);
        buffer.position(pos);
    }

    public static void transform(Buffer data, int dimensions, int strideInBytes, int count, Matrix3 matrix) {
        int pos;
        FloatBuffer buffer = BufferUtils.asFloatBuffer(data);
        int idx = pos = buffer.position();
        float[] arr = BufferUtils.asFloatArray(buffer);
        int stride = strideInBytes / 4;
        float[] m = matrix.val;
        for (int i = 0; i < count; ++i) {
            float x = arr[idx];
            float y = arr[idx + 1];
            float z = dimensions >= 3 ? arr[idx + 2] : 1.0f;
            arr[idx] = x * m[0] + y * m[3] + z * m[6];
            arr[idx + 1] = x * m[1] + y * m[4] + z * m[7];
            if (dimensions >= 3) {
                arr[idx + 2] = x * m[2] + y * m[5] + z * m[8];
            }
            idx += stride;
        }
        buffer.put(arr);
        buffer.position(pos);
    }

    public static long findFloats(Buffer vertex, int strideInBytes, Buffer vertices, int numVertices) {
        return BufferUtils.findFloats(BufferUtils.asFloatArray(BufferUtils.asFloatBuffer(vertex)), strideInBytes, BufferUtils.asFloatArray(BufferUtils.asFloatBuffer(vertices)), numVertices);
    }

    public static long findFloats(float[] vertex, int strideInBytes, Buffer vertices, int numVertices) {
        return BufferUtils.findFloats(vertex, strideInBytes, BufferUtils.asFloatArray(BufferUtils.asFloatBuffer(vertices)), numVertices);
    }

    public static long findFloats(Buffer vertex, int strideInBytes, float[] vertices, int numVertices) {
        return BufferUtils.findFloats(BufferUtils.asFloatArray(BufferUtils.asFloatBuffer(vertex)), strideInBytes, vertices, numVertices);
    }

    public static long findFloats(float[] vertex, int strideInBytes, float[] vertices, int numVertices) {
        int size = strideInBytes / 4;
        for (int i = 0; i < numVertices; ++i) {
            int offset = i * size;
            boolean found = true;
            for (int j = 0; !found && j < size; ++j) {
                if (vertices[offset + j] == vertex[j]) continue;
                found = false;
            }
            if (!found) continue;
            return i;
        }
        return -1L;
    }

    public static long findFloats(Buffer vertex, int strideInBytes, Buffer vertices, int numVertices, float epsilon) {
        return BufferUtils.findFloats(BufferUtils.asFloatArray(BufferUtils.asFloatBuffer(vertex)), strideInBytes, BufferUtils.asFloatArray(BufferUtils.asFloatBuffer(vertices)), numVertices, epsilon);
    }

    public static long findFloats(float[] vertex, int strideInBytes, Buffer vertices, int numVertices, float epsilon) {
        return BufferUtils.findFloats(vertex, strideInBytes, BufferUtils.asFloatArray(BufferUtils.asFloatBuffer(vertices)), numVertices, epsilon);
    }

    public static long findFloats(Buffer vertex, int strideInBytes, float[] vertices, int numVertices, float epsilon) {
        return BufferUtils.findFloats(BufferUtils.asFloatArray(BufferUtils.asFloatBuffer(vertex)), strideInBytes, vertices, numVertices, epsilon);
    }

    public static long findFloats(float[] vertex, int strideInBytes, float[] vertices, int numVertices, float epsilon) {
        int size = strideInBytes / 4;
        for (int i = 0; i < numVertices; ++i) {
            int offset = i * size;
            boolean found = true;
            for (int j = 0; !found && j < size; ++j) {
                float f = vertices[offset + j] > vertex[j] ? vertices[offset + j] - vertex[j] : vertex[j] - vertices[offset + j];
                if (!(f > epsilon)) continue;
                found = false;
            }
            if (!found) continue;
            return i;
        }
        return -1L;
    }

    public static FloatBuffer newFloatBuffer(int numFloats) {
        if (GWT.isProdMode()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(numFloats * 4);
            buffer.order(ByteOrder.nativeOrder());
            return buffer.asFloatBuffer();
        }
        return FloatBuffer.wrap(new float[numFloats]);
    }

    public static DoubleBuffer newDoubleBuffer(int numDoubles) {
        if (GWT.isProdMode()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(numDoubles * 8);
            buffer.order(ByteOrder.nativeOrder());
            return buffer.asDoubleBuffer();
        }
        return DoubleBuffer.wrap(new double[numDoubles]);
    }

    public static ByteBuffer newByteBuffer(int numBytes) {
        if (GWT.isProdMode()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(numBytes);
            buffer.order(ByteOrder.nativeOrder());
            return buffer;
        }
        return ByteBuffer.wrap(new byte[numBytes]);
    }

    public static ShortBuffer newShortBuffer(int numShorts) {
        if (GWT.isProdMode()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(numShorts * 2);
            buffer.order(ByteOrder.nativeOrder());
            return buffer.asShortBuffer();
        }
        return ShortBuffer.wrap(new short[numShorts]);
    }

    public static CharBuffer newCharBuffer(int numChars) {
        if (GWT.isProdMode()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(numChars * 2);
            buffer.order(ByteOrder.nativeOrder());
            return buffer.asCharBuffer();
        }
        return CharBuffer.wrap(new char[numChars]);
    }

    public static IntBuffer newIntBuffer(int numInts) {
        if (GWT.isProdMode()) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(numInts * 4);
            buffer.order(ByteOrder.nativeOrder());
            return buffer.asIntBuffer();
        }
        return IntBuffer.wrap(new int[numInts]);
    }

    public static LongBuffer newLongBuffer(int numLongs) {
        return LongBuffer.wrap(new long[numLongs]);
    }
}

