/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

public class Utf8Decoder {
    private static final char REPLACEMENT = '\ufffd';
    private static final int UTF8_ACCEPT = 0;
    private static final int UTF8_REJECT = 12;
    private static final byte[] BYTE_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final byte[] TRANSITION_TABLE = new byte[]{0, 12, 24, 36, 60, 96, 84, 12, 12, 12, 48, 72, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 12, 12, 12, 12, 12, 0, 12, 0, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    private int codePoint;
    private int state = 0;
    private final char[] utf16Char = new char[2];
    private char[] charBuffer;
    private int charOffset;

    protected void reset() {
        this.state = 0;
    }

    public int decode(byte[] b, int offset, int length, char[] charBuffer, int charOffset) {
        this.charBuffer = charBuffer;
        this.charOffset = charOffset;
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.decode(b[i]);
        }
        return this.charOffset - charOffset;
    }

    private void decode(byte b) {
        if (b > 0 && this.state == 0) {
            this.charBuffer[this.charOffset++] = (char)(b & 0xFF);
        } else {
            int i = b & 0xFF;
            byte type = BYTE_TABLE[i];
            this.codePoint = this.state == 0 ? 255 >> type & i : i & 0x3F | this.codePoint << 6;
            int next = TRANSITION_TABLE[this.state + type];
            switch (next) {
                case 0: {
                    this.state = next;
                    if (this.codePoint < 55296) {
                        this.charBuffer[this.charOffset++] = (char)this.codePoint;
                        break;
                    }
                    int codePointLength = Character.toChars(this.codePoint, this.utf16Char, 0);
                    this.charBuffer[this.charOffset++] = this.utf16Char[0];
                    if (codePointLength != 2) break;
                    this.charBuffer[this.charOffset++] = this.utf16Char[1];
                    break;
                }
                case 12: {
                    this.codePoint = 0;
                    this.state = 0;
                    this.charBuffer[this.charOffset++] = 65533;
                    break;
                }
                default: {
                    this.state = next;
                }
            }
        }
    }
}

