/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.reflect;

import com.badlogic.gdx.utils.reflect.Annotation;
import com.badlogic.gdx.utils.reflect.ReflectionException;
import com.badlogic.gwtref.client.Parameter;

public final class Method {
    private final com.badlogic.gwtref.client.Method method;

    Method(com.badlogic.gwtref.client.Method method) {
        this.method = method;
    }

    public String getName() {
        return this.method.getName();
    }

    public Class getReturnType() {
        return this.method.getReturnType();
    }

    public Class[] getParameterTypes() {
        Parameter[] parameters = this.method.getParameters();
        Class[] parameterTypes = new Class[parameters.length];
        int j = parameters.length;
        for (int i = 0; i < j; ++i) {
            parameterTypes[i] = parameters[i].getClazz();
        }
        return parameterTypes;
    }

    public Class getDeclaringClass() {
        return this.method.getEnclosingType();
    }

    public boolean isAccessible() {
        return this.method.isPublic();
    }

    public void setAccessible(boolean accessible) {
    }

    public boolean isAbstract() {
        return this.method.isAbstract();
    }

    public boolean isDefaultAccess() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    public boolean isFinal() {
        return this.method.isFinal();
    }

    public boolean isPrivate() {
        return this.method.isPrivate();
    }

    public boolean isProtected() {
        return this.method.isProtected();
    }

    public boolean isPublic() {
        return this.method.isPublic();
    }

    public boolean isNative() {
        return this.method.isNative();
    }

    public boolean isStatic() {
        return this.method.isStatic();
    }

    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    public Object invoke(Object obj, Object ... args) throws ReflectionException {
        try {
            return this.method.invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            throw new ReflectionException("Illegal argument(s) supplied to method: " + this.getName(), (Throwable)e);
        }
    }

    public boolean isAnnotationPresent(Class<? extends java.lang.annotation.Annotation> annotationType) {
        java.lang.annotation.Annotation[] annotations = this.method.getDeclaredAnnotations();
        if (annotations != null) {
            for (java.lang.annotation.Annotation annotation : annotations) {
                if (!annotation.annotationType().equals(annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    public Annotation[] getDeclaredAnnotations() {
        java.lang.annotation.Annotation[] annotations = this.method.getDeclaredAnnotations();
        if (annotations == null) {
            return new Annotation[0];
        }
        Annotation[] result = new Annotation[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            result[i] = new Annotation(annotations[i]);
        }
        return result;
    }

    public Annotation getDeclaredAnnotation(Class<? extends java.lang.annotation.Annotation> annotationType) {
        java.lang.annotation.Annotation[] annotations = this.method.getDeclaredAnnotations();
        if (annotations == null) {
            return null;
        }
        for (java.lang.annotation.Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return new Annotation(annotation);
        }
        return null;
    }
}

