/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gwtref.gen;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JAbstractMethod;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JConstructor;
import com.google.gwt.core.ext.typeinfo.JEnumConstant;
import com.google.gwt.core.ext.typeinfo.JEnumType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPackage;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReflectionCacheSourceCreator {
    private static final List<String> PRIMITIVE_TYPES = Collections.unmodifiableList(Arrays.asList("char", "int", "long", "byte", "short", "float", "double", "boolean"));
    final TreeLogger logger;
    final GeneratorContext context;
    final JClassType type;
    final String simpleName;
    final String packageName;
    SourceWriter sw;
    final StringBuilder source = new StringBuilder();
    final List<JType> types = new ArrayList<JType>();
    final List<SetterGetterStub> setterGetterStubs = new ArrayList<SetterGetterStub>();
    final List<MethodStub> methodStubs = new ArrayList<MethodStub>();
    final Map<String, String> parameterName2ParameterInstantiation = new HashMap<String, String>();
    final Map<String, Integer> typeNames2typeIds = new HashMap<String, Integer>();
    int nextTypeId;
    int nextSetterGetterId;
    int nextInvokableId;
    int nesting = 0;
    StringBuilder sb = new StringBuilder();

    public ReflectionCacheSourceCreator(TreeLogger logger, GeneratorContext context, JClassType type) {
        this.logger = logger;
        this.context = context;
        this.type = type;
        this.packageName = type.getPackage().getName();
        this.simpleName = type.getSimpleSourceName() + "Generated";
        logger.log(TreeLogger.Type.INFO, type.getQualifiedSourceName());
    }

    public String create() {
        ClassSourceFileComposerFactory composer = new ClassSourceFileComposerFactory(this.packageName, this.simpleName);
        composer.addImplementedInterface("com.badlogic.gwtref.client.IReflectionCache");
        this.imports(composer);
        PrintWriter printWriter = this.context.tryCreate(this.logger, this.packageName, this.simpleName);
        if (printWriter == null) {
            return this.packageName + "." + this.simpleName;
        }
        this.sw = composer.createSourceWriter(this.context, printWriter);
        this.generateLookups();
        this.forNameC();
        this.newArrayC();
        this.getArrayLengthT();
        this.getArrayElementT();
        this.setArrayElementT();
        this.getF();
        this.setF();
        this.invokeM();
        this.sw.commit(this.logger);
        this.createProxy(this.type);
        return this.packageName + "." + this.simpleName;
    }

    private void createProxy(JClassType type) {
        ClassSourceFileComposerFactory composer = new ClassSourceFileComposerFactory(type.getPackage().getName(), type.getSimpleSourceName() + "Proxy");
        PrintWriter printWriter = this.context.tryCreate(this.logger, this.packageName, this.simpleName);
        if (printWriter == null) {
            return;
        }
        SourceWriter writer = composer.createSourceWriter(this.context, printWriter);
        writer.commit(this.logger);
    }

    private void generateLookups() {
        TypeOracle typeOracle = this.context.getTypeOracle();
        JPackage[] packages = typeOracle.getPackages();
        for (JPackage p : packages) {
            for (JClassType t : p.getTypes()) {
                this.gatherTypes((JType)t.getErasedType(), this.types);
            }
        }
        try {
            ConfigurationProperty prop = this.context.getPropertyOracle().getConfigurationProperty("gdx.reflect.include");
            for (String s : prop.getValues()) {
                JClassType type = typeOracle.findType(s);
                if (type == null) continue;
                this.gatherTypes((JType)type.getErasedType(), this.types);
            }
        }
        catch (BadPropertyValueException badPropertyValueException) {
            // empty catch block
        }
        this.gatherTypes((JType)typeOracle.findType("java.util.List").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.util.ArrayList").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.util.HashMap").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.util.Map").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.String").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Boolean").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Byte").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Long").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Character").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Short").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Integer").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Float").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.CharSequence").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Double").getErasedType(), this.types);
        this.gatherTypes((JType)typeOracle.findType("java.lang.Object").getErasedType(), this.types);
        Collections.sort(this.types, new Comparator<JType>(){

            @Override
            public int compare(JType o1, JType o2) {
                return o1.getQualifiedSourceName().compareTo(o2.getQualifiedSourceName());
            }
        });
        for (JType t : this.types) {
            this.p(this.createTypeGenerator(t));
        }
        this.parameterInitialization();
        Collections.sort(this.setterGetterStubs, new Comparator<SetterGetterStub>(){

            @Override
            public int compare(SetterGetterStub o1, SetterGetterStub o2) {
                return new Integer(o1.setter).compareTo(o2.setter);
            }
        });
        for (SetterGetterStub stub : this.setterGetterStubs) {
            String stubSource = this.generateSetterGetterStub(stub);
            if (stubSource.equals("")) {
                stub.unused = true;
            }
            this.p(stubSource);
        }
        Collections.sort(this.methodStubs, new Comparator<MethodStub>(){

            @Override
            public int compare(MethodStub o1, MethodStub o2) {
                return new Integer(o1.methodId).compareTo(o2.methodId);
            }
        });
        for (MethodStub stub : this.methodStubs) {
            String stubSource = this.generateMethodStub(stub);
            if (stubSource.equals("")) {
                stub.unused = true;
            }
            this.p(stubSource);
        }
        this.logger.log(TreeLogger.Type.INFO, this.types.size() + " types reflected");
    }

    private void out(String message, int nesting) {
        for (int i = 0; i < nesting; ++i) {
            System.out.print("  ");
        }
        System.out.println(message);
    }

    private void gatherTypes(JType type, List<JType> types) {
        JClassType[] inner;
        JMethod[] methods;
        ++this.nesting;
        if (type == null) {
            --this.nesting;
            return;
        }
        if (type.getQualifiedSourceName().contains("-")) {
            --this.nesting;
            return;
        }
        if (!this.isVisible(type)) {
            --this.nesting;
            return;
        }
        boolean keep = false;
        String name = type.getQualifiedSourceName();
        try {
            keep |= !name.contains(".");
            ConfigurationProperty prop = this.context.getPropertyOracle().getConfigurationProperty("gdx.reflect.include");
            for (String string : prop.getValues()) {
                keep |= name.contains(string);
            }
            prop = this.context.getPropertyOracle().getConfigurationProperty("gdx.reflect.exclude");
            for (String string : prop.getValues()) {
                keep &= !name.equals(string);
            }
        }
        catch (BadPropertyValueException e) {
            e.printStackTrace();
        }
        if (!keep) {
            --this.nesting;
            return;
        }
        if (types.contains(type.getErasedType())) {
            --this.nesting;
            return;
        }
        types.add(type.getErasedType());
        this.out(type.getErasedType().getQualifiedSourceName(), this.nesting);
        if (type instanceof JPrimitiveType) {
            --this.nesting;
            return;
        }
        JClassType c = (JClassType)type;
        JField[] fields = c.getFields();
        if (fields != null) {
            for (JField field : fields) {
                this.gatherTypes(field.getType().getErasedType(), types);
            }
        }
        this.gatherTypes((JType)c.getSuperclass(), types);
        JClassType[] jClassTypeArray = c.getImplementedInterfaces();
        if (jClassTypeArray != null) {
            for (JClassType i : jClassTypeArray) {
                this.gatherTypes((JType)i.getErasedType(), types);
            }
        }
        if ((methods = c.getMethods()) != null) {
            for (JMethod m : methods) {
                this.gatherTypes(m.getReturnType().getErasedType(), types);
                if (m.getParameterTypes() == null) continue;
                for (JType p : m.getParameterTypes()) {
                    this.gatherTypes(p.getErasedType(), types);
                }
            }
        }
        if ((inner = c.getNestedTypes()) != null) {
            for (JClassType i : inner) {
                this.gatherTypes((JType)i.getErasedType(), types);
            }
        }
        --this.nesting;
    }

    private String generateMethodStub(MethodStub stub) {
        int i;
        this.sb.setLength(0);
        if (stub.enclosingType == null) {
            this.logger.log(TreeLogger.Type.INFO, "method '" + stub.name + "' of invisible class is not invokable");
            return "";
        }
        if (stub.enclosingType.startsWith("java") && !stub.enclosingType.startsWith("java.util") || stub.enclosingType.contains("google")) {
            this.logger.log(TreeLogger.Type.INFO, "not emitting code for accessing method " + stub.name + " in class '" + stub.enclosingType + ", either in java.* or GWT related class");
            return "";
        }
        if (stub.enclosingType.contains("[]")) {
            this.logger.log(TreeLogger.Type.INFO, "method '" + stub.name + "' of class '" + stub.enclosingType + "' is not invokable because the class is an array type");
            return "";
        }
        for (i = 0; i < stub.parameterTypes.size(); ++i) {
            String paramType = stub.parameterTypes.get(i);
            if (paramType == null) {
                this.logger.log(TreeLogger.Type.INFO, "method '" + stub.name + "' of class '" + stub.enclosingType + "' is not invokable because one of its argument types is not visible");
                return "";
            }
            if (paramType.startsWith("long") || paramType.contains("java.lang.Long")) {
                this.logger.log(TreeLogger.Type.INFO, "method '" + stub.name + "' of class '" + stub.enclosingType + " has long parameter, prohibited in JSNI");
                return "";
            }
            stub.parameterTypes.set(i, paramType.replace(".class", ""));
        }
        if (stub.returnType == null) {
            this.logger.log(TreeLogger.Type.INFO, "method '" + stub.name + "' of class '" + stub.enclosingType + "' is not invokable because its return type is not visible");
            return "";
        }
        if (stub.returnType.startsWith("long") || stub.returnType.contains("java.lang.Long")) {
            this.logger.log(TreeLogger.Type.INFO, "method '" + stub.name + "' of class '" + stub.enclosingType + " has long return type, prohibited in JSNI");
            return "";
        }
        stub.enclosingType = stub.enclosingType.replace(".class", "");
        stub.returnType = stub.returnType.replace(".class", "");
        if (stub.isMethod) {
            boolean isVoid = stub.returnType.equals("void");
            this.pbn("private native " + (isVoid ? "Object" : stub.returnType) + " m" + stub.methodId + "(");
            if (!stub.isStatic) {
                this.pbn(stub.enclosingType + " obj" + (stub.parameterTypes.size() > 0 ? ", " : ""));
            }
            int i2 = 0;
            for (String paramType : stub.parameterTypes) {
                this.pbn(paramType + " p" + i2 + (i2 < stub.parameterTypes.size() - 1 ? "," : ""));
                ++i2;
            }
            this.pbn(") /*-{");
            if (!isVoid) {
                this.pbn("return ");
            }
            if (stub.isStatic) {
                this.pbn("@" + stub.enclosingType + "::" + stub.name + "(" + stub.jnsi + ")(");
            } else {
                this.pbn("obj.@" + stub.enclosingType + "::" + stub.name + "(" + stub.jnsi + ")(");
            }
            for (i2 = 0; i2 < stub.parameterTypes.size(); ++i2) {
                this.pbn("p" + i2 + (i2 < stub.parameterTypes.size() - 1 ? ", " : ""));
            }
            this.pbn(");");
            if (isVoid) {
                this.pbn("return null;");
            }
            this.pbn("}-*/;");
        } else {
            this.pbn("private static " + stub.returnType + " m" + stub.methodId + "(");
            i = 0;
            for (String paramType : stub.parameterTypes) {
                this.pbn(paramType + " p" + i + (i < stub.parameterTypes.size() - 1 ? "," : ""));
                ++i;
            }
            this.pbn(") {");
            this.pbn("return new " + stub.returnType + "(");
            for (i = 0; i < stub.parameterTypes.size(); ++i) {
                this.pbn("p" + i + (i < stub.parameterTypes.size() - 1 ? ", " : ""));
            }
            this.pbn(")");
            if (!stub.isPublic) {
                this.pbn("{}");
            }
            this.pbn(";");
            this.pbn("}");
        }
        return this.sb.toString();
    }

    private String generateSetterGetterStub(SetterGetterStub stub) {
        this.sb.setLength(0);
        if (stub.enclosingType == null || stub.type == null) {
            this.logger.log(TreeLogger.Type.INFO, "field '" + stub.name + "' in class '" + stub.enclosingType + "' is not accessible as its type '" + stub.type + "' is not public");
            return "";
        }
        if (stub.enclosingType.startsWith("java") || stub.enclosingType.contains("google")) {
            this.logger.log(TreeLogger.Type.INFO, "not emitting code for accessing field " + stub.name + " in class '" + stub.enclosingType + ", either in java.* or GWT related class");
            return "";
        }
        if (stub.type.startsWith("long") || stub.type.contains("java.lang.Long")) {
            this.logger.log(TreeLogger.Type.INFO, "not emitting code for accessing field " + stub.name + " in class '" + stub.enclosingType + " as its of type long which can't be used with JSNI");
            return "";
        }
        stub.enclosingType = stub.enclosingType.replace(".class", "");
        stub.type = stub.type.replace(".class", "");
        this.pbn("private native " + stub.type + " g" + stub.getter + "(" + stub.enclosingType + " obj) /*-{");
        if (stub.isStatic) {
            this.pbn("return @" + stub.enclosingType + "::" + stub.name + ";");
        } else {
            this.pbn("return obj.@" + stub.enclosingType + "::" + stub.name + ";");
        }
        this.pb("}-*/;");
        if (!stub.isFinal) {
            this.pbn("private native void s" + stub.setter + "(" + stub.enclosingType + " obj, " + stub.type + " value)  /*-{");
            if (stub.isStatic) {
                this.pbn("@" + stub.enclosingType + "::" + stub.name + " = value");
            } else {
                this.pbn("obj.@" + stub.enclosingType + "::" + stub.name + " = value;");
            }
            this.pb("}-*/;");
        }
        return this.sb.toString();
    }

    private boolean isVisible(JType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof JClassType) {
            if (type instanceof JArrayType) {
                JType componentType = ((JArrayType)type).getComponentType();
                while (componentType instanceof JArrayType) {
                    componentType = ((JArrayType)componentType).getComponentType();
                }
                if (componentType instanceof JClassType) {
                    return ((JClassType)componentType).isPublic();
                }
            } else {
                return ((JClassType)type).isPublic();
            }
        }
        return true;
    }

    private String createTypeGenerator(JType t) {
        boolean used;
        this.sb.setLength(0);
        int id = this.nextTypeId++;
        this.typeNames2typeIds.put(t.getErasedType().getQualifiedSourceName(), id);
        JClassType c = t.isClass();
        String name = t.getErasedType().getQualifiedSourceName();
        String superClass = null;
        if (c != null && this.isVisible((JType)c.getSuperclass())) {
            superClass = c.getSuperclass().getErasedType().getQualifiedSourceName() + ".class";
        }
        String assignables = null;
        String interfaces = null;
        if (c != null && c.getFlattenedSupertypeHierarchy() != null) {
            assignables = "new HashSet<Class>(Arrays.asList(";
            used = false;
            for (JType i : c.getFlattenedSupertypeHierarchy()) {
                if (!this.isVisible(i) || i.equals(t) || "java.lang.Object".equals(i.getErasedType().getQualifiedSourceName())) continue;
                if (used) {
                    assignables = assignables + ", ";
                }
                assignables = assignables + i.getErasedType().getQualifiedSourceName() + ".class";
                used = true;
            }
            assignables = used ? assignables + "))" : null;
        }
        if (c == null) {
            c = t.isInterface();
        }
        if (c != null && c.getImplementedInterfaces() != null) {
            interfaces = "new HashSet<Class>(Arrays.asList(";
            used = false;
            for (JClassType jClassType : c.getImplementedInterfaces()) {
                if (!this.isVisible((JType)jClassType) || jClassType.equals(t)) continue;
                if (used) {
                    interfaces = interfaces + ", ";
                }
                interfaces = interfaces + jClassType.getErasedType().getQualifiedSourceName() + ".class";
                used = true;
            }
            interfaces = used ? interfaces + "))" : null;
        }
        String varName = "c" + id;
        this.pb("private static Type " + varName + ";");
        this.pb("private static Type " + varName + "() {");
        this.pb("if(" + varName + "!=null) return " + varName + ";");
        this.pb(varName + " = new Type(\"" + name + "\", " + id + ", " + name + ".class, " + superClass + ", " + assignables + ", " + interfaces + ");");
        if (c == null && t.isArray() != null) {
            c = t.isArray();
        }
        if (c != null) {
            Annotation[] annotations;
            JEnumConstant[] enumConstants;
            if (c.isEnum() != null) {
                this.pb(varName + ".isEnum = true;");
            }
            if (c.isArray() != null) {
                this.pb(varName + ".isArray = true;");
                this.pb(varName + ".isStatic = false;");
                this.pb(varName + ".isAbstract = true;");
            } else {
                this.pb(varName + ".isStatic = " + c.isStatic() + ";");
                this.pb(varName + ".isAbstract = " + c.isAbstract() + ";");
            }
            if (c.isMemberType()) {
                this.pb(varName + ".isMemberClass = true;");
            }
            if (c.isInterface() != null) {
                this.pb(varName + ".isInterface = true;");
            }
            if (c.isAnnotation() != null) {
                this.pb(varName + ".isAnnotation = true;");
            }
            if (c.getFields() != null && c.getFields().length > 0) {
                this.pb(varName + ".fields = new Field[] {");
                for (JClassType jClassType : c.getFields()) {
                    int setterGetter;
                    String enclosingType = this.getType((JType)c);
                    String fieldType = this.getType(jClassType.getType());
                    ++this.nextSetterGetterId;
                    String elementType = this.getElementTypes((JField)jClassType);
                    String annotations2 = this.getAnnotations(jClassType.getDeclaredAnnotations());
                    this.pb("    new Field(\"" + jClassType.getName() + "\", " + enclosingType + ", " + fieldType + ", " + jClassType.isFinal() + ", " + jClassType.isDefaultAccess() + ", " + jClassType.isPrivate() + ", " + jClassType.isProtected() + ", " + jClassType.isPublic() + ", " + jClassType.isStatic() + ", " + jClassType.isTransient() + ", " + jClassType.isVolatile() + ", " + setterGetter + ", " + setterGetter + ", " + elementType + ", " + annotations2 + "), ");
                    SetterGetterStub stub = new SetterGetterStub();
                    stub.name = jClassType.getName();
                    stub.enclosingType = enclosingType;
                    stub.type = fieldType;
                    stub.isStatic = jClassType.isStatic();
                    stub.isFinal = jClassType.isFinal();
                    if (enclosingType != null && fieldType != null) {
                        stub.getter = setterGetter;
                        stub.setter = setterGetter;
                    }
                    this.setterGetterStubs.add(stub);
                }
                this.pb("};");
            }
            this.createTypeInvokables(c, varName, "Method", (JAbstractMethod[])c.getMethods());
            if (c.isPublic() && !c.isAbstract() && (c.getEnclosingType() == null || c.isStatic())) {
                this.createTypeInvokables(c, varName, "Constructor", (JAbstractMethod[])c.getConstructors());
            } else {
                this.logger.log(TreeLogger.Type.INFO, c.getName() + " can't be instantiated. Constructors not generated");
            }
            if (c.isArray() != null) {
                this.pb(varName + ".componentType = " + this.getType(c.isArray().getComponentType()) + ";");
            }
            if (c.isEnum() != null && (enumConstants = c.isEnum().getEnumConstants()) != null) {
                this.pb(varName + ".enumConstants = new Object[" + enumConstants.length + "];");
                for (int i = 0; i < enumConstants.length; ++i) {
                    this.pb(varName + ".enumConstants[" + i + "] = " + c.getErasedType().getQualifiedSourceName() + "." + enumConstants[i].getName() + ";");
                }
            }
            if ((annotations = c.getDeclaredAnnotations()) != null && annotations.length > 0) {
                this.pb(varName + ".annotations = " + this.getAnnotations(annotations) + ";");
            }
        } else {
            this.pb(varName + ".isAbstract = true;");
            this.pb(varName + ".isPrimitive = true;");
        }
        this.pb("return " + varName + ";");
        this.pb("}");
        return this.sb.toString();
    }

    private void parameterInitialization() {
        this.p("private static final Parameter[] EMPTY_PARAMETERS = new Parameter[0];");
        for (Map.Entry<String, String> e : this.parameterName2ParameterInstantiation.entrySet()) {
            this.p("private static Parameter " + e.getKey() + ";");
            this.p("private static Parameter " + e.getKey() + "() {");
            this.p("    if (" + e.getKey() + " != null) return " + e.getKey() + ";");
            this.p("    return " + e.getKey() + " = " + e.getValue() + ";");
            this.p("}");
        }
    }

    private void createTypeInvokables(JClassType c, String varName, String methodType, JAbstractMethod[] methodTypes) {
        if (methodTypes != null && methodTypes.length > 0) {
            this.pb(varName + "." + methodType.toLowerCase() + "s = new " + methodType + "[] {");
            for (JAbstractMethod m : methodTypes) {
                MethodStub stub = new MethodStub();
                stub.isPublic = m.isPublic();
                stub.enclosingType = this.getType((JType)c);
                if (m.isMethod() != null) {
                    stub.isMethod = true;
                    stub.returnType = this.getType(m.isMethod().getReturnType());
                    stub.isStatic = m.isMethod().isStatic();
                    stub.isAbstract = m.isMethod().isAbstract();
                    stub.isNative = m.isMethod().isAbstract();
                    stub.isFinal = m.isMethod().isFinal();
                } else {
                    if (m.isPrivate() || m.isDefaultAccess()) {
                        this.logger.log(TreeLogger.Type.INFO, "Skipping non-visible constructor for class " + c.getName());
                        continue;
                    }
                    if (m.getEnclosingType().isFinal() && !m.isPublic()) {
                        this.logger.log(TreeLogger.Type.INFO, "Skipping non-public constructor for final class" + c.getName());
                        continue;
                    }
                    stub.isConstructor = true;
                    stub.returnType = stub.enclosingType;
                }
                stub.jnsi = "";
                ++this.nextInvokableId;
                stub.methodId = stub.methodId;
                stub.name = m.getName();
                this.methodStubs.add(stub);
                this.pbn("    new " + methodType + "(\"" + m.getName() + "\", ");
                this.pbn(stub.enclosingType + ", ");
                this.pbn(stub.returnType + ", ");
                if (m.getParameters() != null && m.getParameters().length > 0) {
                    this.pbn("new Parameter[] {");
                    for (JParameter p : m.getParameters()) {
                        stub.parameterTypes.add(this.getType(p.getType()));
                        stub.jnsi = stub.jnsi + p.getType().getErasedType().getJNISignature();
                        String paramName = (p.getName() + "__" + p.getType().getErasedType().getJNISignature()).replaceAll("[/;\\[\\]]", "_");
                        String paramInstantiation = "new Parameter(\"" + p.getName() + "\", " + this.getType(p.getType()) + ", \"" + p.getType().getJNISignature() + "\")";
                        this.parameterName2ParameterInstantiation.put(paramName, paramInstantiation);
                        this.pbn(paramName + "(), ");
                    }
                    this.pbn("}, ");
                } else {
                    this.pbn("EMPTY_PARAMETERS,");
                }
                this.pb(stub.isAbstract + ", " + stub.isFinal + ", " + stub.isStatic + ", " + m.isDefaultAccess() + ", " + m.isPrivate() + ", " + m.isProtected() + ", " + m.isPublic() + ", " + stub.isNative + ", " + m.isVarArgs() + ", " + stub.isMethod + ", " + stub.isConstructor + ", " + stub.methodId + "," + this.getAnnotations(m.getDeclaredAnnotations()) + "),");
            }
            this.pb("};");
        }
    }

    private String getElementTypes(JField f) {
        StringBuilder b = new StringBuilder();
        JParameterizedType params = f.getType().isParameterized();
        if (params != null) {
            JClassType[] typeArgs = params.getTypeArgs();
            b.append("new Class[] {");
            for (JClassType typeArg : typeArgs) {
                if (typeArg.isWildcard() != null) {
                    b.append("null");
                } else if (!this.isVisible((JType)typeArg)) {
                    b.append("null");
                } else if (typeArg.isClassOrInterface() != null) {
                    b.append(typeArg.isClassOrInterface().getQualifiedSourceName()).append(".class");
                } else if (typeArg.isParameterized() != null) {
                    b.append(typeArg.isParameterized().getQualifiedBinaryName()).append(".class");
                } else {
                    b.append("null");
                }
                b.append(", ");
            }
            b.append("}");
            return b.toString();
        }
        return "null";
    }

    private String getAnnotations(Annotation[] annotations) {
        if (annotations != null && annotations.length > 0) {
            int numValidAnnotations = 0;
            Class[] ignoredAnnotations = new Class[]{Nonnull.class, Nullable.class, Deprecated.class, Retention.class};
            StringBuilder b = new StringBuilder();
            b.append("new java.lang.annotation.Annotation[] {");
            for (Annotation annotation : annotations) {
                Method[] methods;
                Retention retention;
                Class<? extends Annotation> type = annotation.annotationType();
                boolean ignoredType = false;
                for (int i = 0; !ignoredType && i < ignoredAnnotations.length; ++i) {
                    ignoredType = ignoredAnnotations[i].equals(type);
                }
                if (ignoredType || (retention = type.getAnnotation(Retention.class)) == null || retention.value() != RetentionPolicy.RUNTIME) continue;
                ++numValidAnnotations;
                b.append(" new ").append(type.getCanonicalName()).append("() {");
                for (Method method : methods = type.getDeclaredMethods()) {
                    Class<?> returnType = method.getReturnType();
                    b.append(" @Override public");
                    b.append(" ").append(returnType.getCanonicalName());
                    b.append(" ").append(method.getName()).append("() { return");
                    if (returnType.isArray()) {
                        b.append(" new ").append(returnType.getCanonicalName()).append(" {");
                    }
                    Object invokeResult = null;
                    try {
                        invokeResult = method.invoke((Object)annotation, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        this.logger.log(TreeLogger.Type.ERROR, "Error invoking annotation method.");
                    }
                    catch (InvocationTargetException e) {
                        this.logger.log(TreeLogger.Type.ERROR, "Error invoking annotation method.");
                    }
                    if (invokeResult != null) {
                        int i;
                        int length;
                        if (returnType.equals(String[].class)) {
                            for (String s : (String[])invokeResult) {
                                b.append(" \"").append(s).append("\",");
                            }
                        } else if (returnType.equals(String.class)) {
                            b.append(" \"").append((String)invokeResult).append("\"");
                        } else if (returnType.equals(Class[].class)) {
                            for (Class c : (Class[])invokeResult) {
                                b.append(" ").append(c.getCanonicalName()).append(".class,");
                            }
                        } else if (returnType.equals(Class.class)) {
                            b.append(" ").append(((Class)invokeResult).getCanonicalName()).append(".class");
                        } else if (returnType.isArray() && returnType.getComponentType().isEnum()) {
                            String enumTypeName = returnType.getComponentType().getCanonicalName();
                            length = Array.getLength(invokeResult);
                            for (i = 0; i < length; ++i) {
                                Object e = Array.get(invokeResult, i);
                                b.append(" ").append(enumTypeName).append(".").append(e.toString()).append(",");
                            }
                        } else if (returnType.isEnum()) {
                            b.append(" ").append(returnType.getCanonicalName()).append(".").append(invokeResult.toString());
                        } else if (returnType.isArray() && returnType.getComponentType().isPrimitive()) {
                            Class<?> primitiveType = returnType.getComponentType();
                            length = Array.getLength(invokeResult);
                            for (i = 0; i < length; ++i) {
                                Object n = Array.get(invokeResult, i);
                                b.append(" ").append(n.toString());
                                if (primitiveType.equals(Float.TYPE)) {
                                    b.append("f");
                                }
                                b.append(",");
                            }
                        } else if (returnType.isPrimitive()) {
                            b.append(" ").append(invokeResult.toString());
                            if (returnType.equals(Float.TYPE)) {
                                b.append("f");
                            }
                        } else {
                            this.logger.log(TreeLogger.Type.ERROR, "Return type not supported (or not yet implemented).");
                        }
                    }
                    if (returnType.isArray()) {
                        b.append(" }");
                    }
                    b.append("; ");
                    b.append("}");
                }
                b.append(" @Override public Class<? extends java.lang.annotation.Annotation> annotationType() { return ");
                b.append(type.getCanonicalName());
                b.append(".class; }");
                b.append("}, ");
            }
            b.append("}");
            return numValidAnnotations > 0 ? b.toString() : "null";
        }
        return "null";
    }

    private String getType(JType type) {
        if (!this.isVisible(type)) {
            return null;
        }
        return type.getErasedType().getQualifiedSourceName() + ".class";
    }

    private void imports(ClassSourceFileComposerFactory composer) {
        composer.addImport("java.security.AccessControlException");
        composer.addImport("java.util.*");
        composer.addImport("com.badlogic.gwtref.client.*");
    }

    private void invokeM() {
        this.p("public Object invoke(Method m, Object obj, Object[] params) {");
        SwitchedCodeBlock pc = new SwitchedCodeBlock("m.methodId");
        int subN = 0;
        int nDispatch = 0;
        for (MethodStub stub : this.methodStubs) {
            if (stub.enclosingType == null || stub.enclosingType.contains("[]") || stub.returnType == null || stub.unused) continue;
            boolean paramsOk = true;
            for (String paramType : stub.parameterTypes) {
                if (paramType != null) continue;
                paramsOk = false;
                break;
            }
            if (!paramsOk) continue;
            this.sb.setLength(0);
            this.pbn("return m" + stub.methodId + "(");
            this.addParameters(stub);
            this.pbn(");");
            pc.add(stub.methodId, this.sb.toString());
            if (++nDispatch <= 1000) continue;
            pc.print();
            pc = new SwitchedCodeBlock("m.methodId");
            this.p("   return invoke" + ++subN + "(m, obj, params);");
            this.p("}");
            this.p("public Object invoke" + subN + "(Method m, Object obj, Object[] params) {");
            nDispatch = 0;
        }
        pc.print();
        this.p("   throw new IllegalArgumentException(\"Missing method-stub \" + m.methodId + \" for method \" + m.name);");
        this.p("}");
    }

    private void addParameters(MethodStub stub) {
        if (!stub.isStatic && !stub.isConstructor) {
            this.pbn("(" + stub.enclosingType + ")obj" + (stub.parameterTypes.size() > 0 ? "," : ""));
        }
        for (int i = 0; i < stub.parameterTypes.size(); ++i) {
            this.pbn(this.cast(stub.parameterTypes.get(i), "params[" + i + "]") + (i < stub.parameterTypes.size() - 1 ? ", " : ""));
        }
    }

    private String cast(String paramType, String arg) {
        if (paramType.equals("byte") || paramType.equals("short") || paramType.equals("int") || paramType.equals("long") || paramType.equals("float") || paramType.equals("double")) {
            return "((Number)" + arg + ")." + paramType + "Value()";
        }
        if (paramType.equals("boolean")) {
            return "((Boolean)" + arg + ")." + paramType + "Value()";
        }
        if (paramType.equals("char")) {
            return "((Character)" + arg + ")." + paramType + "Value()";
        }
        return "((" + paramType + ")" + arg + ")";
    }

    private void setF() {
        this.p("public void set(Field field, Object obj, Object value) throws IllegalAccessException {");
        SwitchedCodeBlock pc = new SwitchedCodeBlock("field.setter");
        for (SetterGetterStub stub : this.setterGetterStubs) {
            if (stub.enclosingType == null || stub.type == null || stub.isFinal || stub.unused) continue;
            pc.add(stub.setter, "s" + stub.setter + "(" + this.cast(stub.enclosingType, "obj") + ", " + this.cast(stub.type, "value") + "); return;");
        }
        pc.print();
        this.p("   throw new IllegalArgumentException(\"Missing setter-stub \" + field.setter + \" for field \" + field.name);");
        this.p("}");
    }

    private void getF() {
        this.p("public Object get(Field field, Object obj) throws IllegalAccessException {");
        SwitchedCodeBlock pc = new SwitchedCodeBlock("field.getter");
        for (SetterGetterStub stub : this.setterGetterStubs) {
            if (stub.enclosingType == null || stub.type == null || stub.unused) continue;
            pc.add(stub.getter, "return g" + stub.getter + "(" + this.cast(stub.enclosingType, "obj") + ");");
        }
        pc.print();
        this.p("   throw new IllegalArgumentException(\"Missing getter-stub \" + field.getter + \" for field \" + field.name);");
        this.p("}");
    }

    private static boolean isInstantiableWithNewOperator(JClassType t) {
        if (!t.isDefaultInstantiable() || t instanceof JArrayType || t instanceof JEnumType) {
            return false;
        }
        try {
            JConstructor constructor = t.getConstructor(new JType[0]);
            return constructor != null && constructor.isPublic();
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private void setArrayElementT() {
        this.p("public void setArrayElement(Type type, Object obj, int i, Object value) {");
        SwitchedCodeBlock pc = new SwitchedCodeBlock("type.id");
        for (String s : PRIMITIVE_TYPES) {
            if (!this.typeNames2typeIds.containsKey(s + "[]")) continue;
            pc.add(this.typeNames2typeIds.get(s + "[]"), "((" + s + "[])obj)[i] = " + this.cast(s, "value") + "; return;");
        }
        pc.print();
        this.p("\t((Object[])obj)[i] = value;");
        this.p("}");
    }

    private void getArrayElementT() {
        this.p("public Object getArrayElement(Type type, Object obj, int i) {");
        SwitchedCodeBlock pc = new SwitchedCodeBlock("type.id");
        for (String s : PRIMITIVE_TYPES) {
            if (!this.typeNames2typeIds.containsKey(s + "[]")) continue;
            pc.add(this.typeNames2typeIds.get(s + "[]"), "return ((" + s + "[])obj)[i];");
        }
        pc.print();
        this.p("\treturn ((Object[])obj)[i];");
        this.p("}");
    }

    private void getArrayLengthT() {
        this.p("public int getArrayLength(Type type, Object obj) {");
        SwitchedCodeBlock pc = new SwitchedCodeBlock("type.id");
        for (String s : PRIMITIVE_TYPES) {
            if (!this.typeNames2typeIds.containsKey(s + "[]")) continue;
            pc.add(this.typeNames2typeIds.get(s + "[]"), "return ((" + s + "[])obj).length;");
        }
        pc.print();
        this.p("\treturn ((Object[])obj).length;");
        this.p("}");
    }

    private void newArrayC() {
        this.p("public Object newArray (Type t, int size) {");
        this.p("    if (t != null) {");
        SwitchedCodeBlock pc = new SwitchedCodeBlock("t.id");
        for (JType type : this.types) {
            if (type.getQualifiedSourceName().equals("void") || type.getQualifiedSourceName().endsWith("Void")) continue;
            String arrayType = type.getErasedType().getQualifiedSourceName() + "[size]";
            if (arrayType.contains("[]")) {
                arrayType = type.getErasedType().getQualifiedSourceName();
                arrayType = arrayType.replaceFirst("\\[\\]", "[size]") + "[]";
            }
            pc.add(this.typeNames2typeIds.get(type.getQualifiedSourceName()), "return new " + arrayType + ";");
        }
        pc.print();
        this.p("    }");
        this.p("    throw new RuntimeException(\"Couldn't create array\");");
        this.p("}");
    }

    private void forNameC() {
        this.p("public Type forName(String name) {");
        this.p("    int hashCode = name.hashCode();");
        int i = 0;
        SwitchedCodeBlockByString cb = new SwitchedCodeBlockByString("hashCode", "name");
        for (String typeName : this.typeNames2typeIds.keySet()) {
            cb.add(typeName, "return c" + this.typeNames2typeIds.get(typeName) + "();");
            if (++i % 1000 != 0) continue;
            cb.print();
            cb = new SwitchedCodeBlockByString("hashCode", "name");
            this.p("    return forName" + i + "(name, hashCode);");
            this.p("}");
            this.p("private Type forName" + i + "(String name, int hashCode) {");
        }
        cb.print();
        this.p("    return null;");
        this.p("}");
    }

    void p(String line) {
        this.sw.println(line);
        this.source.append(line);
        this.source.append("\n");
    }

    void pn(String line) {
        this.sw.print(line);
        this.source.append(line);
    }

    void pb(String line) {
        this.sb.append(line);
        this.sb.append("\n");
    }

    private void pbn(String line) {
        this.sb.append(line);
    }

    class SwitchedCodeBlockByString {
        private Map<String, List<KeyedCodeBlock>> blocks = new HashMap<String, List<KeyedCodeBlock>>();
        private final String switchStatement;
        private final String expectedValue;

        SwitchedCodeBlockByString(String switchStatement, String expectedValue) {
            this.switchStatement = switchStatement;
            this.expectedValue = expectedValue;
        }

        void add(String key, String codeBlock) {
            KeyedCodeBlock b = new KeyedCodeBlock();
            b.key = key;
            b.codeBlock = codeBlock;
            List<KeyedCodeBlock> blockList = this.blocks.get(key);
            if (blockList == null) {
                blockList = new ArrayList<KeyedCodeBlock>();
                this.blocks.put(key, blockList);
            }
            blockList.add(b);
        }

        void print() {
            if (this.blocks.isEmpty()) {
                return;
            }
            ReflectionCacheSourceCreator.this.p("    switch(" + this.switchStatement + ") {");
            for (String key : this.blocks.keySet()) {
                ReflectionCacheSourceCreator.this.p("    case " + key.hashCode() + ": ");
                for (KeyedCodeBlock block : this.blocks.get(key)) {
                    ReflectionCacheSourceCreator.this.p("        if(" + this.expectedValue + ".equals(\"" + block.key + "\"))" + block.codeBlock);
                    ReflectionCacheSourceCreator.this.p("    break;");
                }
            }
            ReflectionCacheSourceCreator.this.p("}");
        }

        class KeyedCodeBlock {
            String key;
            String codeBlock;

            KeyedCodeBlock() {
            }
        }
    }

    class SwitchedCodeBlock {
        private List<KeyedCodeBlock> blocks = new ArrayList<KeyedCodeBlock>();
        private final String switchStatement;

        SwitchedCodeBlock(String switchStatement) {
            this.switchStatement = switchStatement;
        }

        void add(int key, String codeBlock) {
            KeyedCodeBlock b = new KeyedCodeBlock();
            b.key = key;
            b.codeBlock = codeBlock;
            this.blocks.add(b);
        }

        void print() {
            if (this.blocks.isEmpty()) {
                return;
            }
            ReflectionCacheSourceCreator.this.p("    switch(" + this.switchStatement + ") {");
            for (KeyedCodeBlock b : this.blocks) {
                ReflectionCacheSourceCreator.this.p("    case " + b.key + ": " + b.codeBlock);
            }
            ReflectionCacheSourceCreator.this.p("}");
        }

        class KeyedCodeBlock {
            int key;
            String codeBlock;

            KeyedCodeBlock() {
            }
        }
    }

    class MethodStub {
        String enclosingType;
        String returnType;
        List<String> parameterTypes = new ArrayList<String>();
        String jnsi;
        int methodId;
        boolean isStatic;
        boolean isAbstract;
        boolean isFinal;
        boolean isNative;
        boolean isConstructor;
        boolean isMethod;
        boolean isPublic;
        String name;
        boolean unused;

        MethodStub() {
        }
    }

    class SetterGetterStub {
        int getter;
        int setter;
        String name;
        String enclosingType;
        String type;
        boolean isStatic;
        boolean isFinal;
        boolean unused;

        SetterGetterStub() {
        }
    }
}

