/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.badlogic.gdx.utils.Utf8Decoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InputStreamReader
extends Reader {
    private final InputStream in;
    private final Utf8Decoder utf8Decoder;

    public InputStreamReader(InputStream in) {
        this.in = in;
        this.utf8Decoder = new Utf8Decoder();
    }

    public InputStreamReader(InputStream in, String encoding) throws UnsupportedEncodingException {
        this(in);
    }

    @Override
    public int read(char[] b, int offset, int length) throws IOException {
        byte[] buffer = new byte[length];
        int c = this.in.read(buffer);
        return c <= 0 ? c : this.utf8Decoder.decode(buffer, 0, c, b, offset);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

