/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.BufferFactory;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;

public abstract class CharBuffer
extends Buffer
implements Comparable<CharBuffer>,
CharSequence,
Appendable {
    public static CharBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return BufferFactory.newCharBuffer(capacity);
    }

    public static CharBuffer wrap(char[] array) {
        return CharBuffer.wrap(array, 0, array.length);
    }

    public static CharBuffer wrap(char[] array, int start, int len) {
        int length = array.length;
        if (start < 0 || len < 0 || (long)start + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        CharBuffer buf = BufferFactory.newCharBuffer(array);
        buf.position = start;
        buf.limit = start + len;
        return buf;
    }

    public static CharBuffer wrap(CharSequence chseq) {
        return BufferFactory.newCharBuffer(chseq);
    }

    public static CharBuffer wrap(CharSequence chseq, int start, int end) {
        if (chseq == null) {
            throw new NullPointerException();
        }
        if (start < 0 || end < start || end > chseq.length()) {
            throw new IndexOutOfBoundsException();
        }
        CharBuffer result = BufferFactory.newCharBuffer(chseq);
        result.position = start;
        result.limit = end;
        return result;
    }

    CharBuffer(int capacity) {
        super(capacity);
    }

    public final char[] array() {
        return this.protectedArray();
    }

    public final int arrayOffset() {
        return this.protectedArrayOffset();
    }

    public abstract CharBuffer asReadOnlyBuffer();

    @Override
    public final char charAt(int index) {
        if (index < 0 || index >= this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        return this.get(this.position + index);
    }

    public abstract CharBuffer compact();

    @Override
    public int compareTo(CharBuffer otherBuffer) {
        int thisPos = this.position;
        int otherPos = otherBuffer.position;
        for (int compareRemaining = this.remaining() < otherBuffer.remaining() ? this.remaining() : otherBuffer.remaining(); compareRemaining > 0; --compareRemaining) {
            char otherByte;
            char thisByte = this.get(thisPos);
            if (thisByte != (otherByte = otherBuffer.get(otherPos))) {
                return thisByte < otherByte ? -1 : 1;
            }
            ++thisPos;
            ++otherPos;
        }
        return this.remaining() - otherBuffer.remaining();
    }

    public abstract CharBuffer duplicate();

    public boolean equals(Object other) {
        if (!(other instanceof CharBuffer)) {
            return false;
        }
        CharBuffer otherBuffer = (CharBuffer)other;
        if (this.remaining() != otherBuffer.remaining()) {
            return false;
        }
        int myPosition = this.position;
        int otherPosition = otherBuffer.position;
        boolean equalSoFar = true;
        while (equalSoFar && myPosition < this.limit) {
            equalSoFar = this.get(myPosition++) == otherBuffer.get(otherPosition++);
        }
        return equalSoFar;
    }

    public abstract char get();

    public CharBuffer get(char[] dest) {
        return this.get(dest, 0, dest.length);
    }

    public CharBuffer get(char[] dest, int off, int len) {
        int length = dest.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferUnderflowException();
        }
        for (int i = off; i < off + len; ++i) {
            dest[i] = this.get();
        }
        return this;
    }

    public abstract char get(int var1);

    public final boolean hasArray() {
        return this.protectedHasArray();
    }

    public int hashCode() {
        int myPosition = this.position;
        int hash = 0;
        while (myPosition < this.limit) {
            hash += this.get(myPosition++);
        }
        return hash;
    }

    public abstract boolean isDirect();

    @Override
    public final int length() {
        return this.remaining();
    }

    public abstract ByteOrder order();

    abstract char[] protectedArray();

    abstract int protectedArrayOffset();

    abstract boolean protectedHasArray();

    public abstract CharBuffer put(char var1);

    public final CharBuffer put(char[] src) {
        return this.put(src, 0, src.length);
    }

    public CharBuffer put(char[] src, int off, int len) {
        int length = src.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = off; i < off + len; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public CharBuffer put(CharBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        char[] contents = new char[src.remaining()];
        src.get(contents);
        this.put(contents);
        return this;
    }

    public abstract CharBuffer put(int var1, char var2);

    public final CharBuffer put(String str) {
        return this.put(str, 0, str.length());
    }

    public CharBuffer put(String str, int start, int end) {
        int length = str.length();
        if (start < 0 || end < start || end > length) {
            throw new IndexOutOfBoundsException();
        }
        if (end - start > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = start; i < end; ++i) {
            this.put(str.charAt(i));
        }
        return this;
    }

    public abstract CharBuffer slice();

    @Override
    public abstract CharSequence subSequence(int var1, int var2);

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = this.position; i < this.limit; ++i) {
            sb.append(this.get(i));
        }
        return sb.toString();
    }

    @Override
    public CharBuffer append(char c) {
        return this.put(c);
    }

    @Override
    public CharBuffer append(CharSequence csq) {
        if (csq != null) {
            return this.put(csq.toString());
        }
        return this.put("null");
    }

    @Override
    public CharBuffer append(CharSequence csq, int start, int end) {
        CharSequence cs;
        if (csq == null) {
            csq = "null";
        }
        if ((cs = csq.subSequence(start, end)).length() > 0) {
            return this.put(cs.toString());
        }
        return this;
    }

    public int read(CharBuffer target) throws IOException {
        if (target == this) {
            throw new IllegalArgumentException();
        }
        if (this.remaining() == 0) {
            return target.remaining() == 0 ? 0 : -1;
        }
        int result = Math.min(target.remaining(), this.remaining());
        char[] chars = new char[result];
        this.get(chars);
        target.put(chars);
        return result;
    }
}

