/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.ArrayBufferView;
import com.google.gwt.typedarrays.shared.Float32Array;
import com.google.gwt.typedarrays.shared.TypedArrays;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.FloatBuffer;
import java.nio.HasArrayBufferView;
import java.nio.ReadOnlyBufferException;

final class DirectReadOnlyFloatBufferAdapter
extends FloatBuffer
implements HasArrayBufferView {
    private final DirectByteBuffer byteBuffer;
    private final Float32Array floatArray;

    static FloatBuffer wrap(DirectByteBuffer byteBuffer) {
        return new DirectReadOnlyFloatBufferAdapter((DirectByteBuffer)byteBuffer.slice());
    }

    DirectReadOnlyFloatBufferAdapter(DirectByteBuffer byteBuffer) {
        super(byteBuffer.capacity() >> 2);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
        this.floatArray = TypedArrays.createFloat32Array((ArrayBuffer)byteBuffer.byteArray.buffer(), (int)byteBuffer.byteArray.byteOffset(), (int)this.capacity);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        DirectReadOnlyFloatBufferAdapter buf = new DirectReadOnlyFloatBufferAdapter(this.byteBuffer);
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public FloatBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer duplicate() {
        DirectReadOnlyFloatBufferAdapter buf = new DirectReadOnlyFloatBufferAdapter((DirectByteBuffer)this.byteBuffer.duplicate());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public float get() {
        return this.floatArray.get(this.position++);
    }

    @Override
    public float get(int index) {
        return this.floatArray.get(index);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    @Override
    float[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean protectedHasArray() {
        return false;
    }

    @Override
    public FloatBuffer put(float c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer put(int index, float c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public FloatBuffer slice() {
        this.byteBuffer.limit(this.limit << 2);
        this.byteBuffer.position(this.position << 2);
        DirectReadOnlyFloatBufferAdapter result = new DirectReadOnlyFloatBufferAdapter((DirectByteBuffer)this.byteBuffer.slice());
        this.byteBuffer.clear();
        return result;
    }

    @Override
    public ArrayBufferView getTypedArray() {
        return this.floatArray;
    }

    @Override
    public int getElementSize() {
        return 4;
    }
}

