/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.google.gwt.corp.compatibility.Numbers;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.DirectReadOnlyByteBuffer;
import java.nio.DirectReadWriteFloatBufferAdapter;
import java.nio.DirectReadWriteIntBufferAdapter;
import java.nio.DirectReadWriteShortBufferAdapter;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;

public final class DirectReadWriteByteBuffer
extends DirectByteBuffer {
    static DirectReadWriteByteBuffer copy(DirectByteBuffer other, int markOfOther) {
        DirectReadWriteByteBuffer buf = new DirectReadWriteByteBuffer(other.byteArray.buffer(), other.capacity(), other.byteArray.byteOffset());
        buf.limit = other.limit();
        buf.position = other.position();
        buf.mark = markOfOther;
        buf.order(other.order());
        return buf;
    }

    DirectReadWriteByteBuffer(ArrayBuffer backingArray) {
        super(backingArray);
    }

    public DirectReadWriteByteBuffer(int capacity) {
        super(capacity);
    }

    DirectReadWriteByteBuffer(ArrayBuffer backingArray, int capacity, int arrayOffset) {
        super(backingArray, capacity, arrayOffset);
    }

    @Override
    public FloatBuffer asFloatBuffer() {
        return DirectReadWriteFloatBufferAdapter.wrap(this);
    }

    @Override
    public IntBuffer asIntBuffer() {
        return this.order() == ByteOrder.nativeOrder() ? DirectReadWriteIntBufferAdapter.wrap(this) : super.asIntBuffer();
    }

    @Override
    public ShortBuffer asShortBuffer() {
        return this.order() == ByteOrder.nativeOrder() ? DirectReadWriteShortBufferAdapter.wrap(this) : super.asShortBuffer();
    }

    @Override
    public ByteBuffer asReadOnlyBuffer() {
        return DirectReadOnlyByteBuffer.copy(this, this.mark);
    }

    @Override
    public ByteBuffer compact() {
        int rem = this.remaining();
        for (int i = 0; i < rem; ++i) {
            this.byteArray.set(i, (int)this.byteArray.get(this.position + i));
        }
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public ByteBuffer duplicate() {
        return DirectReadWriteByteBuffer.copy(this, this.mark);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    protected byte[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean protectedHasArray() {
        return true;
    }

    @Override
    public ByteBuffer put(byte b) {
        this.byteArray.set(this.position++, (int)b);
        return this;
    }

    @Override
    public ByteBuffer put(int index, byte b) {
        this.byteArray.set(index, (int)b);
        return this;
    }

    @Override
    public ByteBuffer put(byte[] src, int off, int len) {
        if (off < 0 || len < 0 || (long)off + (long)len > (long)src.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        for (int i = 0; i < len; ++i) {
            this.byteArray.set(i + this.position, (int)src[off + i]);
        }
        this.position += len;
        return this;
    }

    @Override
    public ByteBuffer putDouble(double value) {
        return this.putLong(Numbers.doubleToRawLongBits(value));
    }

    @Override
    public ByteBuffer putDouble(int index, double value) {
        return this.putLong(index, Numbers.doubleToRawLongBits(value));
    }

    @Override
    public ByteBuffer putFloat(float value) {
        return this.putInt(Numbers.floatToIntBits(value));
    }

    @Override
    public ByteBuffer putFloat(int index, float value) {
        return this.putInt(index, Numbers.floatToIntBits(value));
    }

    @Override
    public ByteBuffer putInt(int value) {
        int newPosition = this.position + 4;
        this.store(this.position, value);
        this.position = newPosition;
        return this;
    }

    @Override
    public ByteBuffer putInt(int index, int value) {
        this.store(index, value);
        return this;
    }

    @Override
    public ByteBuffer putLong(int index, long value) {
        this.store(index, value);
        return this;
    }

    @Override
    public ByteBuffer putLong(long value) {
        int newPosition = this.position + 8;
        this.store(this.position, value);
        this.position = newPosition;
        return this;
    }

    @Override
    public ByteBuffer putShort(int index, short value) {
        this.store(index, value);
        return this;
    }

    @Override
    public ByteBuffer putShort(short value) {
        int newPosition = this.position + 2;
        this.store(this.position, value);
        this.position = newPosition;
        return this;
    }

    @Override
    public ByteBuffer slice() {
        DirectReadWriteByteBuffer slice = new DirectReadWriteByteBuffer(this.byteArray.buffer(), this.remaining(), this.byteArray.byteOffset() + this.position);
        slice.order = this.order;
        return slice;
    }
}

