/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.ArrayBufferView;
import com.google.gwt.typedarrays.shared.Float32Array;
import com.google.gwt.typedarrays.shared.TypedArrays;
import java.nio.ByteOrder;
import java.nio.DirectReadOnlyFloatBufferAdapter;
import java.nio.DirectReadWriteByteBuffer;
import java.nio.FloatBuffer;
import java.nio.HasArrayBufferView;

final class DirectReadWriteFloatBufferAdapter
extends FloatBuffer
implements HasArrayBufferView {
    private final DirectReadWriteByteBuffer byteBuffer;
    private final Float32Array floatArray;

    static FloatBuffer wrap(DirectReadWriteByteBuffer byteBuffer) {
        return new DirectReadWriteFloatBufferAdapter((DirectReadWriteByteBuffer)byteBuffer.slice());
    }

    DirectReadWriteFloatBufferAdapter(DirectReadWriteByteBuffer byteBuffer) {
        super(byteBuffer.capacity() >> 2);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
        this.floatArray = TypedArrays.createFloat32Array((ArrayBuffer)byteBuffer.byteArray.buffer(), (int)byteBuffer.byteArray.byteOffset(), (int)this.capacity);
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        DirectReadOnlyFloatBufferAdapter buf = new DirectReadOnlyFloatBufferAdapter(this.byteBuffer);
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public FloatBuffer compact() {
        this.byteBuffer.limit(this.limit << 2);
        this.byteBuffer.position(this.position << 2);
        this.byteBuffer.compact();
        this.byteBuffer.clear();
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public FloatBuffer duplicate() {
        DirectReadWriteFloatBufferAdapter buf = new DirectReadWriteFloatBufferAdapter((DirectReadWriteByteBuffer)this.byteBuffer.duplicate());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public float get() {
        return this.floatArray.get(this.position++);
    }

    @Override
    public float get(int index) {
        return this.floatArray.get(index);
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    @Override
    protected float[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean protectedHasArray() {
        return false;
    }

    @Override
    public FloatBuffer put(float c) {
        this.floatArray.set(this.position++, c);
        return this;
    }

    @Override
    public FloatBuffer put(int index, float c) {
        this.floatArray.set(index, c);
        return this;
    }

    @Override
    public FloatBuffer slice() {
        this.byteBuffer.limit(this.limit << 2);
        this.byteBuffer.position(this.position << 2);
        DirectReadWriteFloatBufferAdapter result = new DirectReadWriteFloatBufferAdapter((DirectReadWriteByteBuffer)this.byteBuffer.slice());
        this.byteBuffer.clear();
        return result;
    }

    @Override
    public ArrayBufferView getTypedArray() {
        return this.floatArray;
    }

    @Override
    public int getElementSize() {
        return 4;
    }
}

