/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferFactory;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;

public abstract class DoubleBuffer
extends Buffer
implements Comparable<DoubleBuffer> {
    public static DoubleBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        return BufferFactory.newDoubleBuffer(capacity);
    }

    public static DoubleBuffer wrap(double[] array) {
        return DoubleBuffer.wrap(array, 0, array.length);
    }

    public static DoubleBuffer wrap(double[] array, int start, int len) {
        int length = array.length;
        if (start < 0 || len < 0 || (long)start + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        DoubleBuffer buf = BufferFactory.newDoubleBuffer(array);
        buf.position = start;
        buf.limit = start + len;
        return buf;
    }

    DoubleBuffer(int capacity) {
        super(capacity);
    }

    public final double[] array() {
        return this.protectedArray();
    }

    public final int arrayOffset() {
        return this.protectedArrayOffset();
    }

    public abstract DoubleBuffer asReadOnlyBuffer();

    public abstract DoubleBuffer compact();

    @Override
    public int compareTo(DoubleBuffer otherBuffer) {
        int thisPos = this.position;
        int otherPos = otherBuffer.position;
        for (int compareRemaining = this.remaining() < otherBuffer.remaining() ? this.remaining() : otherBuffer.remaining(); compareRemaining > 0; --compareRemaining) {
            double otherDouble;
            double thisDouble = this.get(thisPos);
            if (thisDouble != (otherDouble = otherBuffer.get(otherPos)) && (thisDouble == thisDouble || otherDouble == otherDouble)) {
                return thisDouble < otherDouble ? -1 : 1;
            }
            ++thisPos;
            ++otherPos;
        }
        return this.remaining() - otherBuffer.remaining();
    }

    public abstract DoubleBuffer duplicate();

    public boolean equals(Object other) {
        if (!(other instanceof DoubleBuffer)) {
            return false;
        }
        DoubleBuffer otherBuffer = (DoubleBuffer)other;
        if (this.remaining() != otherBuffer.remaining()) {
            return false;
        }
        int myPosition = this.position;
        int otherPosition = otherBuffer.position;
        boolean equalSoFar = true;
        while (equalSoFar && myPosition < this.limit) {
            equalSoFar = this.get(myPosition++) == otherBuffer.get(otherPosition++);
        }
        return equalSoFar;
    }

    public abstract double get();

    public DoubleBuffer get(double[] dest) {
        return this.get(dest, 0, dest.length);
    }

    public DoubleBuffer get(double[] dest, int off, int len) {
        int length = dest.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferUnderflowException();
        }
        for (int i = off; i < off + len; ++i) {
            dest[i] = this.get();
        }
        return this;
    }

    public abstract double get(int var1);

    public final boolean hasArray() {
        return this.protectedHasArray();
    }

    public abstract boolean isDirect();

    public abstract ByteOrder order();

    abstract double[] protectedArray();

    abstract int protectedArrayOffset();

    abstract boolean protectedHasArray();

    public abstract DoubleBuffer put(double var1);

    public final DoubleBuffer put(double[] src) {
        return this.put(src, 0, src.length);
    }

    public DoubleBuffer put(double[] src, int off, int len) {
        int length = src.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = off; i < off + len; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public DoubleBuffer put(DoubleBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        double[] doubles = new double[src.remaining()];
        src.get(doubles);
        this.put(doubles);
        return this;
    }

    public abstract DoubleBuffer put(int var1, double var2);

    public abstract DoubleBuffer slice();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(", status: capacity=");
        sb.append(this.capacity());
        sb.append(" position=");
        sb.append(this.position());
        sb.append(" limit=");
        sb.append(this.limit());
        return sb.toString();
    }
}

