/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ReadOnlyBufferException;

final class FloatToByteBufferAdapter
extends FloatBuffer {
    private final ByteBuffer byteBuffer;

    static FloatBuffer wrap(ByteBuffer byteBuffer) {
        return new FloatToByteBufferAdapter(byteBuffer.slice());
    }

    FloatToByteBufferAdapter(ByteBuffer byteBuffer) {
        super(byteBuffer.capacity() >> 2);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
    }

    @Override
    public FloatBuffer asReadOnlyBuffer() {
        FloatToByteBufferAdapter buf = new FloatToByteBufferAdapter(this.byteBuffer.asReadOnlyBuffer());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public FloatBuffer compact() {
        if (this.byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.byteBuffer.limit(this.limit << 2);
        this.byteBuffer.position(this.position << 2);
        this.byteBuffer.compact();
        this.byteBuffer.clear();
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public FloatBuffer duplicate() {
        FloatToByteBufferAdapter buf = new FloatToByteBufferAdapter(this.byteBuffer.duplicate());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public float get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.byteBuffer.getFloat(this.position++ << 2);
    }

    @Override
    public float get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.byteBuffer.getFloat(index << 2);
    }

    @Override
    public boolean isDirect() {
        return this.byteBuffer.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.byteBuffer.isReadOnly();
    }

    @Override
    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    @Override
    protected float[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean protectedHasArray() {
        return false;
    }

    @Override
    public FloatBuffer put(float c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.byteBuffer.putFloat(this.position++ << 2, c);
        return this;
    }

    @Override
    public FloatBuffer put(int index, float c) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.byteBuffer.putFloat(index << 2, c);
        return this;
    }

    @Override
    public FloatBuffer slice() {
        this.byteBuffer.limit(this.limit << 2);
        this.byteBuffer.position(this.position << 2);
        FloatToByteBufferAdapter result = new FloatToByteBufferAdapter(this.byteBuffer.slice());
        this.byteBuffer.clear();
        return result;
    }
}

