/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferWrapper;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ReadOnlyBufferException;

final class IntToByteBufferAdapter
extends IntBuffer
implements ByteBufferWrapper {
    private final ByteBuffer byteBuffer;

    static IntBuffer wrap(ByteBuffer byteBuffer) {
        return new IntToByteBufferAdapter(byteBuffer.slice());
    }

    IntToByteBufferAdapter(ByteBuffer byteBuffer) {
        super(byteBuffer.capacity() >> 2);
        this.byteBuffer = byteBuffer;
        this.byteBuffer.clear();
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        IntToByteBufferAdapter buf = new IntToByteBufferAdapter(this.byteBuffer.asReadOnlyBuffer());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public IntBuffer compact() {
        if (this.byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        this.byteBuffer.limit(this.limit << 2);
        this.byteBuffer.position(this.position << 2);
        this.byteBuffer.compact();
        this.byteBuffer.clear();
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public IntBuffer duplicate() {
        IntToByteBufferAdapter buf = new IntToByteBufferAdapter(this.byteBuffer.duplicate());
        buf.limit = this.limit;
        buf.position = this.position;
        buf.mark = this.mark;
        return buf;
    }

    @Override
    public int get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.byteBuffer.getInt(this.position++ << 2);
    }

    @Override
    public int get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.byteBuffer.getInt(index << 2);
    }

    @Override
    public boolean isDirect() {
        return this.byteBuffer.isDirect();
    }

    @Override
    public boolean isReadOnly() {
        return this.byteBuffer.isReadOnly();
    }

    @Override
    public ByteOrder order() {
        return this.byteBuffer.order();
    }

    @Override
    protected int[] protectedArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int protectedArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean protectedHasArray() {
        return false;
    }

    @Override
    public IntBuffer put(int c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.byteBuffer.putInt(this.position++ << 2, c);
        return this;
    }

    @Override
    public IntBuffer put(int index, int c) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.byteBuffer.putInt(index << 2, c);
        return this;
    }

    @Override
    public IntBuffer slice() {
        this.byteBuffer.limit(this.limit << 2);
        this.byteBuffer.position(this.position << 2);
        IntToByteBufferAdapter result = new IntToByteBufferAdapter(this.byteBuffer.slice());
        this.byteBuffer.clear();
        return result;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }
}

