/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.IntArrayBuffer;
import java.nio.IntBuffer;
import java.nio.ReadOnlyIntArrayBuffer;

final class ReadWriteIntArrayBuffer
extends IntArrayBuffer {
    static ReadWriteIntArrayBuffer copy(IntArrayBuffer other, int markOfOther) {
        ReadWriteIntArrayBuffer buf = new ReadWriteIntArrayBuffer(other.capacity(), other.backingArray, other.offset);
        buf.limit = other.limit();
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    ReadWriteIntArrayBuffer(int[] array) {
        super(array);
    }

    ReadWriteIntArrayBuffer(int capacity) {
        super(capacity);
    }

    ReadWriteIntArrayBuffer(int capacity, int[] backingArray, int arrayOffset) {
        super(capacity, backingArray, arrayOffset);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        return ReadOnlyIntArrayBuffer.copy(this, this.mark);
    }

    @Override
    public IntBuffer compact() {
        System.arraycopy(this.backingArray, this.position + this.offset, this.backingArray, this.offset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public IntBuffer duplicate() {
        return ReadWriteIntArrayBuffer.copy(this, this.mark);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    protected int[] protectedArray() {
        return this.backingArray;
    }

    @Override
    protected int protectedArrayOffset() {
        return this.offset;
    }

    @Override
    protected boolean protectedHasArray() {
        return true;
    }

    @Override
    public IntBuffer put(int c) {
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.offset + this.position++] = c;
        return this;
    }

    @Override
    public IntBuffer put(int index, int c) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        this.backingArray[this.offset + index] = c;
        return this;
    }

    @Override
    public IntBuffer put(int[] src, int off, int len) {
        int length = src.length;
        if (off < 0 || len < 0 || (long)off + (long)len > (long)length) {
            throw new IndexOutOfBoundsException();
        }
        if (len > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy(src, off, this.backingArray, this.offset + this.position, len);
        this.position += len;
        return this;
    }

    @Override
    public IntBuffer slice() {
        return new ReadWriteIntArrayBuffer(this.remaining(), this.backingArray, this.offset + this.position);
    }
}

