/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.headless.mock.graphics;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.graphics.Cursor;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.glutils.GLVersion;

public class MockGraphics
implements Graphics {
    long frameId = -1L;
    float deltaTime = 0.0f;
    long frameStart = 0L;
    int frames = 0;
    int fps;
    long lastTime = System.nanoTime();
    GLVersion glVersion = new GLVersion(Application.ApplicationType.HeadlessDesktop, "", "", "");

    public boolean isGL30Available() {
        return false;
    }

    public GL20 getGL20() {
        return null;
    }

    public void setGL20(GL20 gl20) {
    }

    public GL30 getGL30() {
        return null;
    }

    public void setGL30(GL30 gl30) {
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public int getBackBufferWidth() {
        return 0;
    }

    public int getBackBufferHeight() {
        return 0;
    }

    public long getFrameId() {
        return this.frameId;
    }

    public float getDeltaTime() {
        return this.deltaTime;
    }

    public float getRawDeltaTime() {
        return this.deltaTime;
    }

    public int getFramesPerSecond() {
        return this.fps;
    }

    public Graphics.GraphicsType getType() {
        return Graphics.GraphicsType.Mock;
    }

    public GLVersion getGLVersion() {
        return this.glVersion;
    }

    public float getPpiX() {
        return 0.0f;
    }

    public float getPpiY() {
        return 0.0f;
    }

    public float getPpcX() {
        return 0.0f;
    }

    public float getPpcY() {
        return 0.0f;
    }

    public float getDensity() {
        return 0.0f;
    }

    public boolean supportsDisplayModeChange() {
        return false;
    }

    public Graphics.DisplayMode[] getDisplayModes() {
        return new Graphics.DisplayMode[0];
    }

    public Graphics.DisplayMode getDisplayMode() {
        return null;
    }

    public int getSafeInsetLeft() {
        return 0;
    }

    public int getSafeInsetTop() {
        return 0;
    }

    public int getSafeInsetBottom() {
        return 0;
    }

    public int getSafeInsetRight() {
        return 0;
    }

    public boolean setFullscreenMode(Graphics.DisplayMode displayMode) {
        return false;
    }

    public boolean setWindowedMode(int width, int height) {
        return false;
    }

    public void setTitle(String title) {
    }

    public void setVSync(boolean vsync) {
    }

    public Graphics.BufferFormat getBufferFormat() {
        return null;
    }

    public boolean supportsExtension(String extension) {
        return false;
    }

    public void setContinuousRendering(boolean isContinuous) {
    }

    public boolean isContinuousRendering() {
        return false;
    }

    public void requestRendering() {
    }

    public boolean isFullscreen() {
        return false;
    }

    public void updateTime() {
        long time = System.nanoTime();
        this.deltaTime = (float)(time - this.lastTime) / 1.0E9f;
        this.lastTime = time;
        if (time - this.frameStart >= 1000000000L) {
            this.fps = this.frames;
            this.frames = 0;
            this.frameStart = time;
        }
        ++this.frames;
    }

    public void incrementFrameId() {
        ++this.frameId;
    }

    public Cursor newCursor(Pixmap pixmap, int xHotspot, int yHotspot) {
        return null;
    }

    public void setCursor(Cursor cursor) {
    }

    public void setSystemCursor(Cursor.SystemCursor systemCursor) {
    }

    public Graphics.Monitor getPrimaryMonitor() {
        return null;
    }

    public Graphics.Monitor getMonitor() {
        return null;
    }

    public Graphics.Monitor[] getMonitors() {
        return null;
    }

    public Graphics.DisplayMode[] getDisplayModes(Graphics.Monitor monitor) {
        return null;
    }

    public Graphics.DisplayMode getDisplayMode(Graphics.Monitor monitor) {
        return null;
    }

    public void setUndecorated(boolean undecorated) {
    }

    public void setResizable(boolean resizable) {
    }
}

