/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl.audio;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.lwjgl.audio.OpenALLwjglAudio;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import org.lwjgl.openal.AL10;

public class OpenALSound
implements Sound {
    private int bufferID = -1;
    private final OpenALLwjglAudio audio;
    private float duration;
    private int sampleRate;
    private int channels;

    public OpenALSound(OpenALLwjglAudio audio) {
        this.audio = audio;
    }

    void setup(byte[] pcm, int channels, int sampleRate) {
        this.channels = channels;
        this.sampleRate = sampleRate;
        int bytes = pcm.length - pcm.length % (channels > 1 ? 4 : 2);
        int samples = bytes / (2 * channels);
        this.duration = (float)samples / (float)sampleRate;
        ByteBuffer buffer = ByteBuffer.allocateDirect(bytes);
        buffer.order(ByteOrder.nativeOrder());
        buffer.put(pcm, 0, bytes);
        ((Buffer)buffer).flip();
        if (this.bufferID == -1) {
            this.bufferID = AL10.alGenBuffers();
            AL10.alBufferData((int)this.bufferID, (int)(channels > 1 ? 4355 : 4353), (ShortBuffer)buffer.asShortBuffer(), (int)sampleRate);
        }
    }

    public long play() {
        return this.play(1.0f);
    }

    public long play(float volume) {
        if (this.audio.noDevice) {
            return 0L;
        }
        int sourceID = this.audio.obtainSource(false);
        if (sourceID == -1) {
            this.audio.retain(this, true);
            sourceID = this.audio.obtainSource(false);
        } else {
            this.audio.retain(this, false);
        }
        if (sourceID == -1) {
            return -1L;
        }
        long soundId = this.audio.getSoundId(sourceID);
        AL10.alSourcei((int)sourceID, (int)4105, (int)this.bufferID);
        AL10.alSourcei((int)sourceID, (int)4103, (int)0);
        AL10.alSourcef((int)sourceID, (int)4106, (float)volume);
        AL10.alSourcePlay((int)sourceID);
        return soundId;
    }

    public long loop() {
        return this.loop(1.0f);
    }

    public long loop(float volume) {
        if (this.audio.noDevice) {
            return 0L;
        }
        int sourceID = this.audio.obtainSource(false);
        if (sourceID == -1) {
            return -1L;
        }
        long soundId = this.audio.getSoundId(sourceID);
        AL10.alSourcei((int)sourceID, (int)4105, (int)this.bufferID);
        AL10.alSourcei((int)sourceID, (int)4103, (int)1);
        AL10.alSourcef((int)sourceID, (int)4106, (float)volume);
        AL10.alSourcePlay((int)sourceID);
        return soundId;
    }

    public void stop() {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.stopSourcesWithBuffer(this.bufferID);
    }

    public void dispose() {
        if (this.audio.noDevice) {
            return;
        }
        if (this.bufferID == -1) {
            return;
        }
        this.audio.freeBuffer(this.bufferID);
        AL10.alDeleteBuffers((int)this.bufferID);
        this.bufferID = -1;
        this.audio.forget(this);
    }

    public void stop(long soundId) {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.stopSound(soundId);
    }

    public void pause() {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.pauseSourcesWithBuffer(this.bufferID);
    }

    public void pause(long soundId) {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.pauseSound(soundId);
    }

    public void resume() {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.resumeSourcesWithBuffer(this.bufferID);
    }

    public void resume(long soundId) {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.resumeSound(soundId);
    }

    public void setPitch(long soundId, float pitch) {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.setSoundPitch(soundId, pitch);
    }

    public void setVolume(long soundId, float volume) {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.setSoundGain(soundId, volume);
    }

    public void setLooping(long soundId, boolean looping) {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.setSoundLooping(soundId, looping);
    }

    public void setPan(long soundId, float pan, float volume) {
        if (this.audio.noDevice) {
            return;
        }
        this.audio.setSoundPan(soundId, pan, volume);
    }

    public long play(float volume, float pitch, float pan) {
        long id = this.play();
        this.setPitch(id, pitch);
        this.setPan(id, pan, volume);
        return id;
    }

    public long loop(float volume, float pitch, float pan) {
        long id = this.loop();
        this.setPitch(id, pitch);
        this.setPan(id, pan, volume);
        return id;
    }

    public float duration() {
        return this.duration;
    }

    public int getRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }
}

