/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.ApplicationLogger;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.lwjgl.DefaultLwjglInput;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationBase;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationLogger;
import com.badlogic.gdx.backends.lwjgl.LwjglClipboard;
import com.badlogic.gdx.backends.lwjgl.LwjglFiles;
import com.badlogic.gdx.backends.lwjgl.LwjglGraphics;
import com.badlogic.gdx.backends.lwjgl.LwjglInput;
import com.badlogic.gdx.backends.lwjgl.LwjglNativesLoader;
import com.badlogic.gdx.backends.lwjgl.LwjglNet;
import com.badlogic.gdx.backends.lwjgl.LwjglPreferences;
import com.badlogic.gdx.backends.lwjgl.audio.LwjglAudio;
import com.badlogic.gdx.backends.lwjgl.audio.OpenALLwjglAudio;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.geom.AffineTransform;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.Display;

public class LwjglCanvas
implements LwjglApplicationBase {
    static boolean isWindows = System.getProperty("os.name").contains("Windows");
    LwjglGraphics graphics;
    LwjglAudio audio;
    LwjglFiles files;
    LwjglInput input;
    LwjglNet net;
    ApplicationListener listener;
    Canvas canvas;
    final Array runnables = new Array();
    final Array executedRunnables = new Array();
    final Array<LifecycleListener> lifecycleListeners = new Array();
    boolean running = true;
    int logLevel = 2;
    ApplicationLogger applicationLogger;
    Cursor cursor;
    float scaleX;
    float scaleY;
    boolean postedRunnableStacktraces;
    final Map<String, Preferences> preferences = new HashMap<String, Preferences>();

    public LwjglCanvas(ApplicationListener listener) {
        LwjglApplicationConfiguration config = new LwjglApplicationConfiguration();
        this.initialize(listener, config);
    }

    public LwjglCanvas(ApplicationListener listener, LwjglApplicationConfiguration config) {
        this.initialize(listener, config);
    }

    private void initialize(ApplicationListener listener, LwjglApplicationConfiguration config) {
        LwjglNativesLoader.load();
        this.setApplicationLogger(new LwjglApplicationLogger());
        this.canvas = new Canvas(){
            private final Dimension minSize = new Dimension(1, 1);

            @Override
            public final void addNotify() {
                super.addNotify();
                AffineTransform transform = this.getGraphicsConfiguration().getDefaultTransform();
                LwjglCanvas.this.scaleX = (float)transform.getScaleX();
                LwjglCanvas.this.scaleY = (float)transform.getScaleY();
                if (SharedLibraryLoader.isMac) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LwjglCanvas.this.create();
                        }
                    });
                } else {
                    LwjglCanvas.this.create();
                }
            }

            @Override
            public final void removeNotify() {
                LwjglCanvas.this.stop();
                super.removeNotify();
            }

            @Override
            public Dimension getMinimumSize() {
                return this.minSize;
            }

            @Override
            public int getWidth() {
                return Math.round((float)super.getWidth() * LwjglCanvas.this.scaleX);
            }

            @Override
            public int getHeight() {
                return Math.round((float)super.getHeight() * LwjglCanvas.this.scaleY);
            }
        };
        this.canvas.setSize(1, 1);
        this.canvas.setIgnoreRepaint(true);
        this.graphics = new LwjglGraphics(this.canvas, config){

            @Override
            public void setTitle(String title) {
                super.setTitle(title);
                LwjglCanvas.this.setTitle(title);
            }

            public boolean setWindowedMode(int width, int height, boolean fullscreen) {
                if (!super.setWindowedMode(width, height)) {
                    return false;
                }
                if (!fullscreen) {
                    LwjglCanvas.this.setDisplayMode(width, height);
                }
                return true;
            }

            @Override
            public boolean setFullscreenMode(Graphics.DisplayMode displayMode) {
                if (!super.setFullscreenMode(displayMode)) {
                    return false;
                }
                LwjglCanvas.this.setDisplayMode(displayMode.width, displayMode.height);
                return true;
            }
        };
        this.graphics.setVSync(config.vSyncEnabled);
        if (!LwjglApplicationConfiguration.disableAudio) {
            this.audio = this.createAudio(config);
        }
        this.files = new LwjglFiles();
        this.input = this.createInput(config);
        this.net = new LwjglNet(config);
        this.listener = listener;
        Gdx.app = this;
        Gdx.graphics = this.graphics;
        Gdx.audio = this.audio;
        Gdx.files = this.files;
        Gdx.input = this.input;
        Gdx.net = this.net;
    }

    protected void setDisplayMode(int width, int height) {
    }

    protected void setTitle(String title) {
    }

    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public Audio getAudio() {
        return this.audio;
    }

    public Files getFiles() {
        return this.files;
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public Input getInput() {
        return this.input;
    }

    public Net getNet() {
        return this.net;
    }

    public Application.ApplicationType getType() {
        return Application.ApplicationType.Desktop;
    }

    public int getVersion() {
        return 0;
    }

    void create() {
        try {
            this.graphics.setupDisplay();
            this.listener.create();
            this.listener.resize(Math.max(1, this.graphics.getWidth()), Math.max(1, this.graphics.getHeight()));
            this.start();
        }
        catch (Exception ex) {
            try {
                Display.destroy();
                if (this.audio != null) {
                    this.audio.dispose();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.stopped();
            this.exception(ex);
            return;
        }
        EventQueue.invokeLater(new Runnable(){
            int lastWidth;
            int lastHeight;
            {
                this.lastWidth = Math.max(1, LwjglCanvas.this.graphics.getWidth());
                this.lastHeight = Math.max(1, LwjglCanvas.this.graphics.getHeight());
            }

            @Override
            public void run() {
                if (!LwjglCanvas.this.running || Display.isCloseRequested()) {
                    LwjglCanvas.this.running = false;
                    LwjglCanvas.this.stopped();
                    return;
                }
                try {
                    Display.processMessages();
                    if (LwjglCanvas.this.cursor != null || !isWindows) {
                        LwjglCanvas.this.canvas.setCursor(LwjglCanvas.this.cursor);
                    }
                    boolean shouldRender = this.checkResize();
                    if (LwjglCanvas.this.executeRunnables()) {
                        shouldRender = true;
                    }
                    if (!LwjglCanvas.this.running) {
                        return;
                    }
                    LwjglCanvas.this.input.update();
                    shouldRender |= LwjglCanvas.this.graphics.shouldRender();
                    LwjglCanvas.this.input.processEvents();
                    if (LwjglCanvas.this.audio != null) {
                        LwjglCanvas.this.audio.update();
                    }
                    if (this.checkResize()) {
                        shouldRender = true;
                    }
                    if (shouldRender) {
                        LwjglCanvas.this.graphics.updateTime();
                        ++LwjglCanvas.this.graphics.frameId;
                        LwjglCanvas.this.listener.render();
                        Display.update((boolean)false);
                    }
                    Display.sync((int)LwjglCanvas.this.getFrameRate());
                }
                catch (Throwable ex) {
                    LwjglCanvas.this.exception(ex);
                }
                EventQueue.invokeLater(this);
            }

            private boolean checkResize() {
                Container parent = LwjglCanvas.this.canvas.getParent();
                if (parent != null && (LwjglCanvas.this.canvas.getWidth() != parent.getWidth() || LwjglCanvas.this.canvas.getHeight() != parent.getHeight())) {
                    LwjglCanvas.this.canvas.setSize(parent.getWidth(), parent.getHeight());
                }
                int width = Math.max(1, LwjglCanvas.this.graphics.getWidth());
                int height = Math.max(1, LwjglCanvas.this.graphics.getHeight());
                if (this.lastWidth == width && this.lastHeight == height) {
                    return false;
                }
                this.lastWidth = width;
                this.lastHeight = height;
                Display.setLocation((int)0, (int)0);
                Gdx.gl.glViewport(0, 0, width, height);
                LwjglCanvas.this.resize(width, height);
                LwjglCanvas.this.listener.resize(width, height);
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeRunnables() {
        Array array = this.runnables;
        synchronized (array) {
            for (int i = this.runnables.size - 1; i >= 0; --i) {
                this.executedRunnables.add(this.runnables.get(i));
            }
            this.runnables.clear();
        }
        if (this.executedRunnables.size == 0) {
            return false;
        }
        do {
            Runnable runnable = (Runnable)this.executedRunnables.pop();
            Throwable caller = (Throwable)this.executedRunnables.pop();
            try {
                runnable.run();
            }
            catch (Throwable ex) {
                this.postedException(ex, caller);
            }
        } while (this.executedRunnables.size > 0);
        return true;
    }

    protected void postedException(Throwable ex, @Null Throwable caller) {
        if (caller == null) {
            throw new RuntimeException(ex);
        }
        StringWriter buffer = new StringWriter(1024);
        caller.printStackTrace(new PrintWriter(buffer));
        throw new RuntimeException("Posted: " + buffer, ex);
    }

    protected void exception(Throwable ex) {
        ex.printStackTrace();
        this.stop();
    }

    protected int getFrameRate() {
        int frameRate;
        int n = frameRate = Display.isActive() ? this.graphics.config.foregroundFPS : this.graphics.config.backgroundFPS;
        if (frameRate == -1) {
            frameRate = 10;
        }
        if (frameRate == 0) {
            frameRate = this.graphics.config.backgroundFPS;
        }
        if (frameRate == 0) {
            frameRate = 30;
        }
        return frameRate;
    }

    protected void start() {
    }

    protected void resize(int width, int height) {
    }

    protected void stopped() {
    }

    protected void disposed() {
    }

    public void stop() {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Array<LifecycleListener> listeners;
                if (!LwjglCanvas.this.running) {
                    return;
                }
                LwjglCanvas.this.running = false;
                Array<LifecycleListener> array = listeners = LwjglCanvas.this.lifecycleListeners;
                synchronized (array) {
                    for (LifecycleListener listener : listeners) {
                        listener.pause();
                        listener.dispose();
                    }
                }
                LwjglCanvas.this.listener.pause();
                LwjglCanvas.this.listener.dispose();
                try {
                    Display.destroy();
                    if (LwjglCanvas.this.audio != null) {
                        LwjglCanvas.this.audio.dispose();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                LwjglCanvas.this.disposed();
            }
        });
    }

    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public long getNativeHeap() {
        return this.getJavaHeap();
    }

    public Preferences getPreferences(String name) {
        if (this.preferences.containsKey(name)) {
            return this.preferences.get(name);
        }
        LwjglPreferences prefs = new LwjglPreferences(name, ".prefs/");
        this.preferences.put(name, prefs);
        return prefs;
    }

    public Clipboard getClipboard() {
        return new LwjglClipboard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRunnable(Runnable runnable) {
        Array array = this.runnables;
        synchronized (array) {
            this.runnables.add((Object)runnable);
            this.runnables.add((Object)(this.postedRunnableStacktraces ? new Throwable() : null));
            this.graphics.requestRendering();
        }
    }

    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(tag, message);
        }
    }

    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(tag, message, exception);
        }
    }

    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(tag, message);
        }
    }

    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(tag, message, exception);
        }
    }

    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(tag, message);
        }
    }

    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(tag, message, exception);
        }
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setApplicationLogger(ApplicationLogger applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    public ApplicationLogger getApplicationLogger() {
        return this.applicationLogger;
    }

    public void exit() {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                LwjglCanvas.this.listener.pause();
                LwjglCanvas.this.listener.dispose();
                if (LwjglCanvas.this.audio != null) {
                    LwjglCanvas.this.audio.dispose();
                }
                System.exit(-1);
            }
        });
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue((Object)listener, true);
        }
    }

    public void setPostedRunnableStacktraces(boolean postedRunnableStacktraces) {
        this.postedRunnableStacktraces = postedRunnableStacktraces;
    }

    @Override
    public LwjglAudio createAudio(LwjglApplicationConfiguration config) {
        return new OpenALLwjglAudio();
    }

    @Override
    public LwjglInput createInput(LwjglApplicationConfiguration config) {
        return new DefaultLwjglInput();
    }
}

