/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.backends.lwjgl.LwjglApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl.LwjglCanvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JFrame;
import org.lwjgl.opengl.Display;

public class LwjglFrame
extends JFrame {
    LwjglCanvas lwjglCanvas;
    private Thread shutdownHook;

    public LwjglFrame(ApplicationListener listener, String title, int width, int height) {
        super(title);
        LwjglApplicationConfiguration config = new LwjglApplicationConfiguration();
        config.title = title;
        config.width = width;
        config.height = height;
        this.construct(listener, config);
    }

    public LwjglFrame(ApplicationListener listener, LwjglApplicationConfiguration config) {
        super(config.title);
        this.construct(listener, config);
    }

    public LwjglFrame(ApplicationListener listener, LwjglApplicationConfiguration config, GraphicsConfiguration graphicsConfig) {
        super(config.title, graphicsConfig);
        this.construct(listener, config);
    }

    private void construct(ApplicationListener listener, LwjglApplicationConfiguration config) {
        this.lwjglCanvas = new LwjglCanvas(listener, config){

            @Override
            protected void stopped() {
                LwjglFrame.this.dispose();
            }

            @Override
            protected void setTitle(String title) {
                LwjglFrame.this.setTitle(title);
            }

            @Override
            protected void setDisplayMode(int width, int height) {
                Dimension size = new Dimension(Math.round((float)width / this.scaleX), Math.round((float)height / this.scaleY));
                LwjglFrame.this.getContentPane().setPreferredSize(size);
                LwjglFrame.this.getContentPane().invalidate();
                LwjglFrame.this.pack();
                LwjglFrame.this.setLocationRelativeTo(null);
                LwjglFrame.this.updateSize(width, height);
            }

            @Override
            protected void resize(int width, int height) {
                LwjglFrame.this.updateSize(width, height);
            }

            @Override
            protected void start() {
                LwjglFrame.this.start();
            }

            @Override
            protected void disposed() {
                LwjglFrame.this.disposed();
            }

            @Override
            protected void exception(Throwable t) {
                LwjglFrame.this.exception(t);
            }

            @Override
            protected void postedException(Throwable ex, Throwable caller) {
                LwjglFrame.this.postedException(ex, caller);
            }

            @Override
            protected int getFrameRate() {
                int frameRate = LwjglFrame.this.getFrameRate();
                return frameRate == 0 ? super.getFrameRate() : frameRate;
            }
        };
        this.setHaltOnShutdown(true);
        this.setDefaultCloseOperation(3);
        AffineTransform transform = this.getGraphicsConfiguration().getDefaultTransform();
        float scaleX = (float)transform.getScaleX();
        float scaleY = (float)transform.getScaleY();
        Dimension size = new Dimension(Math.round((float)config.width / scaleX), Math.round((float)config.height / scaleY));
        this.getContentPane().setPreferredSize(size);
        this.initialize();
        this.pack();
        Point location = this.getLocation();
        if (location.x == 0 && location.y == 0) {
            this.setLocationRelativeTo(null);
        }
        this.lwjglCanvas.getCanvas().setSize(size);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent event) {
                if (Display.isCreated()) {
                    Display.setLocation((int)0, (int)0);
                    LwjglFrame.this.lwjglCanvas.graphics.requestRendering();
                }
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LwjglFrame.this.addCanvas();
                LwjglFrame.this.setVisible(true);
                LwjglFrame.this.lwjglCanvas.getCanvas().requestFocus();
            }
        });
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.revalidate();
    }

    public void setHaltOnShutdown(boolean halt) {
        try {
            try {
                if (halt) {
                    if (this.shutdownHook != null) {
                        return;
                    }
                    this.shutdownHook = new Thread(){

                        @Override
                        public void run() {
                            Runtime.getRuntime().halt(0);
                        }
                    };
                    Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                } else if (this.shutdownHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                    this.shutdownHook = null;
                }
            }
            catch (Throwable throwable) {}
        }
        catch (IllegalStateException ex) {
            this.shutdownHook = null;
        }
    }

    protected int getFrameRate() {
        return 0;
    }

    protected void exception(Throwable ex) {
        ex.printStackTrace();
        this.lwjglCanvas.stop();
    }

    protected void postedException(Throwable ex, Throwable caller) {
        if (caller == null) {
            throw new RuntimeException(ex);
        }
        StringWriter buffer = new StringWriter(1024);
        caller.printStackTrace(new PrintWriter(buffer));
        throw new RuntimeException("Posted: " + buffer, ex);
    }

    protected void initialize() {
    }

    protected void addCanvas() {
        this.getContentPane().add(this.lwjglCanvas.getCanvas());
    }

    protected void start() {
    }

    public void updateSize(int width, int height) {
    }

    protected void disposed() {
    }

    public LwjglCanvas getLwjglCanvas() {
        return this.lwjglCanvas;
    }
}

