/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALLwjgl3Audio;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALUtils;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;

public abstract class OpenALMusic
implements Music {
    private static final int bufferSize = 40960;
    private static final int bufferCount = 3;
    private static final byte[] tempBytes = new byte[40960];
    private static final ByteBuffer tempBuffer = BufferUtils.createByteBuffer((int)40960);
    private FloatArray renderedSecondsQueue = new FloatArray(3);
    private final OpenALLwjgl3Audio audio;
    private IntBuffer buffers;
    private int sourceID = -1;
    private int format;
    private int sampleRate;
    private boolean isLooping;
    private boolean isPlaying;
    private float volume = 1.0f;
    private float pan = 0.0f;
    private float renderedSeconds;
    private float maxSecondsPerBuffer;
    protected final FileHandle file;
    private Music.OnCompletionListener onCompletionListener;

    public OpenALMusic(OpenALLwjgl3Audio audio, FileHandle file) {
        this.audio = audio;
        this.file = file;
        this.onCompletionListener = null;
    }

    protected void setup(int channels, int bitDepth, int sampleRate) {
        this.format = OpenALUtils.determineFormat(channels, bitDepth);
        this.sampleRate = sampleRate;
        this.maxSecondsPerBuffer = 40960.0f / (float)((bitDepth >> 3) * channels * sampleRate);
    }

    public void play() {
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID == -1) {
            int bufferID;
            this.sourceID = this.audio.obtainSource(true);
            if (this.sourceID == -1) {
                return;
            }
            this.audio.music.add((Object)this);
            if (this.buffers == null) {
                this.buffers = BufferUtils.createIntBuffer((int)3);
                AL10.alGetError();
                AL10.alGenBuffers((IntBuffer)this.buffers);
                int errorCode = AL10.alGetError();
                if (errorCode != 0) {
                    throw new GdxRuntimeException("Unable to allocate audio buffers. AL Error: " + errorCode);
                }
            }
            AL10.alSourcei((int)this.sourceID, (int)4103, (int)0);
            this.setPan(this.pan, this.volume);
            AL10.alGetError();
            boolean filled = false;
            for (int i = 0; i < 3 && this.fill(bufferID = this.buffers.get(i)); ++i) {
                filled = true;
                AL10.alSourceQueueBuffers((int)this.sourceID, (int)bufferID);
            }
            if (!filled && this.onCompletionListener != null) {
                this.onCompletionListener.onCompletion((Music)this);
            }
            if (AL10.alGetError() != 0) {
                this.stop();
                return;
            }
        }
        if (!this.isPlaying) {
            AL10.alSourcePlay((int)this.sourceID);
            this.isPlaying = true;
        }
    }

    public void stop() {
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID == -1) {
            return;
        }
        this.audio.music.removeValue((Object)this, true);
        this.reset();
        this.audio.freeSource(this.sourceID);
        this.sourceID = -1;
        this.renderedSeconds = 0.0f;
        this.renderedSecondsQueue.clear();
        this.isPlaying = false;
    }

    public void pause() {
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID != -1) {
            AL10.alSourcePause((int)this.sourceID);
        }
        this.isPlaying = false;
    }

    public boolean isPlaying() {
        if (this.audio.noDevice) {
            return false;
        }
        if (this.sourceID == -1) {
            return false;
        }
        return this.isPlaying;
    }

    public void setLooping(boolean isLooping) {
        this.isLooping = isLooping;
    }

    public boolean isLooping() {
        return this.isLooping;
    }

    public void setVolume(float volume) {
        if (volume < 0.0f) {
            throw new IllegalArgumentException("volume cannot be < 0: " + volume);
        }
        this.volume = volume;
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID != -1) {
            AL10.alSourcef((int)this.sourceID, (int)4106, (float)volume);
        }
    }

    public float getVolume() {
        return this.volume;
    }

    public void setPan(float pan, float volume) {
        this.volume = volume;
        this.pan = pan;
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID == -1) {
            return;
        }
        AL10.alSource3f((int)this.sourceID, (int)4100, (float)MathUtils.cos((float)((pan - 1.0f) * 1.5707964f)), (float)0.0f, (float)MathUtils.sin((float)((pan + 1.0f) * 1.5707964f)));
        AL10.alSourcef((int)this.sourceID, (int)4106, (float)volume);
    }

    public void setPosition(float position) {
        int bufferID;
        int length;
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID == -1) {
            return;
        }
        boolean wasPlaying = this.isPlaying;
        this.isPlaying = false;
        AL10.alSourceStop((int)this.sourceID);
        AL10.alSourceUnqueueBuffers((int)this.sourceID, (IntBuffer)this.buffers);
        while (this.renderedSecondsQueue.size > 0) {
            this.renderedSeconds = this.renderedSecondsQueue.pop();
        }
        if (position <= this.renderedSeconds) {
            this.reset();
            this.renderedSeconds = 0.0f;
        }
        while (this.renderedSeconds < position - this.maxSecondsPerBuffer && (length = this.read(tempBytes)) > 0) {
            float currentBufferSeconds = this.maxSecondsPerBuffer * (float)length / 40960.0f;
            this.renderedSeconds += currentBufferSeconds;
        }
        this.renderedSecondsQueue.add(this.renderedSeconds);
        boolean filled = false;
        for (int i = 0; i < 3 && this.fill(bufferID = this.buffers.get(i)); ++i) {
            filled = true;
            AL10.alSourceQueueBuffers((int)this.sourceID, (int)bufferID);
        }
        this.renderedSecondsQueue.pop();
        if (!filled) {
            this.stop();
            if (this.onCompletionListener != null) {
                this.onCompletionListener.onCompletion((Music)this);
            }
        }
        AL10.alSourcef((int)this.sourceID, (int)4132, (float)(position - this.renderedSeconds));
        if (wasPlaying) {
            AL10.alSourcePlay((int)this.sourceID);
            this.isPlaying = true;
        }
    }

    public float getPosition() {
        if (this.audio.noDevice) {
            return 0.0f;
        }
        if (this.sourceID == -1) {
            return 0.0f;
        }
        return this.renderedSeconds + AL10.alGetSourcef((int)this.sourceID, (int)4132);
    }

    public abstract int read(byte[] var1);

    public abstract void reset();

    protected void loop() {
        this.reset();
    }

    public int getChannels() {
        return this.format == 4355 ? 2 : 1;
    }

    public int getRate() {
        return this.sampleRate;
    }

    public void update() {
        int bufferID;
        if (this.audio.noDevice) {
            return;
        }
        if (this.sourceID == -1) {
            return;
        }
        boolean end = false;
        int buffers = AL10.alGetSourcei((int)this.sourceID, (int)4118);
        while (buffers-- > 0 && (bufferID = AL10.alSourceUnqueueBuffers((int)this.sourceID)) != 40963) {
            if (this.renderedSecondsQueue.size > 0) {
                this.renderedSeconds = this.renderedSecondsQueue.pop();
            }
            if (end) continue;
            if (this.fill(bufferID)) {
                AL10.alSourceQueueBuffers((int)this.sourceID, (int)bufferID);
                continue;
            }
            end = true;
        }
        if (end && AL10.alGetSourcei((int)this.sourceID, (int)4117) == 0) {
            this.stop();
            if (this.onCompletionListener != null) {
                this.onCompletionListener.onCompletion((Music)this);
            }
        }
        if (this.isPlaying && AL10.alGetSourcei((int)this.sourceID, (int)4112) != 4114) {
            AL10.alSourcePlay((int)this.sourceID);
        }
    }

    private boolean fill(int bufferID) {
        ((Buffer)tempBuffer).clear();
        int length = this.read(tempBytes);
        if (length <= 0) {
            if (this.isLooping) {
                this.loop();
                length = this.read(tempBytes);
                if (length <= 0) {
                    return false;
                }
                if (this.renderedSecondsQueue.size > 0) {
                    this.renderedSecondsQueue.set(0, 0.0f);
                }
            } else {
                return false;
            }
        }
        float previousLoadedSeconds = this.renderedSecondsQueue.size > 0 ? this.renderedSecondsQueue.first() : 0.0f;
        float currentBufferSeconds = this.maxSecondsPerBuffer * (float)length / 40960.0f;
        this.renderedSecondsQueue.insert(0, previousLoadedSeconds + currentBufferSeconds);
        ((Buffer)tempBuffer.put(tempBytes, 0, length)).flip();
        AL10.alBufferData((int)bufferID, (int)this.format, (ByteBuffer)tempBuffer, (int)this.sampleRate);
        return true;
    }

    public void dispose() {
        this.stop();
        if (this.audio.noDevice) {
            return;
        }
        if (this.buffers == null) {
            return;
        }
        AL10.alDeleteBuffers((IntBuffer)this.buffers);
        this.buffers = null;
        this.onCompletionListener = null;
    }

    public void setOnCompletionListener(Music.OnCompletionListener listener) {
        this.onCompletionListener = listener;
    }

    public int getSourceId() {
        return this.sourceID;
    }
}

