/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationBase;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Cursor;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Input;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowListener;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Os;
import com.badlogic.gdx.utils.SharedLibraryLoader;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWDropCallback;
import org.lwjgl.glfw.GLFWDropCallbackI;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWWindowCloseCallback;
import org.lwjgl.glfw.GLFWWindowCloseCallbackI;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl.glfw.GLFWWindowIconifyCallback;
import org.lwjgl.glfw.GLFWWindowIconifyCallbackI;
import org.lwjgl.glfw.GLFWWindowMaximizeCallback;
import org.lwjgl.glfw.GLFWWindowMaximizeCallbackI;
import org.lwjgl.glfw.GLFWWindowRefreshCallback;
import org.lwjgl.glfw.GLFWWindowRefreshCallbackI;
import org.lwjgl.system.Struct;

public class Lwjgl3Window
implements Disposable {
    private long windowHandle;
    final ApplicationListener listener;
    private final Array<LifecycleListener> lifecycleListeners;
    final Lwjgl3ApplicationBase application;
    private boolean listenerInitialized = false;
    Lwjgl3WindowListener windowListener;
    private Lwjgl3Graphics graphics;
    private Lwjgl3Input input;
    private final Lwjgl3ApplicationConfiguration config;
    private final Array<Runnable> runnables = new Array();
    private final Array<Runnable> executedRunnables = new Array();
    private final IntBuffer tmpBuffer;
    private final IntBuffer tmpBuffer2;
    boolean iconified = false;
    boolean focused = false;
    boolean asyncResized = false;
    private boolean requestRendering = false;
    private final GLFWWindowFocusCallback focusCallback = new GLFWWindowFocusCallback(){

        public void invoke(long windowHandle, final boolean focused) {
            Lwjgl3Window.this.postRunnable(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (focused) {
                        if (((Lwjgl3Window)Lwjgl3Window.this).config.pauseWhenLostFocus) {
                            Array array = Lwjgl3Window.this.lifecycleListeners;
                            synchronized (array) {
                                for (LifecycleListener lifecycleListener : Lwjgl3Window.this.lifecycleListeners) {
                                    lifecycleListener.resume();
                                }
                            }
                            Lwjgl3Window.this.listener.resume();
                        }
                        if (Lwjgl3Window.this.windowListener != null) {
                            Lwjgl3Window.this.windowListener.focusGained();
                        }
                    } else {
                        if (Lwjgl3Window.this.windowListener != null) {
                            Lwjgl3Window.this.windowListener.focusLost();
                        }
                        if (((Lwjgl3Window)Lwjgl3Window.this).config.pauseWhenLostFocus) {
                            Array array = Lwjgl3Window.this.lifecycleListeners;
                            synchronized (array) {
                                for (LifecycleListener lifecycleListener : Lwjgl3Window.this.lifecycleListeners) {
                                    lifecycleListener.pause();
                                }
                            }
                            Lwjgl3Window.this.listener.pause();
                        }
                    }
                    Lwjgl3Window.this.focused = focused;
                }
            });
        }
    };
    private final GLFWWindowIconifyCallback iconifyCallback = new GLFWWindowIconifyCallback(){

        public void invoke(long windowHandle, final boolean iconified) {
            Lwjgl3Window.this.postRunnable(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (Lwjgl3Window.this.windowListener != null) {
                        Lwjgl3Window.this.windowListener.iconified(iconified);
                    }
                    Lwjgl3Window.this.iconified = iconified;
                    if (iconified) {
                        if (((Lwjgl3Window)Lwjgl3Window.this).config.pauseWhenMinimized) {
                            Array array = Lwjgl3Window.this.lifecycleListeners;
                            synchronized (array) {
                                for (LifecycleListener lifecycleListener : Lwjgl3Window.this.lifecycleListeners) {
                                    lifecycleListener.pause();
                                }
                            }
                            Lwjgl3Window.this.listener.pause();
                        }
                    } else if (((Lwjgl3Window)Lwjgl3Window.this).config.pauseWhenMinimized) {
                        Array array = Lwjgl3Window.this.lifecycleListeners;
                        synchronized (array) {
                            for (LifecycleListener lifecycleListener : Lwjgl3Window.this.lifecycleListeners) {
                                lifecycleListener.resume();
                            }
                        }
                        Lwjgl3Window.this.listener.resume();
                    }
                }
            });
        }
    };
    private final GLFWWindowMaximizeCallback maximizeCallback = new GLFWWindowMaximizeCallback(){

        public void invoke(long windowHandle, final boolean maximized) {
            Lwjgl3Window.this.postRunnable(new Runnable(){

                @Override
                public void run() {
                    if (Lwjgl3Window.this.windowListener != null) {
                        Lwjgl3Window.this.windowListener.maximized(maximized);
                    }
                }
            });
        }
    };
    private final GLFWWindowCloseCallback closeCallback = new GLFWWindowCloseCallback(){

        public void invoke(final long windowHandle) {
            Lwjgl3Window.this.postRunnable(new Runnable(){

                @Override
                public void run() {
                    if (Lwjgl3Window.this.windowListener != null && !Lwjgl3Window.this.windowListener.closeRequested()) {
                        GLFW.glfwSetWindowShouldClose((long)windowHandle, (boolean)false);
                    }
                }
            });
        }
    };
    private final GLFWDropCallback dropCallback = new GLFWDropCallback(){

        public void invoke(long windowHandle, int count, long names) {
            final String[] files = new String[count];
            for (int i = 0; i < count; ++i) {
                files[i] = 5.getName((long)names, (int)i);
            }
            Lwjgl3Window.this.postRunnable(new Runnable(){

                @Override
                public void run() {
                    if (Lwjgl3Window.this.windowListener != null) {
                        Lwjgl3Window.this.windowListener.filesDropped(files);
                    }
                }
            });
        }
    };
    private final GLFWWindowRefreshCallback refreshCallback = new GLFWWindowRefreshCallback(){

        public void invoke(long windowHandle) {
            Lwjgl3Window.this.postRunnable(new Runnable(){

                @Override
                public void run() {
                    if (Lwjgl3Window.this.windowListener != null) {
                        Lwjgl3Window.this.windowListener.refreshRequested();
                    }
                }
            });
        }
    };

    Lwjgl3Window(ApplicationListener listener, Array<LifecycleListener> lifecycleListeners, Lwjgl3ApplicationConfiguration config, Lwjgl3ApplicationBase application) {
        this.listener = listener;
        this.lifecycleListeners = lifecycleListeners;
        this.windowListener = config.windowListener;
        this.config = config;
        this.application = application;
        this.tmpBuffer = BufferUtils.createIntBuffer((int)1);
        this.tmpBuffer2 = BufferUtils.createIntBuffer((int)1);
    }

    void create(long windowHandle) {
        this.windowHandle = windowHandle;
        this.input = this.application.createInput(this);
        this.graphics = new Lwjgl3Graphics(this);
        GLFW.glfwSetWindowFocusCallback((long)windowHandle, (GLFWWindowFocusCallbackI)this.focusCallback);
        GLFW.glfwSetWindowIconifyCallback((long)windowHandle, (GLFWWindowIconifyCallbackI)this.iconifyCallback);
        GLFW.glfwSetWindowMaximizeCallback((long)windowHandle, (GLFWWindowMaximizeCallbackI)this.maximizeCallback);
        GLFW.glfwSetWindowCloseCallback((long)windowHandle, (GLFWWindowCloseCallbackI)this.closeCallback);
        GLFW.glfwSetDropCallback((long)windowHandle, (GLFWDropCallbackI)this.dropCallback);
        GLFW.glfwSetWindowRefreshCallback((long)windowHandle, (GLFWWindowRefreshCallbackI)this.refreshCallback);
        if (this.windowListener != null) {
            this.windowListener.created(this);
        }
    }

    public ApplicationListener getListener() {
        return this.listener;
    }

    public Lwjgl3WindowListener getWindowListener() {
        return this.windowListener;
    }

    public void setWindowListener(Lwjgl3WindowListener listener) {
        this.windowListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add((Object)runnable);
        }
    }

    public void setPosition(int x, int y) {
        if (GLFW.glfwGetPlatform() == 393219) {
            return;
        }
        GLFW.glfwSetWindowPos((long)this.windowHandle, (int)x, (int)y);
    }

    public int getPositionX() {
        GLFW.glfwGetWindowPos((long)this.windowHandle, (IntBuffer)this.tmpBuffer, (IntBuffer)this.tmpBuffer2);
        return this.tmpBuffer.get(0);
    }

    public int getPositionY() {
        GLFW.glfwGetWindowPos((long)this.windowHandle, (IntBuffer)this.tmpBuffer, (IntBuffer)this.tmpBuffer2);
        return this.tmpBuffer2.get(0);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            GLFW.glfwShowWindow((long)this.windowHandle);
        } else {
            GLFW.glfwHideWindow((long)this.windowHandle);
        }
    }

    public void closeWindow() {
        GLFW.glfwSetWindowShouldClose((long)this.windowHandle, (boolean)true);
    }

    public void iconifyWindow() {
        GLFW.glfwIconifyWindow((long)this.windowHandle);
    }

    public boolean isIconified() {
        return this.iconified;
    }

    public void restoreWindow() {
        GLFW.glfwRestoreWindow((long)this.windowHandle);
    }

    public void maximizeWindow() {
        GLFW.glfwMaximizeWindow((long)this.windowHandle);
    }

    public void focusWindow() {
        GLFW.glfwFocusWindow((long)this.windowHandle);
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setIcon(Pixmap ... image) {
        Lwjgl3Window.setIcon(this.windowHandle, image);
    }

    static void setIcon(long windowHandle, String[] imagePaths, Files.FileType imageFileType) {
        if (SharedLibraryLoader.os == Os.MacOsX) {
            return;
        }
        Pixmap[] pixmaps = new Pixmap[imagePaths.length];
        for (int i = 0; i < imagePaths.length; ++i) {
            pixmaps[i] = new Pixmap(Gdx.files.getFileHandle(imagePaths[i], imageFileType));
        }
        Lwjgl3Window.setIcon(windowHandle, pixmaps);
        for (Pixmap pixmap : pixmaps) {
            pixmap.dispose();
        }
    }

    static void setIcon(long windowHandle, Pixmap[] images) {
        if (SharedLibraryLoader.os == Os.MacOsX) {
            return;
        }
        if (GLFW.glfwGetPlatform() == 393219) {
            return;
        }
        GLFWImage.Buffer buffer = GLFWImage.malloc((int)images.length);
        Pixmap[] tmpPixmaps = new Pixmap[images.length];
        for (int i = 0; i < images.length; ++i) {
            Pixmap pixmap = images[i];
            if (pixmap.getFormat() != Pixmap.Format.RGBA8888) {
                Pixmap rgba = new Pixmap(pixmap.getWidth(), pixmap.getHeight(), Pixmap.Format.RGBA8888);
                rgba.setBlending(Pixmap.Blending.None);
                rgba.drawPixmap(pixmap, 0, 0);
                tmpPixmaps[i] = rgba;
                pixmap = rgba;
            }
            GLFWImage icon = GLFWImage.malloc();
            icon.set(pixmap.getWidth(), pixmap.getHeight(), pixmap.getPixels());
            buffer.put((Struct)icon);
            icon.free();
        }
        buffer.position(0);
        GLFW.glfwSetWindowIcon((long)windowHandle, (GLFWImage.Buffer)buffer);
        buffer.free();
        for (Pixmap pixmap : tmpPixmaps) {
            if (pixmap == null) continue;
            pixmap.dispose();
        }
    }

    public void setTitle(CharSequence title) {
        GLFW.glfwSetWindowTitle((long)this.windowHandle, (CharSequence)title);
    }

    public void setSizeLimits(int minWidth, int minHeight, int maxWidth, int maxHeight) {
        Lwjgl3Window.setSizeLimits(this.windowHandle, minWidth, minHeight, maxWidth, maxHeight);
    }

    static void setSizeLimits(long windowHandle, int minWidth, int minHeight, int maxWidth, int maxHeight) {
        GLFW.glfwSetWindowSizeLimits((long)windowHandle, (int)(minWidth > -1 ? minWidth : -1), (int)(minHeight > -1 ? minHeight : -1), (int)(maxWidth > -1 ? maxWidth : -1), (int)(maxHeight > -1 ? maxHeight : -1));
    }

    Lwjgl3Graphics getGraphics() {
        return this.graphics;
    }

    Lwjgl3Input getInput() {
        return this.input;
    }

    public long getWindowHandle() {
        return this.windowHandle;
    }

    void windowHandleChanged(long windowHandle) {
        this.windowHandle = windowHandle;
        this.input.windowHandleChanged(windowHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean update() {
        if (!this.listenerInitialized) {
            this.initializeListener();
        }
        Array.ArrayIterator arrayIterator = this.runnables;
        synchronized (arrayIterator) {
            this.executedRunnables.addAll(this.runnables);
            this.runnables.clear();
        }
        for (Runnable runnable : this.executedRunnables) {
            runnable.run();
        }
        boolean shouldRender = this.executedRunnables.size > 0 || this.graphics.isContinuousRendering();
        this.executedRunnables.clear();
        if (!this.iconified) {
            this.input.update();
        }
        Lwjgl3Window lwjgl3Window = this;
        synchronized (lwjgl3Window) {
            shouldRender |= this.requestRendering && !this.iconified;
            this.requestRendering = false;
        }
        if (this.asyncResized) {
            this.asyncResized = false;
            this.graphics.updateFramebufferInfo();
            this.graphics.gl20.glViewport(0, 0, this.graphics.getBackBufferWidth(), this.graphics.getBackBufferHeight());
            this.listener.resize(this.graphics.getWidth(), this.graphics.getHeight());
            this.graphics.update();
            this.listener.render();
            GLFW.glfwSwapBuffers((long)this.windowHandle);
            return true;
        }
        if (shouldRender) {
            this.graphics.update();
            this.listener.render();
            GLFW.glfwSwapBuffers((long)this.windowHandle);
        }
        if (!this.iconified) {
            this.input.prepareNext();
        }
        return shouldRender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestRendering() {
        Lwjgl3Window lwjgl3Window = this;
        synchronized (lwjgl3Window) {
            this.requestRendering = true;
        }
    }

    boolean shouldClose() {
        return GLFW.glfwWindowShouldClose((long)this.windowHandle);
    }

    Lwjgl3ApplicationConfiguration getConfig() {
        return this.config;
    }

    boolean isListenerInitialized() {
        return this.listenerInitialized;
    }

    void initializeListener() {
        if (!this.listenerInitialized) {
            this.listener.create();
            this.listener.resize(this.graphics.getWidth(), this.graphics.getHeight());
            this.listenerInitialized = true;
        }
    }

    void makeCurrent() {
        Gdx.graphics = this.graphics;
        Gdx.gl32 = this.graphics.getGL32();
        Gdx.gl31 = Gdx.gl32 != null ? Gdx.gl32 : this.graphics.getGL31();
        Gdx.gl30 = Gdx.gl31 != null ? Gdx.gl31 : this.graphics.getGL30();
        Gdx.gl = Gdx.gl20 = Gdx.gl30 != null ? Gdx.gl30 : this.graphics.getGL20();
        Gdx.input = this.input;
        GLFW.glfwMakeContextCurrent((long)this.windowHandle);
    }

    public void dispose() {
        this.listener.pause();
        this.listener.dispose();
        Lwjgl3Cursor.dispose(this);
        this.graphics.dispose();
        this.input.dispose();
        GLFW.glfwSetWindowFocusCallback((long)this.windowHandle, null);
        GLFW.glfwSetWindowIconifyCallback((long)this.windowHandle, null);
        GLFW.glfwSetWindowCloseCallback((long)this.windowHandle, null);
        GLFW.glfwSetDropCallback((long)this.windowHandle, null);
        GLFW.glfwDestroyWindow((long)this.windowHandle);
        this.focusCallback.free();
        this.iconifyCallback.free();
        this.maximizeCallback.free();
        this.closeCallback.free();
        this.dropCallback.free();
        this.refreshCallback.free();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.windowHandle ^ this.windowHandle >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Lwjgl3Window other = (Lwjgl3Window)obj;
        return this.windowHandle == other.windowHandle;
    }

    public void flash() {
        GLFW.glfwRequestWindowAttention((long)this.windowHandle);
    }
}

