/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3.audio;

import com.badlogic.gdx.audio.AudioDevice;
import com.badlogic.gdx.audio.AudioRecorder;
import com.badlogic.gdx.backends.lwjgl3.audio.JavaSoundAudioRecorder;
import com.badlogic.gdx.backends.lwjgl3.audio.Lwjgl3Audio;
import com.badlogic.gdx.backends.lwjgl3.audio.Mp3;
import com.badlogic.gdx.backends.lwjgl3.audio.Ogg;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALAudioDevice;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALMusic;
import com.badlogic.gdx.backends.lwjgl3.audio.OpenALSound;
import com.badlogic.gdx.backends.lwjgl3.audio.Wav;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.LongMap;
import com.badlogic.gdx.utils.ObjectMap;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;

public class OpenALLwjgl3Audio
implements Lwjgl3Audio {
    private final int deviceBufferSize;
    private final int deviceBufferCount;
    private IntArray idleSources;
    private IntArray allSources;
    private LongMap<Integer> soundIdToSource;
    private IntMap<Long> sourceToSoundId;
    private long nextSoundId = 0L;
    private ObjectMap<String, Class<? extends OpenALSound>> extensionToSoundClass = new ObjectMap();
    private ObjectMap<String, Class<? extends OpenALMusic>> extensionToMusicClass = new ObjectMap();
    private OpenALSound[] recentSounds;
    private int mostRecetSound = -1;
    Array<OpenALMusic> music = new Array(false, 1, OpenALMusic.class);
    long device;
    long context;
    boolean noDevice = false;

    public OpenALLwjgl3Audio() {
        this(16, 9, 512);
    }

    public OpenALLwjgl3Audio(int simultaneousSources, int deviceBufferCount, int deviceBufferSize) {
        this.deviceBufferSize = deviceBufferSize;
        this.deviceBufferCount = deviceBufferCount;
        this.registerSound("ogg", Ogg.Sound.class);
        this.registerMusic("ogg", Ogg.Music.class);
        this.registerSound("wav", Wav.Sound.class);
        this.registerMusic("wav", Wav.Music.class);
        this.registerSound("mp3", Mp3.Sound.class);
        this.registerMusic("mp3", Mp3.Music.class);
        this.device = ALC10.alcOpenDevice((ByteBuffer)null);
        if (this.device == 0L) {
            this.noDevice = true;
            return;
        }
        ALCCapabilities deviceCapabilities = ALC.createCapabilities((long)this.device);
        this.context = ALC10.alcCreateContext((long)this.device, (IntBuffer)null);
        if (this.context == 0L) {
            ALC10.alcCloseDevice((long)this.device);
            this.noDevice = true;
            return;
        }
        if (!ALC10.alcMakeContextCurrent((long)this.context)) {
            this.noDevice = true;
            return;
        }
        AL.createCapabilities((ALCCapabilities)deviceCapabilities);
        this.allSources = new IntArray(false, simultaneousSources);
        for (int i = 0; i < simultaneousSources; ++i) {
            int sourceID = AL10.alGenSources();
            if (AL10.alGetError() != 0) break;
            this.allSources.add(sourceID);
        }
        this.idleSources = new IntArray(this.allSources);
        this.soundIdToSource = new LongMap();
        this.sourceToSoundId = new IntMap();
        FloatBuffer orientation = (FloatBuffer)BufferUtils.createFloatBuffer((int)6).put(new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f}).flip();
        AL10.alListenerfv((int)4111, (FloatBuffer)orientation);
        FloatBuffer velocity = (FloatBuffer)BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f}).flip();
        AL10.alListenerfv((int)4102, (FloatBuffer)velocity);
        FloatBuffer position = (FloatBuffer)BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f}).flip();
        AL10.alListenerfv((int)4100, (FloatBuffer)position);
        this.recentSounds = new OpenALSound[simultaneousSources];
    }

    public void registerSound(String extension, Class<? extends OpenALSound> soundClass) {
        if (extension == null) {
            throw new IllegalArgumentException("extension cannot be null.");
        }
        if (soundClass == null) {
            throw new IllegalArgumentException("soundClass cannot be null.");
        }
        this.extensionToSoundClass.put((Object)extension, soundClass);
    }

    public void registerMusic(String extension, Class<? extends OpenALMusic> musicClass) {
        if (extension == null) {
            throw new IllegalArgumentException("extension cannot be null.");
        }
        if (musicClass == null) {
            throw new IllegalArgumentException("musicClass cannot be null.");
        }
        this.extensionToMusicClass.put((Object)extension, musicClass);
    }

    public OpenALSound newSound(FileHandle file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        Class soundClass = (Class)this.extensionToSoundClass.get((Object)file.extension().toLowerCase());
        if (soundClass == null) {
            throw new GdxRuntimeException("Unknown file extension for sound: " + file);
        }
        try {
            return (OpenALSound)soundClass.getConstructor(OpenALLwjgl3Audio.class, FileHandle.class).newInstance(this, file);
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error creating sound " + soundClass.getName() + " for file: " + file, (Throwable)ex);
        }
    }

    public OpenALMusic newMusic(FileHandle file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null.");
        }
        Class musicClass = (Class)this.extensionToMusicClass.get((Object)file.extension().toLowerCase());
        if (musicClass == null) {
            throw new GdxRuntimeException("Unknown file extension for music: " + file);
        }
        try {
            return (OpenALMusic)musicClass.getConstructor(OpenALLwjgl3Audio.class, FileHandle.class).newInstance(this, file);
        }
        catch (Exception ex) {
            throw new GdxRuntimeException("Error creating music " + musicClass.getName() + " for file: " + file, (Throwable)ex);
        }
    }

    int obtainSource(boolean isMusic) {
        if (this.noDevice) {
            return 0;
        }
        int n = this.idleSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceId = this.idleSources.get(i);
            int state = AL10.alGetSourcei((int)sourceId, (int)4112);
            if (state == 4114 || state == 4115) continue;
            if (isMusic) {
                this.idleSources.removeIndex(i);
            } else {
                Long oldSoundId = (Long)this.sourceToSoundId.remove(sourceId);
                if (oldSoundId != null) {
                    this.soundIdToSource.remove(oldSoundId.longValue());
                }
                long soundId = this.nextSoundId++;
                this.sourceToSoundId.put(sourceId, (Object)soundId);
                this.soundIdToSource.put(soundId, (Object)sourceId);
            }
            AL10.alSourceStop((int)sourceId);
            AL10.alSourcei((int)sourceId, (int)4105, (int)0);
            AL10.alSourcef((int)sourceId, (int)4106, (float)1.0f);
            AL10.alSourcef((int)sourceId, (int)4099, (float)1.0f);
            AL10.alSource3f((int)sourceId, (int)4100, (float)0.0f, (float)0.0f, (float)1.0f);
            return sourceId;
        }
        return -1;
    }

    void freeSource(int sourceID) {
        if (this.noDevice) {
            return;
        }
        AL10.alSourceStop((int)sourceID);
        AL10.alSourcei((int)sourceID, (int)4105, (int)0);
        Long soundId = (Long)this.sourceToSoundId.remove(sourceID);
        if (soundId != null) {
            this.soundIdToSource.remove(soundId.longValue());
        }
        this.idleSources.add(sourceID);
    }

    void freeBuffer(int bufferID) {
        if (this.noDevice) {
            return;
        }
        int n = this.idleSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.idleSources.get(i);
            if (AL10.alGetSourcei((int)sourceID, (int)4105) != bufferID) continue;
            Long soundId = (Long)this.sourceToSoundId.remove(sourceID);
            if (soundId != null) {
                this.soundIdToSource.remove(soundId.longValue());
            }
            AL10.alSourceStop((int)sourceID);
            AL10.alSourcei((int)sourceID, (int)4105, (int)0);
        }
    }

    void stopSourcesWithBuffer(int bufferID) {
        if (this.noDevice) {
            return;
        }
        int n = this.idleSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.idleSources.get(i);
            if (AL10.alGetSourcei((int)sourceID, (int)4105) != bufferID) continue;
            Long soundId = (Long)this.sourceToSoundId.remove(sourceID);
            if (soundId != null) {
                this.soundIdToSource.remove(soundId.longValue());
            }
            AL10.alSourceStop((int)sourceID);
        }
    }

    void pauseSourcesWithBuffer(int bufferID) {
        if (this.noDevice) {
            return;
        }
        int n = this.idleSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.idleSources.get(i);
            if (AL10.alGetSourcei((int)sourceID, (int)4105) != bufferID) continue;
            AL10.alSourcePause((int)sourceID);
        }
    }

    void resumeSourcesWithBuffer(int bufferID) {
        if (this.noDevice) {
            return;
        }
        int n = this.idleSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.idleSources.get(i);
            if (AL10.alGetSourcei((int)sourceID, (int)4105) != bufferID || AL10.alGetSourcei((int)sourceID, (int)4112) != 4115) continue;
            AL10.alSourcePlay((int)sourceID);
        }
    }

    @Override
    public void update() {
        if (this.noDevice) {
            return;
        }
        for (int i = 0; i < this.music.size; ++i) {
            ((OpenALMusic[])this.music.items)[i].update();
        }
    }

    public long getSoundId(int sourceId) {
        Long soundId = (Long)this.sourceToSoundId.get(sourceId);
        return soundId != null ? soundId : -1L;
    }

    public int getSourceId(long soundId) {
        Integer sourceId = (Integer)this.soundIdToSource.get(soundId);
        return sourceId != null ? sourceId : -1;
    }

    public void stopSound(long soundId) {
        Integer sourceId = (Integer)this.soundIdToSource.get(soundId);
        if (sourceId != null) {
            AL10.alSourceStop((int)sourceId);
        }
    }

    public void pauseSound(long soundId) {
        Integer sourceId = (Integer)this.soundIdToSource.get(soundId);
        if (sourceId != null) {
            AL10.alSourcePause((int)sourceId);
        }
    }

    public void resumeSound(long soundId) {
        int sourceId = (Integer)this.soundIdToSource.get(soundId, (Object)-1);
        if (sourceId != -1 && AL10.alGetSourcei((int)sourceId, (int)4112) == 4115) {
            AL10.alSourcePlay((int)sourceId);
        }
    }

    public void setSoundGain(long soundId, float volume) {
        Integer sourceId = (Integer)this.soundIdToSource.get(soundId);
        if (sourceId != null) {
            AL10.alSourcef((int)sourceId, (int)4106, (float)volume);
        }
    }

    public void setSoundLooping(long soundId, boolean looping) {
        Integer sourceId = (Integer)this.soundIdToSource.get(soundId);
        if (sourceId != null) {
            AL10.alSourcei((int)sourceId, (int)4103, (int)(looping ? 1 : 0));
        }
    }

    public void setSoundPitch(long soundId, float pitch) {
        Integer sourceId = (Integer)this.soundIdToSource.get(soundId);
        if (sourceId != null) {
            AL10.alSourcef((int)sourceId, (int)4099, (float)pitch);
        }
    }

    public void setSoundPan(long soundId, float pan, float volume) {
        int sourceId = (Integer)this.soundIdToSource.get(soundId, (Object)-1);
        if (sourceId != -1) {
            AL10.alSource3f((int)sourceId, (int)4100, (float)MathUtils.cos((float)((pan - 1.0f) * 1.5707964f)), (float)0.0f, (float)MathUtils.sin((float)((pan + 1.0f) * 1.5707964f)));
            AL10.alSourcef((int)sourceId, (int)4106, (float)volume);
        }
    }

    public void dispose() {
        if (this.noDevice) {
            return;
        }
        int n = this.allSources.size;
        for (int i = 0; i < n; ++i) {
            int sourceID = this.allSources.get(i);
            int state = AL10.alGetSourcei((int)sourceID, (int)4112);
            if (state != 4116) {
                AL10.alSourceStop((int)sourceID);
            }
            AL10.alDeleteSources((int)sourceID);
        }
        this.sourceToSoundId.clear();
        this.soundIdToSource.clear();
        ALC10.alcDestroyContext((long)this.context);
        ALC10.alcCloseDevice((long)this.device);
    }

    public AudioDevice newAudioDevice(int sampleRate, final boolean isMono) {
        if (this.noDevice) {
            return new AudioDevice(){

                public void writeSamples(float[] samples, int offset, int numSamples) {
                }

                public void writeSamples(short[] samples, int offset, int numSamples) {
                }

                public void setVolume(float volume) {
                }

                public boolean isMono() {
                    return isMono;
                }

                public int getLatency() {
                    return 0;
                }

                public void dispose() {
                }
            };
        }
        return new OpenALAudioDevice(this, sampleRate, isMono, this.deviceBufferSize, this.deviceBufferCount);
    }

    public AudioRecorder newAudioRecorder(int samplingRate, boolean isMono) {
        if (this.noDevice) {
            return new AudioRecorder(){

                public void read(short[] samples, int offset, int numSamples) {
                }

                public void dispose() {
                }
            };
        }
        return new JavaSoundAudioRecorder(samplingRate, isMono);
    }

    protected void retain(OpenALSound sound, boolean stop) {
        ++this.mostRecetSound;
        this.mostRecetSound %= this.recentSounds.length;
        if (stop && this.recentSounds[this.mostRecetSound] != null) {
            this.recentSounds[this.mostRecetSound].stop();
        }
        this.recentSounds[this.mostRecetSound] = sound;
    }

    public void forget(OpenALSound sound) {
        for (int i = 0; i < this.recentSounds.length; ++i) {
            if (this.recentSounds[i] != sound) continue;
            this.recentSounds[i] = null;
        }
    }
}

