/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3;

import com.badlogic.gdx.Input;
import com.badlogic.gdx.InputEventQueue;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Window;
import com.badlogic.gdx.utils.Disposable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWCursorPosCallbackI;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;

public class Lwjgl3Input
implements Input,
Disposable {
    private final Lwjgl3Window window;
    private InputProcessor inputProcessor;
    private final InputEventQueue eventQueue = new InputEventQueue();
    private int mouseX;
    private int mouseY;
    private int mousePressed;
    private int deltaX;
    private int deltaY;
    private boolean justTouched;
    private int pressedKeys;
    private boolean keyJustPressed;
    private boolean[] justPressedKeys = new boolean[256];
    private long currentEventTime;
    private char lastCharacter;
    private GLFWKeyCallback keyCallback = new GLFWKeyCallback(){

        public void invoke(long window, int key, int scancode, int action, int mods) {
            switch (action) {
                case 1: {
                    key = Lwjgl3Input.getGdxKeyCode(key);
                    Lwjgl3Input.this.updateCurrentEventTime();
                    Lwjgl3Input.this.eventQueue.keyDown(key);
                    Lwjgl3Input.this.pressedKeys++;
                    Lwjgl3Input.this.keyJustPressed = true;
                    ((Lwjgl3Input)Lwjgl3Input.this).justPressedKeys[key] = true;
                    Lwjgl3Input.this.window.getGraphics().requestRendering();
                    Lwjgl3Input.this.lastCharacter = '\u0000';
                    char character = Lwjgl3Input.characterForKeyCode(key);
                    if (character == '\u0000') break;
                    Lwjgl3Input.this.charCallback.invoke(window, (int)character);
                    break;
                }
                case 0: {
                    Lwjgl3Input.this.pressedKeys--;
                    Lwjgl3Input.this.window.getGraphics().requestRendering();
                    Lwjgl3Input.this.updateCurrentEventTime();
                    Lwjgl3Input.this.eventQueue.keyUp(Lwjgl3Input.getGdxKeyCode(key));
                    break;
                }
                case 2: {
                    if (Lwjgl3Input.this.lastCharacter == '\u0000') break;
                    Lwjgl3Input.this.window.getGraphics().requestRendering();
                    Lwjgl3Input.this.updateCurrentEventTime();
                    Lwjgl3Input.this.eventQueue.keyTyped(Lwjgl3Input.this.lastCharacter);
                }
            }
        }
    };
    private GLFWCharCallback charCallback = new GLFWCharCallback(){

        public void invoke(long window, int codepoint) {
            if ((codepoint & 0xFF00) == 63232) {
                return;
            }
            Lwjgl3Input.this.lastCharacter = (char)codepoint;
            Lwjgl3Input.this.window.getGraphics().requestRendering();
            Lwjgl3Input.this.updateCurrentEventTime();
            Lwjgl3Input.this.eventQueue.keyTyped((char)codepoint);
        }
    };
    private GLFWScrollCallback scrollCallback = new GLFWScrollCallback(){

        public void invoke(long window, double scrollX, double scrollY) {
            Lwjgl3Input.this.window.getGraphics().requestRendering();
            Lwjgl3Input.this.updateCurrentEventTime();
            Lwjgl3Input.this.eventQueue.scrolled((int)(-Math.signum(scrollY)));
        }
    };
    private GLFWCursorPosCallback cursorPosCallback = new GLFWCursorPosCallback(){
        private int logicalMouseY;
        private int logicalMouseX;

        public void invoke(long windowHandle, double x, double y) {
            Lwjgl3Input.this.deltaX = (int)x - this.logicalMouseX;
            Lwjgl3Input.this.deltaY = (int)y - this.logicalMouseY;
            this.logicalMouseX = (int)x;
            Lwjgl3Input.this.mouseX = this.logicalMouseX;
            this.logicalMouseY = (int)y;
            Lwjgl3Input.this.mouseY = this.logicalMouseY;
            if (((Lwjgl3Input)Lwjgl3Input.this).window.getConfig().hdpiMode == Lwjgl3ApplicationConfiguration.HdpiMode.Pixels) {
                float xScale = (float)Lwjgl3Input.this.window.getGraphics().getBackBufferWidth() / (float)Lwjgl3Input.this.window.getGraphics().getLogicalWidth();
                float yScale = (float)Lwjgl3Input.this.window.getGraphics().getBackBufferHeight() / (float)Lwjgl3Input.this.window.getGraphics().getLogicalHeight();
                Lwjgl3Input.this.deltaX = (int)((float)Lwjgl3Input.this.deltaX * xScale);
                Lwjgl3Input.this.deltaY = (int)((float)Lwjgl3Input.this.deltaY * yScale);
                Lwjgl3Input.this.mouseX = (int)((float)Lwjgl3Input.this.mouseX * xScale);
                Lwjgl3Input.this.mouseY = (int)((float)Lwjgl3Input.this.mouseY * yScale);
            }
            Lwjgl3Input.this.window.getGraphics().requestRendering();
            Lwjgl3Input.this.updateCurrentEventTime();
            if (Lwjgl3Input.this.mousePressed > 0) {
                Lwjgl3Input.this.eventQueue.touchDragged(Lwjgl3Input.this.mouseX, Lwjgl3Input.this.mouseY, 0);
            } else {
                Lwjgl3Input.this.eventQueue.mouseMoved(Lwjgl3Input.this.mouseX, Lwjgl3Input.this.mouseY);
            }
        }
    };
    private GLFWMouseButtonCallback mouseButtonCallback = new GLFWMouseButtonCallback(){

        public void invoke(long window, int button, int action, int mods) {
            int gdxButton = this.toGdxButton(button);
            if (button != -1 && gdxButton == -1) {
                return;
            }
            Lwjgl3Input.this.updateCurrentEventTime();
            if (action == 1) {
                Lwjgl3Input.this.mousePressed++;
                Lwjgl3Input.this.justTouched = true;
                Lwjgl3Input.this.window.getGraphics().requestRendering();
                Lwjgl3Input.this.eventQueue.touchDown(Lwjgl3Input.this.mouseX, Lwjgl3Input.this.mouseY, 0, gdxButton);
            } else {
                Lwjgl3Input.this.mousePressed = Math.max(0, Lwjgl3Input.this.mousePressed - 1);
                Lwjgl3Input.this.window.getGraphics().requestRendering();
                Lwjgl3Input.this.eventQueue.touchUp(Lwjgl3Input.this.mouseX, Lwjgl3Input.this.mouseY, 0, gdxButton);
            }
        }

        private int toGdxButton(int button) {
            if (button == 0) {
                return 0;
            }
            if (button == 1) {
                return 1;
            }
            if (button == 2) {
                return 2;
            }
            if (button == 3) {
                return 3;
            }
            if (button == 4) {
                return 4;
            }
            return -1;
        }
    };

    private void updateCurrentEventTime() {
        this.currentEventTime = System.nanoTime();
    }

    public Lwjgl3Input(Lwjgl3Window window) {
        this.window = window;
        this.windowHandleChanged(window.getWindowHandle());
    }

    void resetPollingStates() {
        this.justTouched = false;
        this.keyJustPressed = false;
        for (int i = 0; i < this.justPressedKeys.length; ++i) {
            this.justPressedKeys[i] = false;
        }
        this.eventQueue.setProcessor(null);
        this.eventQueue.drain();
    }

    public void windowHandleChanged(long windowHandle) {
        this.resetPollingStates();
        GLFW.glfwSetKeyCallback((long)this.window.getWindowHandle(), (GLFWKeyCallbackI)this.keyCallback);
        GLFW.glfwSetCharCallback((long)this.window.getWindowHandle(), (GLFWCharCallbackI)this.charCallback);
        GLFW.glfwSetScrollCallback((long)this.window.getWindowHandle(), (GLFWScrollCallbackI)this.scrollCallback);
        GLFW.glfwSetCursorPosCallback((long)this.window.getWindowHandle(), (GLFWCursorPosCallbackI)this.cursorPosCallback);
        GLFW.glfwSetMouseButtonCallback((long)this.window.getWindowHandle(), (GLFWMouseButtonCallbackI)this.mouseButtonCallback);
    }

    void update() {
        this.eventQueue.setProcessor(this.inputProcessor);
        this.eventQueue.drain();
    }

    void prepareNext() {
        this.justTouched = false;
        if (this.keyJustPressed) {
            this.keyJustPressed = false;
            for (int i = 0; i < this.justPressedKeys.length; ++i) {
                this.justPressedKeys[i] = false;
            }
        }
        this.deltaX = 0;
        this.deltaY = 0;
    }

    public int getX() {
        return this.mouseX;
    }

    public int getX(int pointer) {
        return pointer == 0 ? this.mouseX : 0;
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public int getDeltaX(int pointer) {
        return pointer == 0 ? this.deltaX : 0;
    }

    public int getY() {
        return this.mouseY;
    }

    public int getY(int pointer) {
        return pointer == 0 ? this.mouseY : 0;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public int getDeltaY(int pointer) {
        return pointer == 0 ? this.deltaY : 0;
    }

    public boolean isTouched() {
        return GLFW.glfwGetMouseButton((long)this.window.getWindowHandle(), (int)0) == 1 || GLFW.glfwGetMouseButton((long)this.window.getWindowHandle(), (int)1) == 1 || GLFW.glfwGetMouseButton((long)this.window.getWindowHandle(), (int)2) == 1 || GLFW.glfwGetMouseButton((long)this.window.getWindowHandle(), (int)3) == 1 || GLFW.glfwGetMouseButton((long)this.window.getWindowHandle(), (int)4) == 1;
    }

    public boolean justTouched() {
        return this.justTouched;
    }

    public boolean isTouched(int pointer) {
        return pointer == 0 ? this.isTouched() : false;
    }

    public boolean isButtonPressed(int button) {
        return GLFW.glfwGetMouseButton((long)this.window.getWindowHandle(), (int)button) == 1;
    }

    public boolean isKeyPressed(int key) {
        if (key == -1) {
            return this.pressedKeys > 0;
        }
        if (key == 63) {
            return GLFW.glfwGetKey((long)this.window.getWindowHandle(), (int)343) == 1 || GLFW.glfwGetKey((long)this.window.getWindowHandle(), (int)347) == 1;
        }
        return GLFW.glfwGetKey((long)this.window.getWindowHandle(), (int)Lwjgl3Input.getGlfwKeyCode(key)) == 1;
    }

    public boolean isKeyJustPressed(int key) {
        if (key == -1) {
            return this.keyJustPressed;
        }
        if (key < 0 || key > 256) {
            return false;
        }
        return this.justPressedKeys[key];
    }

    public void getTextInput(Input.TextInputListener listener, String title, String text, String hint) {
        listener.canceled();
    }

    public long getCurrentEventTime() {
        return this.currentEventTime;
    }

    public void setInputProcessor(InputProcessor processor) {
        this.inputProcessor = processor;
    }

    public InputProcessor getInputProcessor() {
        return this.inputProcessor;
    }

    public void setCursorCatched(boolean catched) {
        GLFW.glfwSetInputMode((long)this.window.getWindowHandle(), (int)208897, (int)(catched ? 212995 : 212993));
    }

    public boolean isCursorCatched() {
        return GLFW.glfwGetInputMode((long)this.window.getWindowHandle(), (int)208897) == 212995;
    }

    public void setCursorPosition(int x, int y) {
        if (this.window.getConfig().hdpiMode == Lwjgl3ApplicationConfiguration.HdpiMode.Pixels) {
            float xScale = (float)this.window.getGraphics().getLogicalWidth() / (float)this.window.getGraphics().getBackBufferWidth();
            float yScale = (float)this.window.getGraphics().getLogicalHeight() / (float)this.window.getGraphics().getBackBufferHeight();
            x = (int)((float)x * xScale);
            y = (int)((float)y * yScale);
        }
        GLFW.glfwSetCursorPos((long)this.window.getWindowHandle(), (double)x, (double)y);
    }

    static char characterForKeyCode(int key) {
        switch (key) {
            case 67: {
                return '\b';
            }
            case 61: {
                return '\t';
            }
            case 112: {
                return '\u007f';
            }
            case 66: {
                return '\n';
            }
        }
        return '\u0000';
    }

    public static int getGdxKeyCode(int lwjglKeyCode) {
        switch (lwjglKeyCode) {
            case 32: {
                return 62;
            }
            case 39: {
                return 75;
            }
            case 44: {
                return 55;
            }
            case 45: {
                return 69;
            }
            case 46: {
                return 56;
            }
            case 47: {
                return 76;
            }
            case 48: {
                return 7;
            }
            case 49: {
                return 8;
            }
            case 50: {
                return 9;
            }
            case 51: {
                return 10;
            }
            case 52: {
                return 11;
            }
            case 53: {
                return 12;
            }
            case 54: {
                return 13;
            }
            case 55: {
                return 14;
            }
            case 56: {
                return 15;
            }
            case 57: {
                return 16;
            }
            case 59: {
                return 74;
            }
            case 61: {
                return 70;
            }
            case 65: {
                return 29;
            }
            case 66: {
                return 30;
            }
            case 67: {
                return 31;
            }
            case 68: {
                return 32;
            }
            case 69: {
                return 33;
            }
            case 70: {
                return 34;
            }
            case 71: {
                return 35;
            }
            case 72: {
                return 36;
            }
            case 73: {
                return 37;
            }
            case 74: {
                return 38;
            }
            case 75: {
                return 39;
            }
            case 76: {
                return 40;
            }
            case 77: {
                return 41;
            }
            case 78: {
                return 42;
            }
            case 79: {
                return 43;
            }
            case 80: {
                return 44;
            }
            case 81: {
                return 45;
            }
            case 82: {
                return 46;
            }
            case 83: {
                return 47;
            }
            case 84: {
                return 48;
            }
            case 85: {
                return 49;
            }
            case 86: {
                return 50;
            }
            case 87: {
                return 51;
            }
            case 88: {
                return 52;
            }
            case 89: {
                return 53;
            }
            case 90: {
                return 54;
            }
            case 91: {
                return 71;
            }
            case 92: {
                return 73;
            }
            case 93: {
                return 72;
            }
            case 96: {
                return 68;
            }
            case 161: 
            case 162: {
                return 0;
            }
            case 256: {
                return 131;
            }
            case 257: {
                return 66;
            }
            case 258: {
                return 61;
            }
            case 259: {
                return 67;
            }
            case 260: {
                return 133;
            }
            case 261: {
                return 112;
            }
            case 262: {
                return 22;
            }
            case 263: {
                return 21;
            }
            case 264: {
                return 20;
            }
            case 265: {
                return 19;
            }
            case 266: {
                return 92;
            }
            case 267: {
                return 93;
            }
            case 268: {
                return 3;
            }
            case 269: {
                return 132;
            }
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: {
                return 0;
            }
            case 290: {
                return 244;
            }
            case 291: {
                return 245;
            }
            case 292: {
                return 246;
            }
            case 293: {
                return 247;
            }
            case 294: {
                return 248;
            }
            case 295: {
                return 249;
            }
            case 296: {
                return 250;
            }
            case 297: {
                return 251;
            }
            case 298: {
                return 252;
            }
            case 299: {
                return 253;
            }
            case 300: {
                return 254;
            }
            case 301: {
                return 255;
            }
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: {
                return 0;
            }
            case 320: {
                return 144;
            }
            case 321: {
                return 145;
            }
            case 322: {
                return 146;
            }
            case 323: {
                return 147;
            }
            case 324: {
                return 148;
            }
            case 325: {
                return 149;
            }
            case 326: {
                return 150;
            }
            case 327: {
                return 151;
            }
            case 328: {
                return 152;
            }
            case 329: {
                return 153;
            }
            case 330: {
                return 56;
            }
            case 331: {
                return 76;
            }
            case 332: {
                return 17;
            }
            case 333: {
                return 69;
            }
            case 334: {
                return 81;
            }
            case 335: {
                return 66;
            }
            case 336: {
                return 70;
            }
            case 340: {
                return 59;
            }
            case 341: {
                return 129;
            }
            case 342: {
                return 57;
            }
            case 343: {
                return 63;
            }
            case 344: {
                return 60;
            }
            case 345: {
                return 130;
            }
            case 346: {
                return 58;
            }
            case 347: {
                return 63;
            }
            case 348: {
                return 82;
            }
        }
        return 0;
    }

    public static int getGlfwKeyCode(int gdxKeyCode) {
        switch (gdxKeyCode) {
            case 62: {
                return 32;
            }
            case 75: {
                return 39;
            }
            case 55: {
                return 44;
            }
            case 56: {
                return 46;
            }
            case 7: {
                return 48;
            }
            case 8: {
                return 49;
            }
            case 9: {
                return 50;
            }
            case 10: {
                return 51;
            }
            case 11: {
                return 52;
            }
            case 12: {
                return 53;
            }
            case 13: {
                return 54;
            }
            case 14: {
                return 55;
            }
            case 15: {
                return 56;
            }
            case 16: {
                return 57;
            }
            case 74: {
                return 59;
            }
            case 70: {
                return 61;
            }
            case 29: {
                return 65;
            }
            case 30: {
                return 66;
            }
            case 31: {
                return 67;
            }
            case 32: {
                return 68;
            }
            case 33: {
                return 69;
            }
            case 34: {
                return 70;
            }
            case 35: {
                return 71;
            }
            case 36: {
                return 72;
            }
            case 37: {
                return 73;
            }
            case 38: {
                return 74;
            }
            case 39: {
                return 75;
            }
            case 40: {
                return 76;
            }
            case 41: {
                return 77;
            }
            case 42: {
                return 78;
            }
            case 43: {
                return 79;
            }
            case 44: {
                return 80;
            }
            case 45: {
                return 81;
            }
            case 46: {
                return 82;
            }
            case 47: {
                return 83;
            }
            case 48: {
                return 84;
            }
            case 49: {
                return 85;
            }
            case 50: {
                return 86;
            }
            case 51: {
                return 87;
            }
            case 52: {
                return 88;
            }
            case 53: {
                return 89;
            }
            case 54: {
                return 90;
            }
            case 71: {
                return 91;
            }
            case 73: {
                return 92;
            }
            case 72: {
                return 93;
            }
            case 68: {
                return 96;
            }
            case 131: {
                return 256;
            }
            case 66: {
                return 257;
            }
            case 61: {
                return 258;
            }
            case 67: {
                return 259;
            }
            case 133: {
                return 260;
            }
            case 112: {
                return 261;
            }
            case 22: {
                return 262;
            }
            case 21: {
                return 263;
            }
            case 20: {
                return 264;
            }
            case 19: {
                return 265;
            }
            case 92: {
                return 266;
            }
            case 93: {
                return 267;
            }
            case 3: {
                return 268;
            }
            case 132: {
                return 269;
            }
            case 244: {
                return 290;
            }
            case 245: {
                return 291;
            }
            case 246: {
                return 292;
            }
            case 247: {
                return 293;
            }
            case 248: {
                return 294;
            }
            case 249: {
                return 295;
            }
            case 250: {
                return 296;
            }
            case 251: {
                return 297;
            }
            case 252: {
                return 298;
            }
            case 253: {
                return 299;
            }
            case 254: {
                return 300;
            }
            case 255: {
                return 301;
            }
            case 144: {
                return 320;
            }
            case 145: {
                return 321;
            }
            case 146: {
                return 322;
            }
            case 147: {
                return 323;
            }
            case 148: {
                return 324;
            }
            case 149: {
                return 325;
            }
            case 150: {
                return 326;
            }
            case 151: {
                return 327;
            }
            case 152: {
                return 328;
            }
            case 153: {
                return 329;
            }
            case 76: {
                return 331;
            }
            case 17: {
                return 332;
            }
            case 69: {
                return 333;
            }
            case 81: {
                return 334;
            }
            case 59: {
                return 340;
            }
            case 129: {
                return 341;
            }
            case 57: {
                return 342;
            }
            case 63: {
                return 343;
            }
            case 60: {
                return 344;
            }
            case 130: {
                return 345;
            }
            case 58: {
                return 346;
            }
            case 82: {
                return 348;
            }
        }
        return 0;
    }

    public void dispose() {
        this.keyCallback.free();
        this.charCallback.free();
        this.scrollCallback.free();
        this.cursorPosCallback.free();
        this.mouseButtonCallback.free();
    }

    public void setCatchBackKey(boolean catchBack) {
    }

    public boolean isCatchBackKey() {
        return false;
    }

    public void setCatchMenuKey(boolean catchMenu) {
    }

    public boolean isCatchMenuKey() {
        return false;
    }

    public float getAccelerometerX() {
        return 0.0f;
    }

    public float getAccelerometerY() {
        return 0.0f;
    }

    public float getAccelerometerZ() {
        return 0.0f;
    }

    public boolean isPeripheralAvailable(Input.Peripheral peripheral) {
        return peripheral == Input.Peripheral.HardwareKeyboard;
    }

    public int getRotation() {
        return 0;
    }

    public Input.Orientation getNativeOrientation() {
        return Input.Orientation.Landscape;
    }

    public void setOnscreenKeyboardVisible(boolean visible) {
    }

    public void vibrate(int milliseconds) {
    }

    public void vibrate(long[] pattern, int repeat) {
    }

    public void cancelVibrate() {
    }

    public float getAzimuth() {
        return 0.0f;
    }

    public float getPitch() {
        return 0.0f;
    }

    public float getRoll() {
        return 0.0f;
    }

    public void getRotationMatrix(float[] matrix) {
    }

    public float getGyroscopeX() {
        return 0.0f;
    }

    public float getGyroscopeY() {
        return 0.0f;
    }

    public float getGyroscopeZ() {
        return 0.0f;
    }
}

