/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.iosrobovm.objectal.AVAudioPlayerDelegateAdapter;
import com.badlogic.gdx.backends.iosrobovm.objectal.OALAudioTrack;
import org.robovm.apple.foundation.NSObject;

public class IOSMusic
implements Music {
    private final OALAudioTrack track;
    private final String filePath;
    private boolean initialized;
    private boolean looping;
    Music.OnCompletionListener onCompletionListener;

    public IOSMusic(OALAudioTrack track, String filePath) {
        this.track = track;
        this.filePath = filePath;
        this.track.setDelegate(new AVAudioPlayerDelegateAdapter(){

            @Override
            public void didFinishPlaying(NSObject player, boolean success) {
                final Music.OnCompletionListener listener = IOSMusic.this.onCompletionListener;
                if (listener != null) {
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            listener.onCompletion((Music)IOSMusic.this);
                        }
                    });
                }
            }
        });
    }

    public void play() {
        if (this.track.isPaused()) {
            this.track.setPaused(false);
        } else if (!this.track.isPlaying()) {
            if (!this.initialized) {
                this.initialized = !this.looping ? this.track.playFile(this.filePath) : this.track.playFile(this.filePath, -1);
                if (!this.initialized) {
                    Gdx.app.error("IOSMusic", "Unable to initialize music " + this.filePath);
                }
            } else {
                this.track.play();
            }
        }
    }

    public void pause() {
        if (this.track.isPlaying()) {
            this.track.setPaused(true);
        }
    }

    public void stop() {
        this.track.stop();
    }

    public boolean isPlaying() {
        return this.track.isPlaying() && !this.track.isPaused();
    }

    public void setLooping(boolean isLooping) {
        this.track.setNumberOfLoops(isLooping ? -1 : 0);
        this.looping = isLooping;
    }

    public boolean isLooping() {
        return this.track.getNumberOfLoops() == -1;
    }

    public void setVolume(float volume) {
        this.track.setVolume(volume);
    }

    public void setPosition(float position) {
        this.track.setCurrentTime(position);
    }

    public float getPosition() {
        return (float)this.track.getCurrentTime();
    }

    public void dispose() {
        this.track.clear();
    }

    public float getVolume() {
        return this.track.getVolume();
    }

    public void setPan(float pan, float volume) {
        this.track.setPan(pan);
        this.track.setVolume(volume);
    }

    public void setOnCompletionListener(Music.OnCompletionListener listener) {
        this.onCompletionListener = listener;
    }

    public boolean preload() {
        this.initialized = this.track.preloadFile(this.filePath);
        return this.initialized;
    }
}

