/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.ApplicationLogger;
import com.badlogic.gdx.Audio;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.LifecycleListener;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.backends.iosrobovm.DefaultIOSInput;
import com.badlogic.gdx.backends.iosrobovm.IOSApplicationConfiguration;
import com.badlogic.gdx.backends.iosrobovm.IOSApplicationLogger;
import com.badlogic.gdx.backends.iosrobovm.IOSAudio;
import com.badlogic.gdx.backends.iosrobovm.IOSFiles;
import com.badlogic.gdx.backends.iosrobovm.IOSGraphics;
import com.badlogic.gdx.backends.iosrobovm.IOSInput;
import com.badlogic.gdx.backends.iosrobovm.IOSNet;
import com.badlogic.gdx.backends.iosrobovm.IOSPreferences;
import com.badlogic.gdx.backends.iosrobovm.IOSViewControllerListener;
import com.badlogic.gdx.backends.iosrobovm.objectal.OALAudioSession;
import com.badlogic.gdx.backends.iosrobovm.objectal.OALIOSAudio;
import com.badlogic.gdx.backends.iosrobovm.objectal.OALSimpleAudio;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Clipboard;
import java.io.File;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSProcessInfo;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.uikit.UIApplication;
import org.robovm.apple.uikit.UIApplicationDelegateAdapter;
import org.robovm.apple.uikit.UIApplicationLaunchOptions;
import org.robovm.apple.uikit.UIDevice;
import org.robovm.apple.uikit.UIInterfaceOrientation;
import org.robovm.apple.uikit.UIPasteboard;
import org.robovm.apple.uikit.UIScreen;
import org.robovm.apple.uikit.UIUserInterfaceIdiom;
import org.robovm.apple.uikit.UIViewController;
import org.robovm.apple.uikit.UIWindow;
import org.robovm.rt.bro.Bro;

public class IOSApplication
implements Application {
    UIApplication uiApp;
    UIWindow uiWindow;
    ApplicationListener listener;
    IOSViewControllerListener viewControllerListener;
    IOSApplicationConfiguration config;
    IOSGraphics graphics;
    IOSAudio audio;
    IOSFiles files;
    IOSInput input;
    IOSNet net;
    int logLevel = 3;
    ApplicationLogger applicationLogger;
    float displayScaleFactor;
    private CGRect lastScreenBounds = null;
    Array<Runnable> runnables = new Array();
    Array<Runnable> executedRunnables = new Array();
    Array<LifecycleListener> lifecycleListeners = new Array();

    public IOSApplication(ApplicationListener listener, IOSApplicationConfiguration config) {
        this.listener = listener;
        this.config = config;
    }

    final boolean didFinishLaunching(UIApplication uiApp, UIApplicationLaunchOptions options) {
        this.setApplicationLogger(new IOSApplicationLogger());
        Gdx.app = this;
        this.uiApp = uiApp;
        UIApplication.getSharedApplication().setIdleTimerDisabled(this.config.preventScreenDimming);
        Gdx.app.debug("IOSApplication", "iOS version: " + UIDevice.getCurrentDevice().getSystemVersion());
        Gdx.app.debug("IOSApplication", "Running in " + (Bro.IS_64BIT ? "64-bit" : "32-bit") + " mode");
        float scale = (float)UIScreen.getMainScreen().getNativeScale();
        if (scale >= 2.0f) {
            Gdx.app.debug("IOSApplication", "scale: " + scale);
            this.displayScaleFactor = UIDevice.getCurrentDevice().getUserInterfaceIdiom() == UIUserInterfaceIdiom.Pad ? this.config.displayScaleLargeScreenIfRetina * scale : this.config.displayScaleSmallScreenIfRetina * scale;
        } else {
            this.displayScaleFactor = UIDevice.getCurrentDevice().getUserInterfaceIdiom() == UIUserInterfaceIdiom.Pad ? this.config.displayScaleLargeScreenIfNonRetina : this.config.displayScaleSmallScreenIfNonRetina;
        }
        this.input = this.createInput();
        this.graphics = this.createGraphics(scale);
        Gdx.gl = Gdx.gl20 = this.graphics.gl20;
        Gdx.gl30 = this.graphics.gl30;
        this.files = new IOSFiles();
        this.audio = this.createAudio(this.config);
        this.net = new IOSNet(this, this.config);
        Gdx.files = this.files;
        Gdx.graphics = this.graphics;
        Gdx.audio = this.audio;
        Gdx.input = this.input;
        Gdx.net = this.net;
        this.input.setupPeripherals();
        this.uiWindow = new UIWindow(UIScreen.getMainScreen().getBounds());
        this.uiWindow.setRootViewController((UIViewController)this.graphics.viewController);
        this.uiWindow.makeKeyAndVisible();
        Gdx.app.debug("IOSApplication", "created");
        return true;
    }

    protected IOSAudio createAudio(IOSApplicationConfiguration config) {
        return new OALIOSAudio(config);
    }

    protected IOSGraphics createGraphics(float scale) {
        return new IOSGraphics(scale, this, this.config, this.input, this.config.useGL30);
    }

    protected IOSGraphics.IOSUIViewController createUIViewController(IOSGraphics graphics) {
        return new IOSGraphics.IOSUIViewController(this, graphics);
    }

    protected IOSInput createInput() {
        return new DefaultIOSInput(this);
    }

    public UIViewController getUIViewController() {
        return this.graphics.viewController;
    }

    public UIWindow getUIWindow() {
        return this.uiWindow;
    }

    protected CGRect getBounds() {
        CGRect screenBounds = UIScreen.getMainScreen().getBounds();
        CGRect statusBarFrame = this.uiApp.getStatusBarFrame();
        UIInterfaceOrientation statusBarOrientation = this.uiApp.getStatusBarOrientation();
        double statusBarHeight = Math.min(statusBarFrame.getWidth(), statusBarFrame.getHeight());
        double screenWidth = screenBounds.getWidth();
        double screenHeight = screenBounds.getHeight();
        switch (statusBarOrientation) {
            case LandscapeLeft: 
            case LandscapeRight: {
                if (!(screenHeight > screenWidth)) break;
                this.debug("IOSApplication", "Switching reported width and height (w=" + screenWidth + " h=" + screenHeight + ")");
                double tmp = screenHeight;
                screenHeight = screenWidth;
                screenWidth = tmp;
            }
        }
        screenWidth *= (double)this.displayScaleFactor;
        screenHeight *= (double)this.displayScaleFactor;
        if (statusBarHeight != 0.0) {
            this.debug("IOSApplication", "Status bar is visible (height = " + statusBarHeight + ")");
            screenHeight -= (statusBarHeight *= (double)this.displayScaleFactor);
        } else {
            this.debug("IOSApplication", "Status bar is not visible");
        }
        this.debug("IOSApplication", "Total computed bounds are w=" + screenWidth + " h=" + screenHeight);
        this.lastScreenBounds = new CGRect(0.0, statusBarHeight, screenWidth, screenHeight);
        return this.lastScreenBounds;
    }

    protected CGRect getCachedBounds() {
        if (this.lastScreenBounds == null) {
            return this.getBounds();
        }
        return this.lastScreenBounds;
    }

    final void didBecomeActive(UIApplication uiApp) {
        OALSimpleAudio audio;
        Gdx.app.debug("IOSApplication", "resumed");
        OALAudioSession audioSession = OALAudioSession.sharedInstance();
        if (audioSession != null) {
            audioSession.forceEndInterruption();
        }
        if (this.config.allowIpod && (audio = OALSimpleAudio.sharedInstance()) != null) {
            audio.setUseHardwareIfAvailable(false);
        }
        this.graphics.makeCurrent();
        this.graphics.resume();
    }

    final void willEnterForeground(UIApplication uiApp) {
        OALAudioSession audioSession = OALAudioSession.sharedInstance();
        if (audioSession != null) {
            audioSession.forceEndInterruption();
        }
    }

    final void willResignActive(UIApplication uiApp) {
        Gdx.app.debug("IOSApplication", "paused");
        this.graphics.makeCurrent();
        this.graphics.pause();
        Gdx.gl.glFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void willTerminate(UIApplication uiApp) {
        Array<LifecycleListener> listeners;
        Gdx.app.debug("IOSApplication", "disposed");
        this.graphics.makeCurrent();
        Array<LifecycleListener> array = listeners = this.lifecycleListeners;
        synchronized (array) {
            for (LifecycleListener listener : listeners) {
                listener.pause();
            }
        }
        this.listener.dispose();
        Gdx.gl.glFinish();
    }

    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public Audio getAudio() {
        return this.audio;
    }

    public Input getInput() {
        return this.input;
    }

    public Files getFiles() {
        return this.files;
    }

    public Net getNet() {
        return this.net;
    }

    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(tag, message);
        }
    }

    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            this.getApplicationLogger().debug(tag, message, exception);
        }
    }

    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(tag, message);
        }
    }

    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            this.getApplicationLogger().log(tag, message, exception);
        }
    }

    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(tag, message);
        }
    }

    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            this.getApplicationLogger().error(tag, message, exception);
        }
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setApplicationLogger(ApplicationLogger applicationLogger) {
        this.applicationLogger = applicationLogger;
    }

    public ApplicationLogger getApplicationLogger() {
        return this.applicationLogger;
    }

    public Application.ApplicationType getType() {
        return Application.ApplicationType.iOS;
    }

    public int getVersion() {
        return (int)NSProcessInfo.getSharedProcessInfo().getOperatingSystemVersion().getMajorVersion();
    }

    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public long getNativeHeap() {
        return this.getJavaHeap();
    }

    public Preferences getPreferences(String name) {
        File libraryPath = new File(System.getenv("HOME"), "Library");
        File finalPath = new File(libraryPath, name + ".plist");
        NSMutableDictionary nsDictionary = NSMutableDictionary.read((File)finalPath);
        if (nsDictionary == null) {
            nsDictionary = new NSMutableDictionary();
            nsDictionary.write(finalPath, false);
        }
        return new IOSPreferences((NSMutableDictionary<NSString, NSObject>)nsDictionary, finalPath.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add((Object)runnable);
            Gdx.graphics.requestRendering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRunnables() {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.executedRunnables.clear();
            this.executedRunnables.addAll(this.runnables);
            this.runnables.clear();
        }
        for (int i = 0; i < this.executedRunnables.size; ++i) {
            try {
                ((Runnable)this.executedRunnables.get(i)).run();
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void exit() {
        System.exit(0);
    }

    public Clipboard getClipboard() {
        return new Clipboard(){

            public void setContents(String content) {
                UIPasteboard.getGeneralPasteboard().setString(content);
            }

            public String getContents() {
                return UIPasteboard.getGeneralPasteboard().getString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue((Object)listener, true);
        }
    }

    public void addViewControllerListener(IOSViewControllerListener listener) {
        this.viewControllerListener = listener;
    }

    public static abstract class Delegate
    extends UIApplicationDelegateAdapter {
        private IOSApplication app;

        protected abstract IOSApplication createApplication();

        public boolean didFinishLaunching(UIApplication application, UIApplicationLaunchOptions launchOptions) {
            application.addStrongRef((Object)this);
            this.app = this.createApplication();
            return this.app.didFinishLaunching(application, launchOptions);
        }

        public void didBecomeActive(UIApplication application) {
            this.app.didBecomeActive(application);
        }

        public void willEnterForeground(UIApplication application) {
            this.app.willEnterForeground(application);
        }

        public void willResignActive(UIApplication application) {
            this.app.willResignActive(application);
        }

        public void willTerminate(UIApplication application) {
            this.app.willTerminate(application);
        }
    }
}

