/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.backends.iosrobovm.IOSFileHandle;
import com.badlogic.gdx.files.FileHandle;
import org.robovm.apple.foundation.NSBundle;

public class IOSFiles
implements Files {
    static final String appDir = System.getenv("HOME");
    static final String externalPath = appDir + "/Documents/";
    static final String localPath = appDir + "/Library/local/";
    static final String internalPath = NSBundle.getMainBundle().getBundlePath();

    public IOSFiles() {
        new FileHandle(externalPath).mkdirs();
        new FileHandle(localPath).mkdirs();
    }

    public FileHandle getFileHandle(String fileName, Files.FileType type) {
        return new IOSFileHandle(fileName, type);
    }

    public FileHandle classpath(String path) {
        return new IOSFileHandle(path, Files.FileType.Classpath);
    }

    public FileHandle internal(String path) {
        return new IOSFileHandle(path, Files.FileType.Internal);
    }

    public FileHandle external(String path) {
        return new IOSFileHandle(path, Files.FileType.External);
    }

    public FileHandle absolute(String path) {
        return new IOSFileHandle(path, Files.FileType.Absolute);
    }

    public FileHandle local(String path) {
        return new IOSFileHandle(path, Files.FileType.Local);
    }

    public String getExternalStoragePath() {
        return externalPath;
    }

    public boolean isExternalStorageAvailable() {
        return true;
    }

    public String getLocalStoragePath() {
        return localPath;
    }

    public boolean isLocalStorageAvailable() {
        return true;
    }
}

