/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.backends.iosrobovm.objectal.AVAudioPlayerDelegateAdapter;
import com.badlogic.gdx.backends.iosrobovm.objectal.OALAudioTrack;
import org.robovm.apple.foundation.NSObject;

public class IOSMusic
implements Music {
    private final OALAudioTrack track;
    Music.OnCompletionListener onCompletionListener;

    public IOSMusic(OALAudioTrack track) {
        this.track = track;
        this.track.setDelegate(new AVAudioPlayerDelegateAdapter(){

            @Override
            public void didFinishPlaying(NSObject player, boolean success) {
                final Music.OnCompletionListener listener = IOSMusic.this.onCompletionListener;
                if (listener != null) {
                    Gdx.app.postRunnable(new Runnable(){

                        @Override
                        public void run() {
                            listener.onCompletion((Music)IOSMusic.this);
                        }
                    });
                }
            }
        });
    }

    public void play() {
        if (this.track.isPaused()) {
            this.track.setPaused(false);
        } else if (!this.track.isPlaying()) {
            this.track.play();
        }
    }

    public void pause() {
        if (this.track.isPlaying()) {
            this.track.setPaused(true);
        }
    }

    public void stop() {
        this.track.stop();
    }

    public boolean isPlaying() {
        return this.track.isPlaying() && !this.track.isPaused();
    }

    public void setLooping(boolean isLooping) {
        this.track.setNumberOfLoops(isLooping ? -1 : 0);
    }

    public boolean isLooping() {
        return this.track.getNumberOfLoops() == -1;
    }

    public void setVolume(float volume) {
        this.track.setVolume(volume);
    }

    public void setPosition(float position) {
        this.track.setCurrentTime(position);
    }

    public float getPosition() {
        return (float)this.track.getCurrentTime();
    }

    public void dispose() {
        this.track.clear();
    }

    public float getVolume() {
        return this.track.getVolume();
    }

    public void setPan(float pan, float volume) {
        this.track.setPan(pan);
        this.track.setVolume(volume);
    }

    public void setOnCompletionListener(Music.OnCompletionListener listener) {
        this.onCompletionListener = listener;
    }
}

