/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.iosrobovm.objectal;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.AudioDevice;
import com.badlogic.gdx.audio.AudioRecorder;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.backends.iosrobovm.IOSApplicationConfiguration;
import com.badlogic.gdx.backends.iosrobovm.IOSAudio;
import com.badlogic.gdx.backends.iosrobovm.IOSMusic;
import com.badlogic.gdx.backends.iosrobovm.IOSSound;
import com.badlogic.gdx.backends.iosrobovm.objectal.OALAudioTrack;
import com.badlogic.gdx.backends.iosrobovm.objectal.OALSimpleAudio;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class OALIOSAudio
implements IOSAudio {
    public OALIOSAudio(IOSApplicationConfiguration config) {
        if (!config.useAudio) {
            return;
        }
        OALSimpleAudio audio = OALSimpleAudio.sharedInstance();
        if (audio != null) {
            audio.setAllowIpod(config.allowIpod);
            audio.setHonorSilentSwitch(!config.overrideRingerSwitch);
        } else {
            Gdx.app.error("IOSAudio", "No OALSimpleAudio instance available, audio will not be availabe");
        }
    }

    public AudioDevice newAudioDevice(int samplingRate, boolean isMono) {
        return null;
    }

    public AudioRecorder newAudioRecorder(int samplingRate, boolean isMono) {
        return null;
    }

    public Sound newSound(FileHandle fileHandle) {
        return new IOSSound(fileHandle);
    }

    public Music newMusic(FileHandle fileHandle) {
        String path = fileHandle.file().getPath().replace('\\', '/');
        OALAudioTrack track = OALAudioTrack.create();
        if (track != null && track.preloadFile(path)) {
            return new IOSMusic(track);
        }
        throw new GdxRuntimeException("Error opening music file at " + path);
    }
}

