/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.physics.bullet.collision;

import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.bullet.BulletBase;
import com.badlogic.gdx.physics.bullet.collision.CollisionJNI;
import com.badlogic.gdx.physics.bullet.linearmath.btVector3;

public class GIM_CONTACT
extends BulletBase {
    private long swigCPtr;

    protected GIM_CONTACT(String className, long cPtr, boolean cMemoryOwn) {
        super(className, cPtr, cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    public GIM_CONTACT(long cPtr, boolean cMemoryOwn) {
        this("GIM_CONTACT", cPtr, cMemoryOwn);
        this.construct();
    }

    @Override
    protected void reset(long cPtr, boolean cMemoryOwn) {
        if (!this.destroyed) {
            this.destroy();
        }
        this.swigCPtr = cPtr;
        super.reset(this.swigCPtr, cMemoryOwn);
    }

    public static long getCPtr(GIM_CONTACT obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() throws Throwable {
        if (!this.destroyed) {
            this.destroy();
        }
        super.finalize();
    }

    @Override
    protected synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                CollisionJNI.delete_GIM_CONTACT(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setPoint(btVector3 value) {
        CollisionJNI.GIM_CONTACT_point_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getPoint() {
        long cPtr = CollisionJNI.GIM_CONTACT_point_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setNormal(btVector3 value) {
        CollisionJNI.GIM_CONTACT_normal_set(this.swigCPtr, this, btVector3.getCPtr(value), value);
    }

    public btVector3 getNormal() {
        long cPtr = CollisionJNI.GIM_CONTACT_normal_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new btVector3(cPtr, false);
    }

    public void setDepth(float value) {
        CollisionJNI.GIM_CONTACT_depth_set(this.swigCPtr, this, value);
    }

    public float getDepth() {
        return CollisionJNI.GIM_CONTACT_depth_get(this.swigCPtr, this);
    }

    public void setDistance(float value) {
        CollisionJNI.GIM_CONTACT_distance_set(this.swigCPtr, this, value);
    }

    public float getDistance() {
        return CollisionJNI.GIM_CONTACT_distance_get(this.swigCPtr, this);
    }

    public void setFeature1(int value) {
        CollisionJNI.GIM_CONTACT_feature1_set(this.swigCPtr, this, value);
    }

    public int getFeature1() {
        return CollisionJNI.GIM_CONTACT_feature1_get(this.swigCPtr, this);
    }

    public void setFeature2(int value) {
        CollisionJNI.GIM_CONTACT_feature2_set(this.swigCPtr, this, value);
    }

    public int getFeature2() {
        return CollisionJNI.GIM_CONTACT_feature2_get(this.swigCPtr, this);
    }

    public GIM_CONTACT() {
        this(CollisionJNI.new_GIM_CONTACT__SWIG_0(), true);
    }

    public GIM_CONTACT(GIM_CONTACT contact) {
        this(CollisionJNI.new_GIM_CONTACT__SWIG_1(GIM_CONTACT.getCPtr(contact), contact), true);
    }

    public GIM_CONTACT(Vector3 point, Vector3 normal, float depth, int feature1, int feature2) {
        this(CollisionJNI.new_GIM_CONTACT__SWIG_2(point, normal, depth, feature1, feature2), true);
    }

    public long calc_key_contact() {
        return CollisionJNI.GIM_CONTACT_calc_key_contact(this.swigCPtr, this);
    }

    public void interpolate_normals(btVector3 normals, int normal_count) {
        CollisionJNI.GIM_CONTACT_interpolate_normals(this.swigCPtr, this, btVector3.getCPtr(normals), normals, normal_count);
    }
}

